/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.landp.device;

import com.ibm.landp.BadRouterRCException;
import com.ibm.landp.BadServerRCException;
import com.ibm.landp.Cprb;
import com.ibm.landp.InvalidCprbException;
import com.ibm.landp.LandpCommunicationException;
import com.ibm.landp.LandpException;
import com.ibm.landp.LandpUtils;
import com.ibm.landp.RmtReq;
import com.ibm.landp.device.internal.LandpDeviceService;
import com.ibm.landp.device.internal.msd.ILandpMagStripeService;
import com.ibm.landp.device.internal.msd.ReadTracksJob;
import com.ibm.landp.device.internal.msd.WriteTracksJob;
import com.jxfs.control.msd.JxfsMSDReadData;
import com.jxfs.control.msd.JxfsMSDTrackSelection;
import com.jxfs.control.msd.JxfsMSDTracks;
import com.jxfs.events.JxfsException;
import com.jxfs.events.OperationCompleteEvent;
import com.jxfs.forum.support.CloseJob;
import com.jxfs.forum.support.IJxfsServiceJob;
import com.jxfs.forum.support.IQueueResponse;
import com.jxfs.forum.support.OpenJob;
import com.jxfs.forum.support.QueueControl;
import com.jxfs.general.JxfsLogger;
import com.jxfs.general.JxfsMediaStatus;
import com.jxfs.general.JxfsStatus;
import com.jxfs.service.IJxfsMagStripeService;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;

public class LandpIBM47xxMSD
extends LandpDeviceService
implements IJxfsMagStripeService,
IQueueResponse,
ILandpMagStripeService {
    public static final String copyrightNotice = "5639-I90 (C) Copyright IBM Corp. 1990, 2000 All Rights Reserved. US Government Users Restricted Rights. Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. Licensed Material - Property of IBM";
    private JxfsMSDTracks supportedReadTracks;
    private JxfsMSDTracks supportedWriteTracks;
    String timeout;

    public LandpIBM47xxMSD() {
        this.subclass = "LandpIBM47xxMSR";
        this.physicalDeviceDescription = "IBM 47xx MSR";
        this.physicalDeviceName = "47xx";
        LandpDeviceService.ORIGIN = "LDP_MSD";
        LandpDeviceService.DESCRIPTION = "Landp - 47xx MSD Device";
        this.logger = JxfsLogger.getReference();
        this.logger.registerModule(LandpDeviceService.ORIGIN, LandpDeviceService.DESCRIPTION);
        int n = 1;
        this.queue = new QueueControl(n);
        this.status = new JxfsStatus();
    }

    public int open(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".open(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        int n2 = this.queue.open((IJxfsServiceJob)new OpenJob((IQueueResponse)this, n));
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".open returns identification_id:" + n2);
        }
        return n2;
    }

    public int close(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".close(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        int n2 = this.queue.close((IJxfsServiceJob)new CloseJob((IQueueResponse)this, n));
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".close returns identification_id:" + n2);
        }
        return n2;
    }

    public boolean claim(int n, int n2) throws JxfsException {
        boolean bl;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".claim(timeout:" + n + ", control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        this.status.setClaimPending(true);
        try {
            bl = this.queue.claim(n, n2, (IQueueResponse)this);
        }
        catch (JxfsException jxfsException) {
            this.status.setClaimPending(false);
            throw jxfsException;
        }
        if (bl) {
            this.status.setClaimed(true);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".claim returns success:" + bl);
        }
        return bl;
    }

    public boolean release(int n, int n2) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".release(timeout:" + n + ", control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        boolean bl = this.queue.release(n, n2, (IQueueResponse)this);
        if (bl) {
            this.status.setClaimed(false);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".release returns success:" + bl);
        }
        return bl;
    }

    public void cancel(int n, int n2) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".cancel(identification_id:" + n + ", control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        boolean bl = this.queue.cancelJob(n, true);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".cancel: cancelJob returns with:" + bl);
        }
    }

    public int getDeviceType(int n) throws JxfsException {
        return 4001;
    }

    public int readData(JxfsMSDTrackSelection jxfsMSDTrackSelection, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readData(tracksToRead:" + jxfsMSDTrackSelection + ", control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n)) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (!jxfsMSDTrackSelection.isTrack1() && !jxfsMSDTrackSelection.isTrack2() && jxfsMSDTrackSelection.isTrack3()) {
            throw new JxfsException(4017);
        }
        if (jxfsMSDTrackSelection.isTrack1() && !this.supportedReadTracks.isTrack1() || jxfsMSDTrackSelection.isTrack2() && !this.supportedReadTracks.isTrack2() || jxfsMSDTrackSelection.isTrack3() && !this.supportedReadTracks.isTrack3()) {
            throw new JxfsException(4016);
        }
        ReadTracksJob readTracksJob = new ReadTracksJob(this, jxfsMSDTrackSelection, n);
        int n2 = this.queue.addJob((IJxfsServiceJob)readTracksJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readData returns with identification_id:" + n2);
        }
        return n2;
    }

    public int writeData(Vector vector, boolean bl, int n) throws JxfsException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (vector.elementAt(0) != null) {
            string = new String((byte[])vector.elementAt(0));
        }
        if (vector.elementAt(1) != null) {
            string2 = new String((byte[])vector.elementAt(1));
        }
        if (vector.elementAt(2) != null) {
            string3 = new String((byte[])vector.elementAt(2));
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".writeData(wdata(track1:" + string + " track2:" + string2 + " track3:" + string3 + "), newCard:" + bl + ", control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n)) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (vector.elementAt(0) == null && vector.elementAt(1) == null && vector.elementAt(2) == null) {
            throw new JxfsException(4017);
        }
        if (vector.elementAt(0) != null && !this.supportedWriteTracks.isTrack1() || vector.elementAt(1) != null && !this.supportedWriteTracks.isTrack2() || vector.elementAt(2) != null && !this.supportedWriteTracks.isTrack3()) {
            throw new JxfsException(4016);
        }
        WriteTracksJob writeTracksJob = new WriteTracksJob(this, vector, n);
        int n2 = this.queue.addJob((IJxfsServiceJob)writeTracksJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".writeData returns with identification_id:" + n2);
        }
        return n2;
    }

    public JxfsMediaStatus getMediaStatus(int n) throws JxfsException {
        return new JxfsMediaStatus(0);
    }

    public JxfsMSDTracks getSupportedReadTracks(int n) throws JxfsException {
        return this.supportedReadTracks;
    }

    public JxfsMSDTracks getSupportedWriteTracks(int n) throws JxfsException {
        return this.supportedWriteTracks;
    }

    public boolean checkInternal() {
        return true;
    }

    public synchronized void openInternal(IJxfsServiceJob iJxfsServiceJob) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".openInternal(control_id:" + iJxfsServiceJob.getControlId() + ")");
        }
        if (this.openCount == 0) {
            boolean bl = this.initializePhysically(iJxfsServiceJob.getControlId());
            if (bl) {
                ++this.openCount;
                this.status.setOpen(true);
                this.sendOperationComplete(iJxfsServiceJob);
            } else {
                this.status.setOpen(false);
                this.sendOperationComplete(iJxfsServiceJob, 1019);
            }
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".openInternal returns, openCount is:" + this.openCount + ")");
        }
    }

    public synchronized void closeInternal(IJxfsServiceJob iJxfsServiceJob) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".closeInternal(control_id:" + iJxfsServiceJob.getControlId() + ")");
        }
        if (this.openCount == 1) {
            this.status.setOpen(false);
        }
        --this.openCount;
        this.sendOperationComplete(iJxfsServiceJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".closeInternal returns, openCount is:" + this.openCount + ")");
        }
    }

    public synchronized void claimInternal(int n) {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".claimInternal(control_id:" + n + ")");
        }
    }

    public synchronized void releaseInternal(int n) {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".releaseInternal(control_id:" + n + ")");
        }
    }

    public synchronized void readInternal(ReadTracksJob readTracksJob, JxfsMSDTrackSelection jxfsMSDTrackSelection) {
        JxfsMSDReadData jxfsMSDReadData;
        int n;
        BitSet bitSet;
        String string;
        int[] nArray = new int[]{4060, 4060, 4060};
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readInternal(control_id:" + readTracksJob.getControlId() + ", identification_id:" + readTracksJob.getIdentificationID() + ", tracksToRead:" + jxfsMSDTrackSelection + ")");
        }
        this.status.setBusy(true);
        JxfsMSDTracks jxfsMSDTracks = new JxfsMSDTracks(jxfsMSDTrackSelection.isTrack1(), jxfsMSDTrackSelection.isTrack2(), jxfsMSDTrackSelection.isTrack3());
        Vector<byte[]> vector = new Vector<byte[]>(3);
        int n2 = 0;
        while (n2 < 3) {
            vector.addElement(null);
            ++n2;
        }
        RmtReq rmtReq = (RmtReq)this.controls.get(new Integer(readTracksJob.getControlId()));
        Cprb cprb = new Cprb(this.landpServer, "OP");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        if (this.landpServer.startsWith("PINP47")) {
            string = "S";
            cprb.setQParm(string.getBytes());
        }
        rmtReq.setCprb(cprb);
        try {
            try {
                cprb = rmtReq.send();
                bitSet = new BitSet(8);
                int n3 = 0;
                if (jxfsMSDTracks.isTrack1()) {
                    bitSet.set(2);
                    ++n3;
                }
                if (jxfsMSDTracks.isTrack2()) {
                    bitSet.set(1);
                    ++n3;
                }
                if (jxfsMSDTracks.isTrack3()) {
                    bitSet.set(0);
                    ++n3;
                }
                cprb.setFunctionID("AT");
                byte[] byArray = new byte[4];
                byArray[1] = this.bits2Byte(bitSet);
                byArray[3] = (byte)(byArray[3] | 1);
                cprb.setQParm(byArray);
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                cprb.setFunctionID("WM");
                cprb.setServerName("SPV");
                cprb.setQParmLength(7);
                byArray = new byte[7];
                byArray[0] = 84;
                byArray[6] = Byte.decode(this.timeout);
                cprb.setQParm(byArray);
                cprb.setQDataLength(10);
                String string2 = null;
                string2 = this.landpServer.startsWith("PINP47") ? "SR" + this.landpServer : "DR" + this.landpServer;
                cprb.setQData(string2.getBytes());
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                byte[] byArray2 = cprb.getRParm();
                if (byArray2[0] == 69 && byArray2[1] == 84) {
                    n = 4010;
                } else {
                    cprb.setFunctionID("RD");
                    cprb.setServerName(this.landpServer);
                    cprb.setQParmLength(26);
                    cprb.setQParm(new byte[26]);
                    cprb.setQDataLength(0);
                    cprb.setRDataLength(100);
                    rmtReq.setCprb(cprb);
                    cprb = rmtReq.send();
                    byte[] byArray3 = cprb.getRData();
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3) {
                        byte by = byArray3[n4];
                        int n6 = n4 + 1;
                        byte by2 = byArray3[n6];
                        int n7 = 0;
                        if ((by2 & 4) != 0) {
                            n7 = 1;
                        } else if ((by2 & 2) != 0) {
                            n7 = 2;
                        } else if ((by2 & 1) != 0) {
                            n7 = 3;
                        }
                        if (by == 1) {
                            if ((by2 & 0x80) != 0) {
                                nArray[n7 - 1] = 4060;
                            }
                            if ((by2 & 0x40) != 0) {
                                nArray[n7 - 1] = 4057;
                            }
                        } else if (by != 3) {
                            ++n6;
                            byte[] byArray4 = new byte[by - 3];
                            ++n6;
                            int n8 = 0;
                            while (n8 < by - 3) {
                                byArray4[n8] = byArray3[n6++];
                                ++n8;
                            }
                            nArray[n7 - 1] = 0;
                            vector.setElementAt(byArray4, n7 - 1);
                        }
                        n4 += by + 1;
                        ++n5;
                    }
                    n = 0;
                }
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
                }
                n = 4007;
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
                }
                n = 4007;
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
                }
                n = 4007;
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
                }
                n = 4007;
            }
            jxfsMSDReadData = null;
        }
        catch (Throwable throwable) {
            Object var11_34 = null;
            Cprb cprb2 = new Cprb(this.landpServer, "KL");
            cprb2.setQParmLength(26);
            cprb2.setQDataLength(0);
            cprb2.setRParmLength(26);
            cprb2.setRDataLength(0);
            cprb2.setQParm(new byte[1024]);
            cprb2.setQData(new byte[1024]);
            cprb2.setRParm(new byte[1024]);
            cprb2.setRData(new byte[1024]);
            rmtReq.setCprb(cprb2);
            try {
                cprb2 = rmtReq.send();
                cprb2.setFunctionID("CL");
                if (this.landpServer.startsWith("PINP47")) {
                    String string3 = "S";
                    cprb2.setQParm(string3.getBytes());
                }
                rmtReq.setCprb(cprb2);
                cprb2 = rmtReq.send();
            }
            catch (LandpException landpException) {}
            this.status.setBusy(false);
            throw throwable;
        }
        bitSet = new Cprb(this.landpServer, "KL");
        bitSet.setQParmLength(26);
        bitSet.setQDataLength(0);
        bitSet.setRParmLength(26);
        bitSet.setRDataLength(0);
        bitSet.setQParm(new byte[1024]);
        bitSet.setQData(new byte[1024]);
        bitSet.setRParm(new byte[1024]);
        bitSet.setRData(new byte[1024]);
        rmtReq.setCprb((Cprb)bitSet);
        try {
            bitSet = rmtReq.send();
            bitSet.setFunctionID("CL");
            if (this.landpServer.startsWith("PINP47")) {
                String string4 = "S";
                bitSet.setQParm(string4.getBytes());
            }
            rmtReq.setCprb((Cprb)bitSet);
            bitSet = rmtReq.send();
        }
        catch (LandpException landpException) {}
        this.status.setBusy(false);
        string = new JxfsMSDTracks(jxfsMSDTracks.isTrack1() && nArray[0] == 0, jxfsMSDTracks.isTrack2() && nArray[1] == 0, jxfsMSDTracks.isTrack3() && nArray[2] == 0);
        jxfsMSDReadData = new JxfsMSDReadData(vector, (JxfsMSDTracks)string, nArray[0], nArray[1], nArray[2]);
        this.sendOperationComplete(readTracksJob, (Serializable)jxfsMSDReadData, n);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readInternal returns");
        }
    }

    public synchronized void writeInternal(WriteTracksJob writeTracksJob, Vector vector) {
        int n;
        Object object;
        Object object2;
        byte[] byArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".writeInternal(control_id:" + writeTracksJob.getControlId() + ", identification_id:" + writeTracksJob.getIdentificationID() + ")");
        }
        this.status.setBusy(true);
        new BitSet(8);
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            if (vector.elementAt(n3) != null) {
                byArray = (byte[])vector.elementAt(n3);
                n2 += byArray.length + 2;
            }
            ++n3;
        }
        byArray = new byte[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < vector.size()) {
            if (vector.elementAt(n5) != null) {
                object2 = (byte[])vector.elementAt(n5);
                int n6 = n4++;
                byArray[n6] = (byte)(byArray[n6] | ((byte[])object2).length + 1);
                if (n5 == 0) {
                    int n7 = n4;
                    byArray[n7] = (byte)(byArray[n7] | 4);
                    bl = true;
                }
                if (n5 == 1) {
                    int n8 = n4;
                    byArray[n8] = (byte)(byArray[n8] | 2);
                    bl2 = true;
                }
                if (n5 == 2) {
                    int n9 = n4;
                    byArray[n9] = (byte)(byArray[n9] | 1);
                    bl3 = true;
                }
                int n10 = 0;
                while (n10 < ((byte[])object2).length) {
                    byArray[++n4] = object2[n10];
                    ++n10;
                }
                ++n4;
            }
            ++n5;
        }
        object2 = (RmtReq)this.controls.get(new Integer(writeTracksJob.getControlId()));
        Cprb cprb = new Cprb(this.landpServer, "OP");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        object2.setCprb(cprb);
        try {
            try {
                cprb = object2.send();
                cprb.setFunctionID("WT");
                cprb.setQDataLength(n2);
                cprb.setQData(byArray);
                object2.setCprb(cprb);
                cprb = object2.send();
                cprb.setFunctionID("WM");
                cprb.setServerName("SPV");
                cprb.setQParmLength(7);
                object = new byte[7];
                object[0] = (Cprb)84;
                object[6] = (Cprb)Byte.decode(this.timeout);
                cprb.setQParm((byte[])object);
                cprb.setQDataLength(10);
                String string = "RW" + this.landpServer;
                cprb.setQData(string.getBytes());
                object2.setCprb(cprb);
                cprb = object2.send();
                byte[] byArray2 = cprb.getRParm();
                if (byArray2[0] == 69 && byArray2[1] == 84) {
                    n = 4010;
                } else {
                    cprb.setFunctionID("CH");
                    cprb.setQParmLength(26);
                    cprb.setQParm(new byte[26]);
                    cprb.setServerName(this.landpServer);
                    cprb.setQDataLength(0);
                    object2.setCprb(cprb);
                    try {
                        cprb = object2.send();
                        n = 0;
                    }
                    catch (BadServerRCException badServerRCException) {
                        n = 4009;
                    }
                }
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
                }
                n = 4009;
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
                }
                n = 4009;
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
                }
                n = 4009;
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
                }
                n = 4009;
            }
            Object var16_23 = null;
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            Cprb cprb2 = new Cprb(this.landpServer, "KL");
            cprb2.setQParmLength(26);
            cprb2.setQDataLength(0);
            cprb2.setRParmLength(26);
            cprb2.setRDataLength(0);
            cprb2.setQParm(new byte[1024]);
            cprb2.setQData(new byte[1024]);
            cprb2.setRParm(new byte[1024]);
            cprb2.setRData(new byte[1024]);
            object2.setCprb(cprb2);
            try {
                cprb2 = object2.send();
                cprb2.setFunctionID("CL");
                object2.setCprb(cprb2);
                cprb2 = object2.send();
            }
            catch (LandpException landpException) {}
            throw throwable;
        }
        object = new Cprb(this.landpServer, "KL");
        object.setQParmLength(26);
        object.setQDataLength(0);
        object.setRParmLength(26);
        object.setRDataLength(0);
        object.setQParm(new byte[1024]);
        object.setQData(new byte[1024]);
        object.setRParm(new byte[1024]);
        object.setRData(new byte[1024]);
        object2.setCprb(object);
        try {
            object = object2.send();
            object.setFunctionID("CL");
            object2.setCprb(object);
            object = object2.send();
        }
        catch (LandpException landpException) {}
        this.status.setBusy(false);
        JxfsMSDTracks jxfsMSDTracks = new JxfsMSDTracks(bl, bl2, bl3);
        this.sendOperationComplete(writeTracksJob, (Serializable)jxfsMSDTracks, n);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".writeInternal returns");
        }
    }

    private void sendOperationComplete(IJxfsServiceJob iJxfsServiceJob) {
        OperationCompleteEvent operationCompleteEvent = new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), 0);
        try {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, String.valueOf(this.subclass) + ".sendOperationComplete(job: " + iJxfsServiceJob + ")" + operationCompleteEvent + " to  Device Control " + iJxfsServiceJob.getControlId() + "." + " for identification_id " + iJxfsServiceJob.getIdentificationID() + " and operation_id " + iJxfsServiceJob.getOperationID());
            }
            this.queue.getControl(iJxfsServiceJob.getControlId()).fireOperationCompleteEvent(operationCompleteEvent);
            return;
        }
        catch (JxfsException jxfsException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, "Request with operationId " + iJxfsServiceJob.getOperationID() + " and identification_id " + iJxfsServiceJob.getIdentificationID() + " of Device Control " + iJxfsServiceJob.getControlId() + " was canceled in method cancelJob of class QueueControl." + " Event could not be sent!");
            }
            return;
        }
    }

    private void sendOperationComplete(IJxfsServiceJob iJxfsServiceJob, int n) {
        OperationCompleteEvent operationCompleteEvent = new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), n);
        try {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, String.valueOf(this.subclass) + ".sendOperationComplete(job: " + iJxfsServiceJob + ", result: " + n + ")" + operationCompleteEvent + " to  Device Control " + iJxfsServiceJob.getControlId() + "." + " for identification_id " + iJxfsServiceJob.getIdentificationID() + " and operation_id " + iJxfsServiceJob.getOperationID());
            }
            this.queue.getControl(iJxfsServiceJob.getControlId()).fireOperationCompleteEvent(operationCompleteEvent);
            return;
        }
        catch (JxfsException jxfsException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, "Request with operationId " + iJxfsServiceJob.getOperationID() + " and identification_id " + iJxfsServiceJob.getIdentificationID() + " of Device Control " + iJxfsServiceJob.getControlId() + " was canceled in method cancelJob of class QueueControl." + " Event could not be sent!");
            }
            return;
        }
    }

    private void sendOperationComplete(IJxfsServiceJob iJxfsServiceJob, Serializable serializable, int n) {
        OperationCompleteEvent operationCompleteEvent = n == 0 ? new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), 0, serializable) : new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), n);
        try {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, String.valueOf(this.subclass) + ".sendOperationComplete(job: " + iJxfsServiceJob + ", data:" + serializable + ", result:" + n + ")" + operationCompleteEvent + " to  Device Control " + iJxfsServiceJob.getControlId() + "." + " for identification_id " + iJxfsServiceJob.getIdentificationID() + " and operation_id " + iJxfsServiceJob.getOperationID());
            }
            this.queue.getControl(iJxfsServiceJob.getControlId()).fireOperationCompleteEvent(operationCompleteEvent);
            return;
        }
        catch (JxfsException jxfsException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, "Request with operationId " + iJxfsServiceJob.getOperationID() + " and identification_id " + iJxfsServiceJob.getIdentificationID() + " of Device Control " + iJxfsServiceJob.getControlId() + " was canceled in method cancelJob of class QueueControl." + " Event could not be sent!");
            }
            return;
        }
    }

    private boolean initializePhysically(int n) {
        boolean bl = true;
        try {
            this.timeout = (String)((Object)this.localDeviceInfo.getValueForKey("operationTimeout"));
            int n2 = Integer.parseInt(this.timeout);
            if (n2 > 60) {
                this.timeout = "60";
            }
        }
        catch (JxfsException jxfsException) {
            this.timeout = "30";
        }
        RmtReq rmtReq = (RmtReq)this.controls.get(new Integer(n));
        Cprb cprb = new Cprb(this.landpServer, "EC");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(24);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        rmtReq.setCprb(cprb);
        try {
            cprb = rmtReq.send();
            byte[] byArray = cprb.getRData();
            boolean bl2 = (byArray[21] & 4) != 0;
            boolean bl3 = (byArray[21] & 2) != 0;
            boolean bl4 = (byArray[21] & 1) != 0;
            boolean bl5 = (byArray[23] & 4) != 0;
            boolean bl6 = (byArray[23] & 2) != 0;
            boolean bl7 = (byArray[23] & 1) != 0;
            this.supportedReadTracks = new JxfsMSDTracks(bl2, bl3, bl4);
            this.supportedWriteTracks = new JxfsMSDTracks(bl5, bl6, bl7);
        }
        catch (InvalidCprbException invalidCprbException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
            }
            bl = false;
        }
        catch (BadRouterRCException badRouterRCException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
            }
            bl = false;
        }
        catch (BadServerRCException badServerRCException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
            }
            bl = false;
        }
        catch (LandpCommunicationException landpCommunicationException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
            }
            bl = false;
        }
        return bl;
    }

    private byte bits2Byte(BitSet bitSet) {
        byte by = 0;
        int n = 0;
        while (n < 8) {
            if (bitSet.get(n)) {
                by = (byte)(by | 1 << n);
            }
            ++n;
        }
        return by;
    }
}

