/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.landp.device;

import com.ibm.landp.BadRouterRCException;
import com.ibm.landp.BadServerRCException;
import com.ibm.landp.Cprb;
import com.ibm.landp.InvalidCprbException;
import com.ibm.landp.LandpCommunicationException;
import com.ibm.landp.LandpException;
import com.ibm.landp.LandpUtils;
import com.ibm.landp.RmtReq;
import com.ibm.landp.device.LandpIBM47xxMSD;
import com.ibm.landp.device.internal.LandpDeviceService;
import com.ibm.landp.device.internal.pin.ILandpPINPadService;
import com.ibm.landp.device.internal.pin.ReadDataJob;
import com.jxfs.control.pin.JxfsPINConst;
import com.jxfs.control.pin.JxfsPINFKeySet;
import com.jxfs.control.pin.JxfsPINReadData;
import com.jxfs.control.pin.JxfsPINReadMode;
import com.jxfs.events.JxfsException;
import com.jxfs.events.OperationCompleteEvent;
import com.jxfs.forum.support.IJxfsServiceJob;
import com.jxfs.service.IJxfsPINKeypadService;
import java.io.Serializable;
import java.util.Vector;

public class LandpIBM4778PIN_MSD
extends LandpIBM47xxMSD
implements IJxfsPINKeypadService,
ILandpPINPadService,
JxfsPINConst {
    public static final String copyrightNotice = "5639-I90 (C) Copyright IBM Corp. 1990, 2000 All Rights Reserved. US Government Users Restricted Rights. Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. Licensed Material - Property of IBM";
    JxfsPINFKeySet getSupportedFKeysVector = new JxfsPINFKeySet(false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false);

    public LandpIBM4778PIN_MSD() {
        this.subclass = "LandpIBM4778PIN_MSD";
        this.physicalDeviceDescription = "IBM 4778 PIN/MSD";
        this.physicalDeviceName = "4778";
        LandpDeviceService.ORIGIN = "LDP_MSD_PIN";
        LandpDeviceService.DESCRIPTION = "Landp - 4778 PIN/MSD Device";
    }

    public Vector getSupportedFDKeys(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getSupportedFDKeys(controlId:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, "MelangePINService.getSupportedFDKeys() returns with empty Vector.");
        }
        return new Vector();
    }

    public JxfsPINFKeySet getSupportedFKeys(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getSupportedFKeys(controlId:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getSupportedFKeys() returns with " + this.getSupportedFKeysVector);
        }
        return this.getSupportedFKeysVector;
    }

    public boolean getInputRawSupported(int n) throws JxfsException {
        boolean bl = false;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getInputRawSupported(controlId:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getInputRawSupported() returns with " + bl);
        }
        return bl;
    }

    public boolean getInputCookedSupported(int n) throws JxfsException {
        boolean bl = true;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getInputCookedSupported(controlId:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getInputCookedSupported() returns with " + bl);
        }
        return bl;
    }

    public boolean getBeepOnPressSupported(int n) throws JxfsException {
        boolean bl = false;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getBeepOnPressSupported(controlId:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getBeepOnPressSupported() returns with " + bl);
        }
        return bl;
    }

    public int readData(JxfsPINReadMode jxfsPINReadMode, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readData(readMode:" + jxfsPINReadMode + ", controlId:" + n + ")");
        }
        this.checkShutdown(n);
        if (jxfsPINReadMode.getMinLength() > jxfsPINReadMode.getMaxLength()) {
            throw new JxfsException(5102);
        }
        ReadDataJob readDataJob = new ReadDataJob(this, jxfsPINReadMode, n);
        int n2 = this.queue.addJob((IJxfsServiceJob)readDataJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readData returns with identification_id:" + n2);
        }
        return n2;
    }

    public synchronized void readDataInternal(ReadDataJob readDataJob, JxfsPINReadMode jxfsPINReadMode) throws JxfsException {
        Object object;
        int n = jxfsPINReadMode.getMinLength();
        jxfsPINReadMode.getMaxLength();
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readDataInternal(control_id:" + readDataJob.getControlId() + ", identification_id:" + readDataJob.getIdentificationID() + ", readMode:" + jxfsPINReadMode + ")");
        }
        String string = "";
        boolean bl = false;
        RmtReq rmtReq = (RmtReq)this.controls.get(new Integer(readDataJob.getControlId()));
        Cprb cprb = new Cprb(this.landpServer, "OP");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        String string2 = "P";
        cprb.setQParm(string2.getBytes());
        rmtReq.setCprb(cprb);
        try {
            try {
                cprb = rmtReq.send();
                cprb.setFunctionID("AR");
                string2 = "N";
                cprb.setQParm(string2.getBytes());
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                cprb.setFunctionID("WM");
                cprb.setServerName("SPV");
                cprb.setQParmLength(1);
                cprb.setQParm(new byte[1]);
                cprb.setQDataLength(10);
                object = "DR" + this.landpServer;
                cprb.setQData(((String)object).getBytes());
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                cprb.setFunctionID("RD");
                cprb.setServerName(this.landpServer);
                cprb.setQParmLength(26);
                string2 = "P";
                cprb.setQParm(string2.getBytes());
                cprb.setQDataLength(0);
                cprb.setRDataLength(100);
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                byte[] byArray = cprb.getRData();
                string = new String(byArray, 0, cprb.getRepliedDataLength());
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
                }
                bl = true;
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
                }
                bl = true;
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
                }
                bl = true;
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
                }
                bl = true;
            }
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            Cprb cprb2 = new Cprb(this.landpServer, "KL");
            cprb2.setQParmLength(26);
            cprb2.setQDataLength(0);
            cprb2.setRParmLength(26);
            cprb2.setRDataLength(0);
            cprb2.setQParm(new byte[1024]);
            cprb2.setQData(new byte[1024]);
            cprb2.setRParm(new byte[1024]);
            cprb2.setRData(new byte[1024]);
            rmtReq.setCprb(cprb2);
            try {
                cprb2 = rmtReq.send();
                cprb2.setFunctionID("CL");
                string2 = "P";
                cprb2.setQParm(string2.getBytes());
                rmtReq.setCprb(cprb2);
                cprb2 = rmtReq.send();
            }
            catch (LandpException landpException) {}
            this.status.setBusy(false);
            throw throwable;
        }
        object = new Cprb(this.landpServer, "KL");
        object.setQParmLength(26);
        object.setQDataLength(0);
        object.setRParmLength(26);
        object.setRDataLength(0);
        object.setQParm(new byte[1024]);
        object.setQData(new byte[1024]);
        object.setRParm(new byte[1024]);
        object.setRData(new byte[1024]);
        rmtReq.setCprb((Cprb)object);
        try {
            object = rmtReq.send();
            object.setFunctionID("CL");
            string2 = "P";
            object.setQParm(string2.getBytes());
            rmtReq.setCprb((Cprb)object);
            object = rmtReq.send();
        }
        catch (LandpException landpException) {}
        this.status.setBusy(false);
        JxfsPINReadData jxfsPINReadData = new JxfsPINReadData(5056, string.length(), null, string, 0);
        if (string.length() >= n & !bl) {
            this.sendOperationComplete(readDataJob, jxfsPINReadData, 0);
        } else if (bl) {
            this.sendOperationComplete(readDataJob, jxfsPINReadData, 5098);
        } else {
            this.sendOperationComplete(readDataJob, jxfsPINReadData, 1);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".readDataInternal returns.");
        }
    }

    private void sendOperationComplete(IJxfsServiceJob iJxfsServiceJob, JxfsPINReadData jxfsPINReadData, int n) {
        OperationCompleteEvent operationCompleteEvent = n == 0 ? new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), 0, (Serializable)jxfsPINReadData) : new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), n);
        try {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, String.valueOf(this.subclass) + ".sendOperationComplete(job: " + iJxfsServiceJob + ", result:" + n + ")" + operationCompleteEvent + " to  Device Control " + iJxfsServiceJob.getControlId() + "." + " for identification_id " + iJxfsServiceJob.getIdentificationID() + " and operation_id " + iJxfsServiceJob.getOperationID());
            }
            this.queue.getControl(iJxfsServiceJob.getControlId()).fireOperationCompleteEvent(operationCompleteEvent);
            return;
        }
        catch (JxfsException jxfsException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, "Request with operationId " + iJxfsServiceJob.getOperationID() + " and identification_id " + iJxfsServiceJob.getIdentificationID() + " of Device Control " + iJxfsServiceJob.getControlId() + " was canceled in method cancelJob of class QueueControl." + " Event could not be sent!");
            }
            return;
        }
    }
}

