/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.landp.device;

import com.ibm.landp.BadRouterRCException;
import com.ibm.landp.BadServerRCException;
import com.ibm.landp.Cprb;
import com.ibm.landp.InvalidCprbException;
import com.ibm.landp.LandpCommunicationException;
import com.ibm.landp.LandpException;
import com.ibm.landp.LandpUtils;
import com.ibm.landp.RmtReq;
import com.ibm.landp.device.internal.LandpDeviceService;
import com.ibm.landp.device.internal.ptr.ILandpPrinterService;
import com.ibm.landp.device.internal.ptr.PrintRawDataJob;
import com.ibm.landp.device.internal.ptr.ResetPrinterJob;
import com.jxfs.control.ptr.JxfsPtrCtrlMediaCapability;
import com.jxfs.control.ptr.JxfsPtrExtentCapability;
import com.jxfs.control.ptr.JxfsPtrFormsConfig;
import com.jxfs.control.ptr.JxfsPtrStatus;
import com.jxfs.control.ptr.JxfsPtrWriteFormCapability;
import com.jxfs.events.JxfsException;
import com.jxfs.events.OperationCompleteEvent;
import com.jxfs.forum.support.CloseJob;
import com.jxfs.forum.support.IJxfsServiceJob;
import com.jxfs.forum.support.IQueueResponse;
import com.jxfs.forum.support.OpenJob;
import com.jxfs.forum.support.QueueControl;
import com.jxfs.general.JxfsLogger;
import com.jxfs.general.JxfsMediaStatus;
import com.jxfs.general.JxfsStatus;
import com.jxfs.general.JxfsThresholdStatus;
import com.jxfs.service.IJxfsPrinterService;

public class LandpIBM4722PTR
extends LandpDeviceService
implements IJxfsPrinterService,
IQueueResponse,
ILandpPrinterService {
    public static final String copyrightNotice = "5639-I90 (C) Copyright IBM Corp. 1990, 2000 All Rights Reserved. US Government Users Restricted Rights. Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. Licensed Material - Property of IBM";
    JxfsPtrCtrlMediaCapability mediaCapability = new JxfsPtrCtrlMediaCapability(0);
    JxfsPtrExtentCapability extentCapability = new JxfsPtrExtentCapability(0);
    JxfsPtrFormsConfig formsConfig = new JxfsPtrFormsConfig();
    JxfsMediaStatus mediaStatus = new JxfsMediaStatus(0);
    JxfsThresholdStatus paperStatus = new JxfsThresholdStatus(0);
    JxfsThresholdStatus tonerStatus = new JxfsThresholdStatus(0);
    JxfsPtrStatus printerStatus = new JxfsPtrStatus(this.mediaStatus, this.paperStatus, this.tonerStatus);
    JxfsPtrWriteFormCapability writeFormCapability = new JxfsPtrWriteFormCapability(0);
    byte printerModel;

    public LandpIBM4722PTR() {
        this.subclass = "LandpIBM4722PTR";
        this.physicalDeviceDescription = "IBM 4722 PTR";
        this.physicalDeviceName = "4722";
        LandpDeviceService.ORIGIN = "LDP_PTR";
        LandpDeviceService.DESCRIPTION = "Landp - 4722 PTR Device";
        this.logger = JxfsLogger.getReference();
        this.logger.registerModule(LandpDeviceService.ORIGIN, LandpDeviceService.DESCRIPTION);
        int n = 1;
        this.queue = new QueueControl(n);
        this.status = new JxfsStatus();
    }

    public int open(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".open(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        int n2 = this.queue.open((IJxfsServiceJob)new OpenJob((IQueueResponse)this, n));
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".open returns identification_id:" + n2);
        }
        return n2;
    }

    public int close(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".close(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        int n2 = this.queue.close((IJxfsServiceJob)new CloseJob((IQueueResponse)this, n));
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".close returns identification_id:" + n2);
        }
        return n2;
    }

    public boolean claim(int n, int n2) throws JxfsException {
        boolean bl;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".claim(timeout:" + n + ", control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        this.status.setClaimPending(true);
        try {
            bl = this.queue.claim(n, n2, (IQueueResponse)this);
        }
        catch (JxfsException jxfsException) {
            this.status.setClaimPending(false);
            throw jxfsException;
        }
        if (bl) {
            this.status.setClaimed(true);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".claim returns success:" + bl);
        }
        return bl;
    }

    public boolean release(int n, int n2) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".release(timeout:" + n + ", control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        boolean bl = this.queue.release(n, n2, (IQueueResponse)this);
        if (bl) {
            this.status.setClaimed(false);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".release returns success:" + bl);
        }
        return bl;
    }

    public void cancel(int n, int n2) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".cancel(identification_id:" + n + ", control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        boolean bl = this.queue.cancelJob(n, true);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".cancel: cancelJob returns with:" + bl);
        }
    }

    public boolean isCompound(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".isCompound(controlID:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".isCompound returns false");
        }
        return false;
    }

    public JxfsPtrCtrlMediaCapability getCtrlMediaCapability(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getCtrlMediaCapability(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getCtrlMediaCapability returns:" + this.mediaCapability);
        }
        return this.mediaCapability;
    }

    public JxfsPtrExtentCapability getExtentCapability(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getExtendCapability(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getExtendCapability returns:" + this.extentCapability);
        }
        return this.extentCapability;
    }

    public JxfsPtrFormsConfig getFormsConfig(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getFormsConfig(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getFormsConfig returns:" + this.formsConfig);
        }
        return this.formsConfig;
    }

    public void setFormsConfig(JxfsPtrFormsConfig jxfsPtrFormsConfig, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".setFormsConfig(formsConfig:" + jxfsPtrFormsConfig + "control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".setFormsConfig formsConfig set to:" + jxfsPtrFormsConfig);
        }
        this.formsConfig = jxfsPtrFormsConfig;
    }

    public JxfsPtrStatus getPtrStatus(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getPtrStatus(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getPtrStatus returns:" + this.printerStatus);
        }
        return this.printerStatus;
    }

    public JxfsPtrWriteFormCapability getWriteFormCapability(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getWriteFormCapability(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getWriteFormCapability returns:" + this.writeFormCapability);
        }
        return this.writeFormCapability;
    }

    public int ctrlMedia(int n, int n2) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".ctrlMedia(mediaControl: " + n + "control_id:" + n2 + ")");
        }
        this.checkShutdown(n2);
        if (!this.queue.isRegistered(n2) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n2)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int getFormList(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getFormList(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int mediaExtents(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".mediaExtents(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int getMediaList(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getMediaList(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int printForm(String string, String string2, String[] stringArray, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".printForm(formName:" + string + "mediaName:" + string2 + "fieldWriteData:" + stringArray + "control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int printRawData(byte[] byArray, boolean bl, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".printRawData(rawData:" + byArray + "inputData:" + bl + "control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        PrintRawDataJob printRawDataJob = new PrintRawDataJob(this, byArray, bl, n);
        int n2 = this.queue.addJob((IJxfsServiceJob)printRawDataJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".printRawData returns with identification_id:" + n2);
        }
        return n2;
    }

    public int getFieldDescription(String[] stringArray, String string, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getFieldDescription(fieldNames:" + stringArray + "formName:" + string + "control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int getFormDescription(String string, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getFormDescription(formName:" + string + "control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int getMediaDescription(String string, int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".getMediaDescription(mediaName:" + string + "control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        throw new JxfsException(1022);
    }

    public int resetPrinter(int n) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".resetPrinter(control_id:" + n + ")");
        }
        this.checkShutdown(n);
        if (!this.queue.isRegistered(n) || this.isShutdownActive) {
            throw new JxfsException(1001);
        }
        if (!this.queue.isOpen(n)) {
            throw new JxfsException(1002);
        }
        ResetPrinterJob resetPrinterJob = new ResetPrinterJob(this, n);
        int n2 = this.queue.addJob((IJxfsServiceJob)resetPrinterJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".resetPrinter returns with identification_id:" + n2);
        }
        return n2;
    }

    public synchronized void printRawDataInternal(PrintRawDataJob printRawDataJob, byte[] byArray, boolean bl) {
        int n = 0;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".printRawDataInternal(control_id:" + printRawDataJob.getControlId() + ", identification_id:" + printRawDataJob.getIdentificationID() + ")");
        }
        RmtReq rmtReq = (RmtReq)this.controls.get(new Integer(printRawDataJob.getControlId()));
        Cprb cprb = new Cprb(this.landpServer, "OP");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        rmtReq.setCprb(cprb);
        this.status.setBusy(true);
        try {
            try {
                cprb = rmtReq.send();
                cprb.setFunctionID("WR");
                cprb.setQDataLength(byArray.length);
                cprb.setQData(byArray);
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                cprb.setFunctionID("CH");
                cprb.setQDataLength(0);
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
                }
                n = 1;
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
                }
                n = 1;
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
                }
                n = 1;
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
                }
                n = 1;
            }
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            Cprb cprb2 = new Cprb(this.landpServer, "CL");
            cprb2.setQParmLength(26);
            cprb2.setQDataLength(0);
            cprb2.setRParmLength(26);
            cprb2.setRDataLength(0);
            cprb2.setQParm(new byte[1024]);
            cprb2.setQData(new byte[1024]);
            cprb2.setRParm(new byte[1024]);
            cprb2.setRData(new byte[1024]);
            rmtReq.setCprb(cprb2);
            try {
                cprb2 = rmtReq.send();
            }
            catch (LandpException landpException) {}
            throw throwable;
        }
        Cprb cprb3 = new Cprb(this.landpServer, "CL");
        cprb3.setQParmLength(26);
        cprb3.setQDataLength(0);
        cprb3.setRParmLength(26);
        cprb3.setRDataLength(0);
        cprb3.setQParm(new byte[1024]);
        cprb3.setQData(new byte[1024]);
        cprb3.setRParm(new byte[1024]);
        cprb3.setRData(new byte[1024]);
        rmtReq.setCprb(cprb3);
        try {
            cprb3 = rmtReq.send();
        }
        catch (LandpException landpException) {}
        this.status.setBusy(false);
        this.sendOperationComplete(printRawDataJob, n);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".printRawDataInternal returns");
        }
    }

    public synchronized void resetPrinterInternal(ResetPrinterJob resetPrinterJob) {
        int n = 0;
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".resetPrinterInternal(control_id:" + resetPrinterJob.getControlId() + ", identification_id:" + resetPrinterJob.getIdentificationID() + ")");
        }
        this.status.setBusy(true);
        RmtReq rmtReq = (RmtReq)this.controls.get(new Integer(resetPrinterJob.getControlId()));
        Cprb cprb = new Cprb(this.landpServer, "OP");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        String string = "  R";
        cprb.setQParm(string.getBytes());
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        rmtReq.setCprb(cprb);
        try {
            try {
                cprb = rmtReq.send();
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
                }
                n = 1;
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
                }
                n = 1;
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
                }
                n = 1;
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
                }
                n = 1;
            }
            Object var7_12 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            Cprb cprb2 = new Cprb(this.landpServer, "CL");
            cprb2.setQParmLength(26);
            cprb2.setQDataLength(0);
            cprb2.setRParmLength(26);
            cprb2.setRDataLength(0);
            cprb2.setQParm(new byte[1024]);
            cprb2.setQData(new byte[1024]);
            cprb2.setRParm(new byte[1024]);
            cprb2.setRData(new byte[1024]);
            rmtReq.setCprb(cprb2);
            try {
                cprb2 = rmtReq.send();
                n = 0;
            }
            catch (LandpException landpException) {}
            throw throwable;
        }
        Cprb cprb3 = new Cprb(this.landpServer, "CL");
        cprb3.setQParmLength(26);
        cprb3.setQDataLength(0);
        cprb3.setRParmLength(26);
        cprb3.setRDataLength(0);
        cprb3.setQParm(new byte[1024]);
        cprb3.setQData(new byte[1024]);
        cprb3.setRParm(new byte[1024]);
        cprb3.setRData(new byte[1024]);
        rmtReq.setCprb(cprb3);
        try {
            cprb3 = rmtReq.send();
            n = 0;
        }
        catch (LandpException landpException) {}
        this.status.setBusy(false);
        this.sendOperationComplete(resetPrinterJob, n);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".resetPrinterInternal returns");
        }
    }

    public boolean cancelInternal() {
        return false;
    }

    public boolean checkInternal() {
        return true;
    }

    public synchronized void openInternal(IJxfsServiceJob iJxfsServiceJob) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".openInternal(control_id:" + iJxfsServiceJob.getControlId() + ")");
        }
        if (this.openCount == 0) {
            boolean bl = this.initializePhysically(iJxfsServiceJob.getControlId());
            if (bl) {
                ++this.openCount;
                this.status.setOpen(true);
                this.sendOperationComplete(iJxfsServiceJob);
            } else {
                this.status.setOpen(false);
                this.sendOperationComplete(iJxfsServiceJob, 1019);
            }
        }
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".openInternal returns, openCount is:" + this.openCount + ")");
        }
    }

    public synchronized void closeInternal(IJxfsServiceJob iJxfsServiceJob) throws JxfsException {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".closeInternal(control_id:" + iJxfsServiceJob.getControlId() + ")");
        }
        if (this.openCount == 1) {
            this.status.setOpen(false);
        }
        --this.openCount;
        this.sendOperationComplete(iJxfsServiceJob);
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".closeInternal returns, openCount is:" + this.openCount + ")");
        }
    }

    public synchronized void claimInternal(int n) {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".claimInternal(control_id:" + n + ")");
        }
    }

    public synchronized void releaseInternal(int n) {
        if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 80)) {
            this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 80, String.valueOf(this.subclass) + ".releaseInternal(control_id:" + n + ")");
        }
    }

    private void sendOperationComplete(IJxfsServiceJob iJxfsServiceJob) {
        OperationCompleteEvent operationCompleteEvent = new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), 0);
        try {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, String.valueOf(this.subclass) + ".sendOperationComplete(job: " + iJxfsServiceJob + ")" + operationCompleteEvent + " to  Device Control " + iJxfsServiceJob.getControlId() + "." + " for identification_id " + iJxfsServiceJob.getIdentificationID() + " and operation_id " + iJxfsServiceJob.getOperationID());
            }
            this.queue.getControl(iJxfsServiceJob.getControlId()).fireOperationCompleteEvent(operationCompleteEvent);
            return;
        }
        catch (JxfsException jxfsException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, "Request with operationId " + iJxfsServiceJob.getOperationID() + " and identification_id " + iJxfsServiceJob.getIdentificationID() + " of Device Control " + iJxfsServiceJob.getControlId() + " was canceled in method cancelJob of class QueueControl." + " Event could not be sent!");
            }
            return;
        }
    }

    private void sendOperationComplete(IJxfsServiceJob iJxfsServiceJob, int n) {
        OperationCompleteEvent operationCompleteEvent = new OperationCompleteEvent((Object)this, iJxfsServiceJob.getOperationID(), iJxfsServiceJob.getIdentificationID(), n);
        try {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, String.valueOf(this.subclass) + ".sendOperationComplete(job: " + iJxfsServiceJob + ", result: " + n + ")" + operationCompleteEvent + " to  Device Control " + iJxfsServiceJob.getControlId() + "." + " for identification_id " + iJxfsServiceJob.getIdentificationID() + " and operation_id " + iJxfsServiceJob.getOperationID());
            }
            this.queue.getControl(iJxfsServiceJob.getControlId()).fireOperationCompleteEvent(operationCompleteEvent);
            return;
        }
        catch (JxfsException jxfsException) {
            if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                this.logger.writeLog((Object)this, LandpDeviceService.ORIGIN, 82, "Request with operationId " + iJxfsServiceJob.getOperationID() + " and identification_id " + iJxfsServiceJob.getIdentificationID() + " of Device Control " + iJxfsServiceJob.getControlId() + " was canceled in method cancelJob of class QueueControl." + " Event could not be sent!");
            }
            return;
        }
    }

    private boolean initializePhysically(int n) {
        Object object;
        boolean bl = true;
        RmtReq rmtReq = (RmtReq)this.controls.get(new Integer(n));
        Cprb cprb = new Cprb(this.landpServer, "OP");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        rmtReq.setCprb(cprb);
        try {
            try {
                cprb = rmtReq.send();
                cprb.setFunctionID("EC");
                cprb.setRDataLength(27);
                rmtReq.setCprb(cprb);
                cprb = rmtReq.send();
                object = cprb.getRData();
                this.printerModel = object[7];
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, 1L, 1L, invalidCprbException.getMessage(), "Cprb for " + cprb.getFunctionID() + " call to device is incorrect", null);
                }
                bl = false;
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badRouterRCException.getReturnCode(), 0L, badRouterRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad router return code " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " Check that LANDP device server and supervisor are loaded.", null);
                }
                bl = false;
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, badServerRCException.getReturnCode(), 0L, badServerRCException.getMessage(), cprb.getFunctionID() + " call to device returned a bad server return code " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " Refer to PD guide for explanation.", null);
                }
                bl = false;
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(LandpDeviceService.ORIGIN, 82)) {
                    this.logger.writeErrorLog((Object)this, LandpDeviceService.ORIGIN, (long)landpCommunicationException.getReturnCode(), 0L, landpCommunicationException.getMessage(), "LANDP Java Manager generated an error. Contact support.", null);
                }
                bl = false;
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            Cprb cprb2 = new Cprb(this.landpServer, "CL");
            cprb2.setQParmLength(26);
            cprb2.setQDataLength(0);
            cprb2.setRParmLength(26);
            cprb2.setRDataLength(0);
            cprb2.setQParm(new byte[1024]);
            cprb2.setQData(new byte[1024]);
            cprb2.setRParm(new byte[1024]);
            cprb2.setRData(new byte[1024]);
            rmtReq.setCprb(cprb2);
            try {
                cprb2 = rmtReq.send();
            }
            catch (LandpException landpException) {}
            throw throwable;
        }
        object = new Cprb(this.landpServer, "CL");
        object.setQParmLength(26);
        object.setQDataLength(0);
        object.setRParmLength(26);
        object.setRDataLength(0);
        object.setQParm(new byte[1024]);
        object.setQData(new byte[1024]);
        object.setRParm(new byte[1024]);
        object.setRData(new byte[1024]);
        rmtReq.setCprb((Cprb)object);
        try {
            object = rmtReq.send();
        }
        catch (LandpException landpException) {}
        return bl;
    }
}

