/**********************************************************************
*
*  IBM CONFIDENTIAL
*  OCO SOURCE MATERIALS
*
*  COPYRIGHT:  P#2 P#1
*              (C) COPYRIGHT IBM CORPORATION Y1, Y2
*
*  The source code for this program is not published or otherwise divested of
*  its trade secrets, irrespective of what has been deposited with the U.S.
*  Copyright Office.
*
*  Source File Name = (common/uamanager/HelpManager.java, cc_UDBObj, db2cc_v6)
*
*  Descriptive Name = Help Manager Class
*
*  Function: This class manages online help display.
*
*  Dependencies: See import list.
*
*  Restrictions:
*
*  Change Activity:
*    DATE    DESCRIPTION                                             S&D Code
*  97/06/03  Check code into CMVC.                                   @d68694JGJ
*  97/09/04  Ensure help frame has constant name.                    @d76279JGJ
*  97/10/20  Change to getCodeBase() and relative path               @d77849dje
*  97/10/22  Change null helpIndex to ""                             @d77860GCO
*  98/02/23  Drive showHelp() with a component.                      @d82408dje
*  98/02/27  Invoke help with null from component version.           @d82672dje
*  98/05/28  Look for help html files in ../doc/html/db2help/*.htm   @d86994mak
*  98/07/13  Suppress help for no_help definitions                   @d90052dje
*  98/12/04  Uncomment println debugging statement                   @f97889mjz
*  98/12/29  Initial framework for help in an application            @d98776jdr
*  99/02/08  Removed extraneous .., also removed 3-frame check       @d99110jdr
*  99/02/19  Move HotKeyxxx.java to common package                   @d102171bc
*  99/03/07  Rewrote browser-launching, added comments, cleaned up   @d103451jdr
*  99/03/23  Fixed another path bug (missing db2help/, trailing #)   @d106406jdr
*  99/03/30  Fixed various glitches affecting Solaris/UNIX           @d107583jdr
*  99/04/08  Fixed name mangling for web URLs                        @d108431jdr
*  99/04/26  Don't allow wrong-way slashes or doubled slashes        @d110849jdr
*  99/05/02  Fix browser launching on UNIX (-remote, HP-UX)          @d113973jdr
*  99/05/06  Add platform names for LINUX, IRIX                      @d113464jdr
*  99/07/07  V6.2 cleanup                                            @d120668bc
*  99/11/22  Move CommonDialog to common jar                         @d130512bc
*  99/12/02  Add showHelp method to override the directory           @d133381bc
*  03/09/09  fix iSeries Wizard and unify the V7/V8 code             @d291667jc
*
*  ============================================================================
*
*  Last Changed =    99/02/25  12:25:22
*
***********************************************************************/
package com.ibm.dxx.db2.tools.common.uamanager;       //@d291667jc

//import com.ibm.db2.tools.common.*;                  //@d291667jc
import java.applet.*;
import java.net.*;
import java.awt.*;
import java.io.*;
import javax.swing.*;

/** This class provides a central point for kicking off
  * online help based on a help name and index.  There is no constructor
  * as all access is via static methods.
  */
public class HelpManager extends Object implements HelpFileNames
{
   static Applet applet = null; //@d97965jdr
   static URL base = null; //@d97965jdr

         /** What's the relative path to the help files, assuming the applet is
           * run from \sqllib\cc\prime or other locale directory on the same level?
           */
        //final static String defaultHelpPrefix = "../doc/html/db2help/"; //@d97965jdr
        final static String defaultDocPrefix = "../doc/html/"; //@d97965jdr
        final static String defaultHelpPrefix = "html/"; //@ANITA

   /** What's the path to the help files after we get to %DB2PATH% or $DB2PATH?
                 */
        final static String relativeHelpPrefix = "/doc/html/db2help/"; //@d97965jdr

         /** What relative path will we really use (i.e. might be changeable).
           */
         static String helpPrefix = defaultHelpPrefix; //@d97965jdr

         /** What directory is the help in (relative to the directory where all
           * the rest of the docs are)?  Ditto for docs relative to %DB2PATH%.
           */
         //static String helpDir = "/db2help/";
         static String helpDir = "/html/";  // @ANITA
         static String docDir = "/doc/html/";

         /** What item in the property table can we check to see where DB2 is
           * installed?
                 */
         static String DB2PATH_KEY = "db2.path";

        /** If DB2PATH is not set on an Intel machine, this is a bogus value we
          * might retrieve from System.getProperty().
                */
        static final String badDB2Path = "%DB2PATH%";

/** Maybe the script passed in an absolute directory where DB2 is installed,
  * and we can use that to construct pathnames to doc and help files.
        */
        public static String getPathArg()
        {
                String potential = System.getProperty(DB2PATH_KEY);
                if ( potential.equals(badDB2Path) )
                {
// If the variable isn't set, the script may pass in the literal
// string "%DB2PATH%".
                        potential = null;
                }
// Sometimes we return null -- in that case, the caller must look for
// another way to get that info.
                return potential;
        }

/** The Java application when started should have a working directory of
  * \sqllib\java\bin (or the equivalent on other platforms).
        * So we should be able to construct a relative path to \sqllib and from it
        * determine the absolute path where the product is installed.
        */
        public static String getPathWorking()
        {
                java.io.File parentDir = new java.io.File("..");
                String potential = new String(parentDir.getAbsolutePath());
                return potential;
        }

/** Try every possible method to find the root directory of the product install.
  */
        public static String findRootDir()
        {
                String rootDir = getPathArg(); // Passed via startup script?
                if (rootDir == null) // No?
                {
                        rootDir = getPathWorking();
                }
                if (rootDir == null)
                {
//                      System.out.println("Tried everything but can't find %DB2PATH%.");
                }
                return rootDir;
        }

/** Build the path for the documentation files (for displaying non-help
  * HTML).
        */
        public static String findDocDir()
        {
                return findRootDir() + docDir;
        }

/** Build the path for the help files (for displaying context-sensitive help).
        */
        public static String findHelpDir()
        {
                return findRootDir() + helpDir;
        }

/** Build the complete path to a help file.  The argument must be
  * "whatever.htm" (UDB help file, contained in \sqllib\doc\html\db2help)
        * or "package/whatever.htm" (CC390 or other UAManaged help file, contained
        * in \sqllib\doc\html\db2help\package).
        public static String buildHelpPathName(String lastPart)
        {
                return findHelpDir() + lastPart;
        }

   /** Set the Applet to use for displaying help.
     * @param a Applet to set
     */
   public static void setApplet (Applet a) {
      applet = a;
      if (applet != null) {                                      //@f97889mjz
        base = applet.getCodeBase(); //@d77849dje
      }                                                          //@f97889mjz
   }

   /** Return the applet that was specified via setApplet().
           * Needed so we can getCodeBase() and construct a relative path
                 * when running as an applet.
     */
   public static Applet getApplet () {
      return applet;
   }

   //<@d82408dje
   /** Retrieve help information for this component if possible.  This is
           * the method used to display help for typical UDB windows without
                 * explicitly passing around file names.
     *
     * The file name used is the first one defined in a CommonPanel, CommonDialog
     * or CommonFrame in the components hierarchy.
     *
     * The anchor used is the first one defined in a CommonPanel, CommonDialog
     * or CommonFrame in the components hierarchy so long as the helpName remains undefined.
     */
// ------------------------------------------------------------------------
//<@d97965jdr
   /** Display online help, given a file name and optional anchor name.
     * @param helpName Name of online help file.  Does not include the
                 *                 trailing ".htm".  May include an initial directory
                 *                 such as "db2_390/". Eventually the file gets resolved
                 *                 to \sqllib\doc\html\db2help\helpName.htm#helpIndex.
                 *                 Usually helpIndex is null so the anchor doesn't get
                 *                 appended to the URL.
     * @param helpIndex Anchor name, when jumping to a point in the HTML file
                 *                  rather than the top of the file.  Typically null.
     */
   public static void showHelp (String helpName, String helpIndex)
         {
//<@d98776jdr
                        if ( helpName == null )
                        {
//                              System.out.println("Null string passed to showHelp()");
                                return;
                        }
                        if ( helpName.equals( "" ) )
                        {
//                              System.out.println("Empty string passed to showHelp()");
                                return;
                        }
//>@d98776jdr
      if ( helpName.equals( "no_help" ) ) { //<@d90052dje
//                              System.out.println("Help is hooked up, but only using a dummy file name.");
         return ;
      } //>@d90052dje


//      System.out.println( "URL of help file = " + (base != null ? base.toString() : "") + helpName + ".htm" + ((helpIndex != null && helpIndex.length() > 0) ? "#"+helpIndex : "" )) ; //@f97889mjz //@d91294dje //@d97965jdr

//<@d98776jdr
      if (applet == null)
                        {
//                              System.out.println("Help requested inside an application. Attempting to launch browser...");
                        //      openBrowser(helpDir+helpName,helpIndex); //@d291667jc
                                openBrowser(helpName,helpIndex);   //@d291667jc
         return;
                        }
//>@d98776jdr

      AppletContext ac = applet.getAppletContext();             //<@d86994mak

                        URL realURL = null;

                        realURL = getHelpURL(helpName, helpIndex);

//                      System.out.println("getHelpURL() returned "+realURL.toString());
                        ac.showDocument(realURL, HELP_IC_FRAME);
   }
//>@d97965jdr

   /** Display online help, given a file name and optional anchor name and a help directory.
     * @param helpName Name of online help file.  Does not include the
                 *                 trailing ".htm".  May include an initial directory
                 *                 such as "db2_390/". Eventually the file gets resolved
                 *                 to \sqllib\doc\html\<helpdir>\helpName.htm#helpIndex.
                 *                 Usually helpIndex is null so the anchor doesn't get
                 *                 appended to the URL.
     * @param helpIndex Anchor name, when jumping to a point in the HTML file
                 *                  rather than the top of the file.  Typically null.
     * @param helpDir   This overrides the default help directory and should be in
       *                  the form /directory/  (include the slashes).
     */
   public static void showHelp (String helpName, String helpIndex, String helpDir)
         {

//<@d98776jdr
                        if ( helpName == null )
                        {
//                              System.out.println("Null string passed to showHelp()");
                                return;
                        }
                        if ( helpName.equals( "" ) )
                        {
//                              System.out.println("Empty string passed to showHelp()");
                                return;
                        }
//>@d98776jdr
      if ( helpName.equals( "no_help" ) ) { //<@d90052dje
//                              System.out.println("Help is hooked up, but only using a dummy file name.");
         return ;
      } //>@d90052dje


//      System.out.println( "URL of help file = " + (base != null ? base.toString() : "") + helpName + ".htm" + ((helpIndex != null && helpIndex.length() > 0) ? "#"+helpIndex : "" )) ; //@f97889mjz //@d91294dje //@d97965jdr

//<@d98776jdr
      if (applet == null)
                        {
//                              System.out.println("Help requested inside an application. Attempting to launch browser...");
                                openBrowser(helpDir+helpName, helpIndex); //@d99110
         return;
                        }
//>@d98776jdr

      AppletContext ac = applet.getAppletContext();             //<@d86994mak

                        URL realURL = null;

                        realURL = getHelpURL(helpName, helpIndex);
//                      System.out.println("getHelpURL() returned "+realURL.toString());
                        ac.showDocument(realURL, HELP_IC_FRAME);
   }

// ------------------------------------------------------------------------
//<@d97965jdr
/** Given a simple filename and optional anchor name, construct a complete
  * URL for a given help file.
  *
  */
    public static URL getHelpURL(String helpName, String helpIndex) {

// First, construct a relative path name by concatenating the path to the
// help directory, the filename, the standard suffix .htm, and the anchor
// name (if supplied).
        System.out.println("helpIndex = "+helpIndex);
        String helpFile = helpPrefix + helpName + ".htm" + ((helpIndex != null  && helpIndex.length() > 0) ? "#"+helpIndex : "" );
        System.out.println("helpFile = "+helpFile);

// Now figure out what the whole URL will be (for debugging if something
// goes wrong constructing the URL).  Basically this is the URL where the
// applet is running + the relative path to the help file.  If not running
// as an applet...
        String helpURL = (base != null ? base.toString() : "") + helpFile;

        URL returnValue = null;

        try
                                {
//                                              System.out.println("Trying to construct a URL from "+base.toString()+", "+helpFile);
            returnValue = new URL(base, helpFile);
        }
                                catch (MalformedURLException e)
                                {
//                                      System.out.println("Can't construct help URL: '"+helpURL+"'");
                                }

// Return the created URL or null if something awful happened and it could
// not be created.
                        return returnValue;
    }
//>@d97965jdr


//<@d98776jdr

/* Code extracted and simplified from Intelligent Miner's help launching
 * mechanism. Conditional code launches the browser differently on different
 * platforms.
 */

/** Given a string representing a command, execute the command and return
  * a handle for the resulting process.
        *
        * @param cmd The command to execute, represented as a single string.
        *            Command-line parameters are separated by spaces.
  * @return p Process handle: non-null (command succeeded) or null (command failed).
        */
  public static Process executeCommand(String cmd)
        {
                String error="";
                Process p=null;
                InputStream stdErr;
                Runtime run = Runtime.getRuntime();

//              System.out.println("Command to run: " + cmd);
                try
                {
                        p = run.exec(cmd);
                }
                catch (IOException e)
                {
//                      System.out.println("Cannot execute command");
                }
                return p;
  }

/** Given a local filename, opens the browser to look at that file.
  * Only used in application mode.
        * @param fileName A String representing
        *                 the last piece of a help filename (udbhelpfile.htm,
        *                 db2_390/cc390helpfile.htm, etc.) If the ".htm" extension
        *                 is missing, it is added.
        */
  public static void openBrowser(String fileName,String helpIndex)
        {
    String osType = (System.getProperty("os.name")).toUpperCase();
    String slash = System.getProperty("file.separator"); //@d107583jdr
                String fullPath = null; //@d108431jdr

//              System.out.println("Preparing to launch browser.");
                System.out.println("Operating system = "+osType);
//              System.out.println("File (as specified) = "+fileName);

//<@d110849jdr
                if (fileName.startsWith("/") || fileName.startsWith("\\"))
                {
                        fileName = fileName.substring(1); // Chop off initial slash if there is one
//                      System.out.println("Leading slash in filename; trimmed = "+fileName);
                }
//>@d110849jdr

//@<d98864jdr
                //String complete = ".." + slash + "doc" + slash + "html" + slash + fileName; //@d107583jdr
        String complete = fileName; //@ANITA

                if (!fileName.toLowerCase().endsWith(".htm") && !fileName.endsWith("/")) //@d108431jdr
                {
                        complete = complete + ".htm";
 //                       System.out.println("Complete filename = "+complete);
                }


//<@d108431jdr
                if (!fileName.toLowerCase().startsWith("http:"))  
                {
 
  //@d291667jc begin
  //To find the dxxahelp_xx.htm file
                      
  java.io.File f = null;
  boolean found = false;   
  final String home_directory = System.getProperty("user.home");
  System.out.println("home_directory=" + home_directory);  /* for v8 */
 
                                         
  if (osType.startsWith("WINDOWS")) {                     
    String[] paths = new String[] { "c:"+slash+"Program Files"+
                                    slash+"IBM"+slash+"SQLLIB"+ 
                                    slash+ "db2xml"+slash+"adm_gui"+
                                    slash+"html"+slash + fileName,
                                    
                                    "c:"+slash+"Program Files"+
                                    slash+"SQLLIB"+ 
                                    slash+ "db2xml"+slash+"adm_gui"+
                                    slash+"html"+slash + fileName,
                                    
                                    "c:"+slash+"dxx"+
                                    slash+"dxxadmin"+ slash+"html"+ slash +
                                    fileName,
                                    
                                    fileName};
 
     
    for( int i = 0; i < paths.length && (found==false); i++ ){
            try {
                 System.out.println("try to open:" + paths[i] );
                 f = new java.io.File(paths[i]);
                 
                 if (!f.exists()) {
                     continue;
                    }
                 else {
                     found=true;
                     fullPath = paths[i];
                     }                                  
                } //try
             catch (Exception ex) {                                
                System.out.println("mess = " + ex.getMessage());                  
                }               
          } // End for loop      
        }//End if Windows                     
                        
  else {  // UNIX                        

    /* Try V8 first */                 
    String[] paths_unix = new String[] { 
                   	 home_directory + slash + 
                         "sqllib"+ slash + "db2xml"+slash+"adm_gui"+ 
                          slash+"html"+slash+fileName, 
                                                          
                         fileName};
 
   
    for( int i = 0; i < paths_unix.length && (found==false); i++ ){      
       System.out.println("try to open:" + paths_unix[i] );
       f = new java.io.File(paths_unix[i]);
                 
       if (!f.exists()) {
          continue;
          }
       else {
          found=true;
          fullPath = paths_unix[i];
          }                                                        
       } // End for loop 

    /* Try V7 */
    if ( found==false ) {
       if ( osType.equals("AIX") ) 
          fullPath=      slash + "usr" + slash + "lpp" +slash 
                         + "db2xml_07_01"+slash +"dxxadmin"+slash
                         +"html"+ slash+fileName;
       else if ( osType.equals("SOLARIS") )
          fullPath=      slash +"opt"+ slash +"IBMdb2xml"+ slash 
                         +"V7.1"+ slash + "dxxadmin"+slash
                         +"html"+ slash+fileName;
       else if ( osType.equals("LINUX") )            
          fullPath=      slash + "usr"+ slash + "IBMdb2xml"+ slash 
                         + "V7.1"+ slash + "adm_g" +slash
                         +"html"+ slash+fileName; 
       System.out.println("try to open:" + fullPath );  
       f = new java.io.File(fullPath);  
       if (f.exists()) {
          found=true;
          }            
       
       }                       
            
   }//End if UNIX                    
                    
  if ( found==true )
      System.out.println("Found the Help file.");  	                      
                                                                             
//@d291667jc end
                                                
                } 
                else
                {
                        fullPath = fileName;
                        System.out.println("Displaying external URL: " + fullPath);
                }
//>@d108431jdr

    if (helpIndex != "" && helpIndex != null)
      fullPath += "#" + helpIndex;

    if ( osType.equals("AIX") || osType.equals("UNIX") || osType.equals("SOLARIS") || osType.equals("HP-UX") || osType.equals("LINUX") || osType.equals("IRIX") ) //@d107583jdr @d113973jdr @d113464jdr
                {
      // Only trying Netscape... repeat this code for other browsers...
      Process p = executeCommand("netscape -remote openURL(file:"+fullPath+")"); //@d107583jdr @d113973jdr
                        if (p != null)
                        {
                                String cmd = "netscape " + fullPath;
                                try
                                {
                                        int rc = p.waitFor();
                                        if (rc != 0)
                                        {
                                                p = executeCommand(cmd);
                                        }
                                }
                                catch (InterruptedException e)
                                {
//                                      System.out.println("Error running command: "+cmd);
//                                      System.out.println("Exception = " + e);
                                }
                        }
    }
    else if (osType.startsWith("WINDOWS"))
                {
// Use file association to "start" the HTML file, automatically running
// the right browser.
//            System.out.println("Open Help File: "+ fullPath);
                        executeCommand("rundll32 url.dll,FileProtocolHandler " + fullPath);
    }
    else if (osType.equals("OS/2"))
                {
      executeCommand("netscape " + fullPath);
    }
    else
                {
//                      System.out.println ("Browser launching is not implemented for operating system "+osType);

    }
  }
//>@d98776jdr

//<@d98864jdr
/** Open a fully-qualified URL or a relative path.
  * Works whether running as applet or application.
        * (If running as application, pass null for the applet parameter.)
        *
        * @param it A String representing either a complete URL (http:// etc.)
        *           or the last piece of a help filename (udbhelpfile.htm,
        *           db2_390/cc390helpfile.htm, etc.)
        * @param applet Used to get the codebase when running as an applet.
        *               Passing null signals the program is an application.
        */
        public static void openURLorFile(String it, JApplet applet)
        {
                if (it != null)
                {
                        URL u;
                        try
                        {
// If the filename doesn't start with http:// or file:///, an exception is
// thrown and the catch block runs the application code to view a local file.
                                u = new URL(it);
                                if (applet != null)
                                {
// In applet mode, we know we can open a new window.  Plus the help URL
// is sure to begin with http:// or file:///
                                        applet.getAppletContext().showDocument(u, HELP_IC_FRAME); // Display fully qualified URL
                                }
                                else
                                {
// If we are in application mode and asked to jump to an http:// URL,
// it's unusual but accomodate the request.  Maybe the help is stored on
// some central web server.
//                                      System.out.println("Launching real URL '"+it+"' from application mode.");
                                        openBrowser(it,"");
                                }
                        }
                        catch (MalformedURLException exception)
                        {
                                try
                                {
                                        // If the URL doesn't start with http:, interpret it as
                                        // relative to the location where the applet is.
                                        if (applet != null)
                                        {
                                                URL base = applet.getCodeBase();
                                                u = new URL(base, it);
                                                applet.getAppletContext().showDocument(u, HELP_IC_FRAME); // Display relative URL when View button pressed
                                        }
                                        else
                                        {
//                                              System.out.println("Launching relative URL: "+it);
                                                HelpManager.openBrowser(it,"");
                                        }
                                }
                                catch (MalformedURLException e1)
                                {
//                                      System.out.println(IaStringPool.get(IaStringPool.IA_STR_BADURL) + it);
                                }
                                catch (Throwable t)
                                {
//                                      System.out.println("Unexpected error viewing "+it+"; "+t.getMessage());
                                }
                        }
                        return;
                }
        }
//>@d98864jdr

} // end of HelpManager class
