@
CREATE PROCEDURE VO.XGetWishedTitles (IN MID INT, OUT XML VARCHAR(32000))
    LANGUAGE SQL
------------------------------------------------------------------------
-- SQL Stored Procedure
------------------------------------------------------------------------
P1: BEGIN
  DECLARE TITLEID INTEGER;
  DECLARE TITLENAME VARCHAR(64);
  DECLARE AVAILABILITYICON VARCHAR(64);
  DECLARE IMAGEFILE VARCHAR(64);
  DECLARE CUSTRATINGICON VARCHAR(64);
  DECLARE CRITRATINGICON VARCHAR(64);
  DECLARE MOVIERANK INTEGER;
  DECLARE DATEADDED DATE;
  DECLARE PERSONID INTEGER;
  DECLARE PERSONFIRSTNAME VARCHAR(32);
  DECLARE PERSONLASTNAME VARCHAR(32);

  DECLARE loc_rs1 RESULT_SET_LOCATOR VARYING;
  DECLARE rs_end INTEGER DEFAULT 0;
  DECLARE xdoc INTEGER;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET rs_end = 1;

  SET xdoc = XUDFS.XDOCUMENT('GetWishedTitles', 3, 0, 0);

  CALL VO.GETWISHEDTITLES(MID);

  ASSOCIATE RESULT SET LOCATOR(loc_rs1) WITH PROCEDURE VO.GETWISHEDTITLES;
  ALLOCATE rs1 CURSOR FOR RESULT SET loc_rs1;


  SET rs_end = 0;

  SET xdoc = XUDFS.XTABLE(xdoc, 'Titles');

  WHILE (rs_end = 0) DO
    FETCH FROM rs1 INTO
      TITLEID,
      TITLENAME,
      AVAILABILITYICON,
      IMAGEFILE,
      CUSTRATINGICON,
      CRITRATINGICON,
      MOVIERANK,
      DATEADDED,
      PERSONID,
      PERSONFIRSTNAME,
      PERSONLASTNAME;

    IF (rs_end = 0) THEN
      SET xdoc = XUDFS.XROW(xdoc, 'Title', 1, 'TitleID', CHAR(TITLEID), 1);
      SET xdoc = XUDFS.XNODE(xdoc, 'TitleName', TITLENAME, 0);
      SET xdoc = XUDFS.XNODE(xdoc, 'AvailibilityIcon', AVAILABILITYICON, 0);
      SET xdoc = XUDFS.XNODE(xdoc, 'ImageFile', IMAGEFILE, 0);
      SET xdoc = XUDFS.XNODE(xdoc, 'AvgCustomerRating', CHAR(CUSTRATINGICON), 1);
      SET xdoc = XUDFS.XNODE(xdoc, 'AvgCriticRating', CHAR(CRITRATINGICON), 1);
      SET xdoc = XUDFS.XNODE(xdoc, 'MovieRank', CHAR(MOVIERANK), 1);
      SET xdoc = XUDFS.XNODE(xdoc, 'DateAdded', CHAR(DATEADDED), 1);
      SET xdoc = XUDFS.XTREE(xdoc, 'Person', 'PersonID', CHAR(PERSONID), 1);
      SET xdoc = XUDFS.XNODE(xdoc, 'FirstName', PERSONFIRSTNAME, 0);
      SET xdoc = XUDFS.XNODE(xdoc, 'LastName', PERSONLASTNAME, 0);
    END IF;
  END WHILE;

  CLOSE rs1;

  SET XML = XUDFS.XGETDOCUMENT(xdoc);
  SET xdoc = XUDFS.XRELEASEDOCUMENT(xdoc);
END P1
@
