@
CREATE PROCEDURE VO.GetNonWishedTitles (
      IN MID INTEGER )
    RESULT SETS 1
    LANGUAGE SQL
------------------------------------------------------------------------
-- SQL Stored Procedure
------------------------------------------------------------------------
P1: BEGIN
    -- Declare cursor
    DECLARE cursor1 CURSOR WITH RETURN FOR
        SELECT
            DISTINCT VO.TITLE.TITLEID AS TITLEID,
            VO.TITLE.NAME AS NAME
        FROM
          VO.TITLE
        WHERE
          VO.TITLE.TITLEID NOT IN
            (
            SELECT  VO.TITLE.TITLEID AS TITLEID
            FROM
                VO.WISHEDTITLES LEFT OUTER JOIN VO.TITLE
                ON ( VO.WISHEDTITLES.TITLEID = VO.TITLE.TITLEID )
            WHERE
                VO.WISHEDTITLES.CUSTOMERID = MID);
    -- Cursor left open for client application
    OPEN cursor1;
END P1
@
