/***********************************************************************
*
* Sample source for DB2PEM local (gateway) password maintenance exit.
*
* NOTE: this source requires a C++ compiler to compile and link to the stub.
*
* Copy this code to a source file of your own. 
*
* Complete the body of the function with whatever calls are necessary 
* to effect a password change on your system.
*
* Compile the code, and link with "db2pemcp.o", provided with the db2pem 
* from the same distribution as this sample file.
* 
* Make the resulting executable name "db2pemcp".
*
* If your functions require access to restricted resources, 
* make sure you change the executable permissions to be a set-uid to 
* the id with appropriate authority (e.g. root).
*
* Place the executable in the same directory as the db2pem utility programs.
*
* Text error/information messages may be passed back up to db2pem by writting 
* to the "cout" stream. Db2pem will return these messages as is to the 
* utility invoker (a gateway client "db2pemc", or direct PEM client "db2pem").
*
* Be sure to return one of the provided return codes. 
*
* The #if defined( MY_PLATFORM ) illustrates how you might develop
* several versions of "db2pemcp" for different platforms, expanding the #if
* with #elif defined( MY_OTHER_PLATFORM ), etc...
*
***********************************************************************/

#include <stdlib.h>
#include <iostream.h>
#include <string.h>
#include <errno.h>

#if ! defined( USHORT ) 
#  define USHORT unsigned short
#endif

// Return codes expected from the change password user exit
// Anything out of this range will be mapped to a generic fail code.

static const unsigned short CPUE_RETURN_OK = 0 ;
static const unsigned short CPUE_RETURN_USER_BAD = 1 ;
static const unsigned short CPUE_RETURN_OLD_PASSWORD_BAD = 2 ;
static const unsigned short CPUE_RETURN_NEW_PASSWORD_BAD = 3 ;
static const unsigned short CPUE_RETURN_FUNCTION_NOT_SUPPORTED = 16 ;
static const unsigned short CPUE_RETURN_EXIT_FAILED = 20 ;   


USHORT DB2CS_ChangePasswordUserExit( const char user [], 
                                     const char oldP [],
                                     const char newP []  ) { 

   unsigned short exitRc = CPUE_RETURN_OK ; 

#if defined( A_SUPPORTED_PLATFORM ) 

   int rc bosApiRc ; 

   // Make calls to effect password change from oldP to newP for use. 

   // N.B. Do not forget to validate the oldP password for user before proceeding.

   // Perhaps the calls result in bosApiRc being set, which might be treated
   // something like this:

   if ( bosApiRc != 0 ) { 

      switch ( errno ) {
         case ENOENT  : exitRc = CPUE_RETURN_USER_BAD         ; break ; 
         case ESAD    : exitRc = CPUE_RETURN_OLD_PASSWORD_BAD ; break ;
         case ENOATTR : exitRc = CPUE_RETURN_NEW_PASSWORD_BAD ; break ; 
         default      : exitRc = CPUE_RETURN_EXIT_FAILED      ;
      }

      // The caller wants any text message to be placed on the standard cout stream. 

      cout << "Call to some_function_name failed with " 
           << "rc=" << bosApiRc 
           << ", errno=" << errno ;
   }

   return exitRc ;

#else 

   return CPUE_RETURN_FUNCTION_NOT_SUPPORTED ;

#endif 
}
