--                                                                           --
--                                                                           --
--  Licensed Materials - Property of IBM                                     --
--					                                     --
--  5765-530 (C) Copyright IBM Corp. 1996 All Rights Reserved.               --
--						                             --
--                                                                           --
--                                                                           --
-- This is a Sybase SQL Script to migrate a previously installed repository  --
-- to a new repository                                                       --
--                                                                           --
--                                                                           --
-- Migration of Red db2v2 data to Orange --
--                                       --

-- dba_host_profile --
-- host_name increased from 40 to 100  --
-- user_name increased from 40 to 50   --
-- password increased from 40 to 50    --

insert into dba_host_profile ( host_name, user_name, password )
	select host_name, user_name, password from #red#.dba_host_profile
go

-- dba_host --
-- host_name increased from 45 to 100  --
-- host_type increased from 10 to 50   --

insert into dba_host ( host_num, host_name, host_type, 
				host_desc, host_dir )
	select host_num, host_name, host_type, host_desc, host_dir
		from #red#.dba_host
go

-- dba_database --
-- db_type increased from 7 to 50   --
-- db_name increased from 20 to 50  --
-- db_desc increased from 80 to 255 --

insert into dba_database (db_num, host_num, db_type, db_name,
				db_dir, db_desc, db_status )
	select db_num, host_num, db_type, db_name, db_dir, db_desc, db_status
		from #red#.dba_database
go

-- dba_application --
-- app_name increased from 45 to 50 --

insert into dba_application (app_num, app_name )
	select app_num, app_name
		from #red#.dba_application
go

-- dba_host_app --

insert into dba_host_app ( host_num, app_num )
	select host_num, app_num
		from #red#.dba_host_app
go

-- dba_db_table --
-- db_name increased from 40 to 50     --
-- tab_owner increased from 40 to 50   --
-- tab_name increased from 40 to 50    --

insert into dba_db_table ( tab_num, db_num, db_name, tab_owner,
		tab_name, type )
	select tab_num, db_num, db_name, tab_owner, tab_name, type
		from #red#.dba_db_table
go

-- dba_app_table --
-- app_name increased from 45 to 50 --

insert into dba_app_table (app_tab_num, tab_num, app_num )
	select app_tab_num, tab_num, app_num
		from #red#.dba_app_table
go

--  dba_relation  --
--  col_from increased from 40 to 50 --
--  col_to increased from 40 to 50 --

insert into dba_relation (rel_num, tab_from, tab_to, 
			col_from, col_to, col_pos)
        select rel_num, tab_from, tab_to, col_from, col_to, col_pos 
        from #red#.dba_relation
go

-- dba_db_check --
-- db_name should be defaulted 	        --
-- check_scope increased from 15 to 50  --
-- obj_owner increased from 40 to 50    --
-- obj_name increased from 40 to 50     --
-- sql_text increased from 1000 to 1024 --
-- filter_type increased from 2 to 4    --
-- ret_type changed from int to smallint--

insert into dba_db_check ( check_num, check_scope, db_num, obj_owner,
		obj_name, check_type, sql_text, filter_type, filter_val, 
		check_name, ret_type )
	select check_num, check_scope, db_num, obj_owner, obj_name, check_type,
		sql_text, filter_type, filter_val, check_name, ret_type
		from #red#.dba_db_check
go

-- Updates required as the select returns an empty string ("") rather than NULL
update dba_db_check set obj_owner = NULL where obj_owner =''
go
update dba_db_check set obj_name = NULL where obj_name =''
go

-- Update checks on Sybase database level
update dba_db_check
set check_scope = 'database_syb',
  obj_name = obj_owner,
  obj_owner = null
where
  db_num in (
    select db_num
    from dba_database
    where db_type = 'syb'
  )
  and check_scope = 'database'
go


-- dba_host_check --
-- sql_text increased from 255 to 1024  --
-- filter_type increased from 2 to 4    --
-- ret_type changed from int to smallint--

insert into dba_host_check ( check_num, host_num, check_type, 
		sql_text, filter_type, filter_val, check_name, ret_type )
	select check_num, host_num, check_type, sql_text, filter_type,
		filter_val, check_name, ret_type
		from #red#.dba_host_check
go

-- dba_db_rule --
-- action_type increased from 7 to 50      --
-- command_host increased from 40 to 50    --
-- command_user increased from 40 to 50    --

insert into dba_db_rule ( rule_num, condition, action_type, action,
		command_host, command_user )
	select rule_num, condition, action_type, action, 
		command_host, command_user from #red#.dba_db_rule
go

-- dba_check_rule --

insert into dba_check_rule (check_num, rule_num )
	select check_num, rule_num
		from #red#.dba_check_rule
go

-- dba_check_times --

insert into dba_check_times (check_num, start_type, start_time,
			repeat_type, repeat_time, end_type, end_time )
	select check_num, start_type, start_time, repeat_type, repeat_time,
		end_type, end_time
		from #red#.dba_check_times
go

-- dba_alert --
-- alert_class increased from 20 to 50 --

insert into dba_alert (alert_num, alert_class, alert_message, action )
	select alert_num, alert_class, alert_message, action 
		from #red#.dba_alert
go

-- dba_alert_send --
-- send_user increased from 40 to 50 --

insert into dba_alert_send (alert_num, rule_num, send_user, received )
	select alert_num, rule_num, send_user, received 
		from #red#.dba_alert_send
go

-- dba_check_vals --
-- ret_type changed from int to smallint           --
-- set_nr was added and removed -- Barry           --

insert into dba_check_vals (check_num, ts, ret_type, ivalue,
				fvalue, svalue )
	select check_num, ts, ret_type, ivalue, fvalue, svalue
		from #red#.dba_check_vals
go

-- alert_table --
-- alert_user increased from 32 to 50 --

insert into alert_table (alert_num, alert_user, ts, seen )
	select alert_num, alert_user, ts, seen 
		from #red#.alert_table
go

-- dba_group --
-- group_name increased from 20 to 50  --
-- Note : where clause due to data previously entered --

insert into dba_group ( group_nr, group_name )
	select group_nr, group_name
		from #red#.dba_group where group_nr <> 0

go

-- dba_host_type --
-- Note : where clause due to data previously entered --

insert into dba_host_type (host_type )
        select host_type 
	from #red#.dba_host_type
	where host_type not in 
	(select host_type from dba_host_type)
go

-- dba_database_type --
-- Note : where clause due to data previously entered --

insert into dba_database_type ( db_type )
	select db_type from #red#.dba_database_type
	where db_type not in 
	(select db_type from dba_database_type)
go

--  dba_user  --
--  user_name increased from 32 50  --
-- Note : where clause due to data previously entered --

insert into dba_user ( user_nr, user_name )
        select user_nr, user_name
        from #red#.dba_user where user_nr <> 0
go

--  dba_user_groups  --
--  user_name increased from 32 50  --
-- Note : where clause due to data previously entered --

insert into dba_user_groups ( user_nr, group_nr )
        select user_nr, group_nr
        from #red#.dba_user_groups 
	where user_nr <> 0 and group_nr <> 0
go

-- dba_class --
-- class_name shortened from 32 to 19      --
-- User Defined class are to be between 1000 & 5000 --

insert into dba_class (class_nr, class_name )
        select class_nr, substring(class_name, 1, 19)
        from #red#.dba_class
        where class_nr >= 1000 
        and   class_nr <= 5000

go
-- dba_class_data --
-- db_type shortened from 10 to 6      --
-- par_name increased from 30 to 50    --

insert into dba_class_data (class_nr, db_type, par_num, par_name )
 	select class_nr, substring(dbtype, 1, 6), par_num, par_name
 	from #red#.dba_class_data
        where class_nr >= 1000 
        and   class_nr <= 5000
go

-- dba_class_status --
-- db_type shortened from 10 to 6      --
-- value increased from 30 to 50    --
-- color increased from 20 to 50    --

insert into dba_class_status (class_nr, db_type, value, color )
 	select class_nr, substring(dbtype, 1, 6), value, color
	from #red#.dba_class_status
        where class_nr >= 1000 
        and   class_nr <= 5000

go
--  dba_udisp_func  --
--  from_type increased from 30 to 50  --
--  output_sep changed from varchar to char  --
--  status changed from varchar to char  --

insert into dba_udisp_func ( ud_func_num, from_class, from_type, to_class, 
			command_type, output_sep, status)
        select ud_func_num, from_class, from_type, to_class, command_type, 
		output_sep, status
        from #red#.dba_udisp_func
go

--  dba_udisp_comm  --

insert into dba_udisp_comm ( ud_func_num, comm_part, command )
        select ud_func_num, comm_part, command
        from #red#.dba_udisp_comm
go

--  dba_udisp_filter  --

insert into dba_udisp_filter ( ud_func_num, filter_num, filter_name )
        select ud_func_num, filter_num, filter_name
        from #red#.dba_udisp_filter
go

--  dba_udisp_priv  --

insert into dba_udisp_priv ( group_num, ud_func_num )
        select group_num, ud_func_num
        from #red#.dba_udisp_priv
go



-------------------------------------------------------------------------
-- User Defined Functions
-------------------------------------------------------------------------

-- dba_function
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_function ( function, name, color, type )
        select function, name, color, type
        from #red#.dba_function
        where function >= 20000
        and   function <= 50000
go


-- dba_privs
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_privs ( function_nr, class_nr, host_type, db_type, group_nr )
        select function_nr, class_nr, host_type, db_type, group_nr
        from #red#.dba_privs
        where function_nr >= 20000
        and   function_nr <= 50000
go


-- dba_func_attr_desc
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_func_attr_desc ( function_nr, class_or_instance, one_or_multi )
        select function_nr, class_or_instance, one_or_multi
        from #red#.dba_func_attr_desc
        where function_nr >= 20000
        and   function_nr <= 50000
go


-- dba_func_comm --
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_func_comm ( func_nr, command_nr, command_type )
        select func_nr, command_nr, command_type
        from #red#.dba_func_comm
        where func_nr >= 20000
        and   func_nr <= 50000
go



--  dba_ud_func_desc  --
-- Note only migrate functions between 20,000 & 50,000 - User defined

insert into dba_ud_func_desc ( func_nr, command_nr, segment_nr, segment )
        select func_nr, command_nr, segment_nr, segment
        from #red#.dba_ud_func_desc
        where func_nr >= 20000
        and   func_nr <= 50000
go



-- dba_func_param --
-- Note only migrate functions between 20,000 & 50,000 - User defined
-- param_name increased from 40 to 50    --

insert into dba_func_param ( func_nr, param_nr, param_name )
        select func_nr, param_nr, param_name
        from #red#.dba_func_param
        where func_nr >= 20000
        and   func_nr <= 50000
go


-------------------------------------------------------------------------
-- User Defined Functions
-------------------------------------------------------------------------


-- name_ctr --

-- This is because Name counter will have previosly been set --
-- to '1' in the dba script. --
-- Barry --
update NAME_CTR set  V  =
        ( select v from #red#.dba_group_ctr)
	where NAME = 'dba_group_ctr'

update NAME_CTR set  V  =
        (select v  from #red#.dba_user_ctr)
	where NAME = 'dba_user_ctr'


insert into NAME_CTR (NAME, V) 
	select 'dba_check_ctr', v  from #red#.dba_check_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_rule_ctr', v  from #red#.dba_rule_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_alert_ctr', v  from #red#.dba_alert_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_host_ctr', v  from #red#.dba_host_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_db_ctr', v  from #red#.dba_db_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_app_tab_ctr', v  from #red#.dba_app_tab_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_tab_ctr', v  from #red#.dba_tab_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_rel_ctr', v  from #red#.dba_rel_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_app_ctr', v  from #red#.dba_app_ctr

insert into NAME_CTR (NAME, V) 
	select 'dba_function_ctr', v  from #red#.dba_function_ctr
go

-- Theses counters are needed as the follwing counter names have changed
-- dba_alert_ctr has become wd_alert_ctr
-- dba_rule_ctr has become wd_rule_ctr
-- For the moment dba_alert_ctr & dba_rule_ctr will also be kept -- Barry

insert into NAME_CTR (NAME, V)
        select 'wd_alert_ctr', v  from #red#.dba_alert_ctr
go

insert into NAME_CTR (NAME, V)
        select 'wd_rule_ctr', v  from #red#.dba_rule_ctr
go

-- Note this is need as Red & Orange relerases use counters differently
update NAME_CTR set V = V+1
go

-- dba_check_status --
-- Changes recommended by Stan Wong for watchdog migration --
-- Barry 16 Feb 96 --

insert into DBA_CHECK_STATUS (CHECK_NUM) select check_num
   from #red#.dba_db_check union select check_num from #red#.dba_host_check
go

update DBA_CHECK_STATUS set STORE_STATUS = 'y', ACTIVE_STATUS = 'y'
go



