/**INC+***********************************************************************/
/*                                                                           */
/* Include: ACSSVCC.H                                                        */
/*                                                                           */
/* Purpose: Common Service Verb library standard header file for             */
/*          EE1.2 compatibility.                                             */
/*                                                                           */
/*  COPYRIGHT DATA CONNECTION LIMITED 1989, 1990, 1991, 1992, 1993, 1994    */
/*  COPYRIGHT DATA CONNECTION LIMITED 1995, 1997, 1998                      */
/*                                                                           */
/**INC-***********************************************************************/

#ifndef ACSSVCC_INCLUDED
#define ACSSVCC_INCLUDED

#include <values_c.h>

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/
/* Note on Transfer_MS_Data verb:                                            */
/* This version of the software implements the functionality of the Transfer */
/* MS Data verb in the MS Library (see the MS API Programmer's Guide).  The  */
/* CSV library will *link* with old applications which use this function but */
/* these applications WILL NOT COMPILE with this library.  In order to get   */
/* this function, the programmer should:                                     */
/* - #include <ms_c.h>                                                       */
/* - change all references to the 'origntr_id' field to 'originator_id'      */
/* - change the CSV library call to an MS library call for Transfer_MS_Data  */
/*****************************************************************************/


/*****************************************************************************/
/* The following #defines cause the new level of CSV support to be called.   */
/* The library as built has these symbols within, but they call the *old*    */
/* library support (inc. back-level Transfer MS Data).  These defines ensure */
/* that all new code calls the CSV library in its new incarnation.           */
/*****************************************************************************/
#ifndef BLD_CSV_LIB
#define ACSSVC_C   ACSSVC_new
#define ACSSVC_P   ACSSVC_new
#define ACSSVC     ACSSVC_new
#endif

/*****************************************************************************/
/*       Function prototype for the Common Service Verbs                     */
/*****************************************************************************/
#if defined (__STDC__) || defined (__cplusplus)
extern void ACSSVC_C(void *);
extern void ACSSVC_P(void *);
extern void ACSSVC(void *);
#else
extern void ACSSVC_C();
extern void ACSSVC_P();
extern void ACSSVC();
#endif

/*****************************************************************************/
/*                       VCB structures                                      */
/*****************************************************************************/

/**STRUCT+********************************************************************/
/* Structure: svc_hdr                                                        */
/*                                                                           */
/* Description: Common verb control block (vcb) header                       */
/*****************************************************************************/
struct svc_hdr
  {
  AP_UINT16      opcode;           /* Verb identifying operation code.       */
  unsigned char opext;             /* Verb extension code - reserved.        */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary return code from verb.         */
  AP_UINT32     secondary_rc;      /* Secondary (qualifying) return code.    */
  };
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: convert                                                        */
/*                                                                           */
/* Description: verb control block for convert verb                          */
/*****************************************************************************/
struct convert
  {
  AP_UINT16      opcode;           /* Verb identifying operation code.       */
  unsigned char opext;             /* Verb extension code - reserved.        */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary return code from verb.         */
  AP_UINT32     secondary_rc;      /* Secondary (qualifying) return code.    */
  unsigned char direction;         /* Direction of conversion - ASCII to     */
                                   /* EBCDIC or vice-versa.                  */
  unsigned char char_set;          /* Character set to use for the           */
                                   /* conversion A, AE, or user-defined G.   */
  AP_UINT16      len;              /* Length of string to be converted.      */
  unsigned char *source;           /* Pointer to string to be converted.     */
  unsigned char *target;           /* Address to put converted string at.    */
  };
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: define_trace                                                   */
/*                                                                           */
/* Description: verb control block for define_trace verb                     */
/*****************************************************************************/
struct define_trace
  {
  AP_UINT16      opcode;           /* Verb identifying operation code.       */
  unsigned char opext;             /* Verb extension code - reserved.        */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary return code from verb.         */
  AP_UINT32     secondary_rc;      /* Secondary (qualifying) return code.    */
  unsigned char reserv3[8];        /* Reserved.                              */
  unsigned char dt_set;            /* Trace state to be set (on/off).        */
  /***************************************************************************/
  /* In the following fields, used for specifying which types of tracing are */
  /* required, only the most significant bit is currently used. Bits 1 to 7  */
  /* are reserved. Bit 0 can be set to 'ignore' or to 'change'.              */
  /***************************************************************************/
  unsigned char appc;              /* Tracing for APPC.                      */
  unsigned char nof;               /* Tracing for NOF.                       */
  unsigned char srpi;              /* Reserved.                              */
  unsigned char sdlc;              /* Reserved.                              */
  unsigned char tkn_rng_dlc;       /* Reserved.                              */
  unsigned char pcnet_dlc;         /* Reserved.                              */
  unsigned char dft;               /* Reserved.                              */
  unsigned char acdi;              /* Reserved.                              */
  unsigned char reserv5;           /* Reserved.                              */
  unsigned char comm_serv;         /* Tracing for Comm_Serv_API.             */
  unsigned char ehllapi;           /* Tracing for HLLAPI.                    */
  unsigned char x25_api;           /* Reserved.                              */
  unsigned char x25_dlc;           /* Reserved.                              */
  unsigned char twinax;            /* Reserved.                              */
  unsigned char ms;                /* Tracing for MS.                        */
  unsigned char rui;               /* Tracing for RUI interface of LUA       */
  unsigned char etherand;          /* Reserved.                              */
  unsigned char subsym;            /* Reserved.                              */
  unsigned char reserv7[8];        /* Reserved.                              */
  unsigned char reset_trc;         /* Flag to reset the trace files.         */
  AP_UINT16      trunc;            /* Truncation size for trace records.     */
  AP_UINT16      strg_size;        /* Reserved.                              */
  unsigned char reserv8[1];        /* Reserved.                              */
  unsigned char phys_link[8];      /* Reserved.                              */
  unsigned char reserv9[56];       /* Reserved.                              */
  };
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: get_cp_convert_table                                           */
/*                                                                           */
/* Description: verb control block for get_cp_convert_table verb             */
/*****************************************************************************/
struct get_cp_convert_table
  {
  AP_UINT16      opcode;           /* Verb identifying operation code.       */
  unsigned char opext;             /* Verb extension code - reserved.        */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary return code from verb.         */
  AP_UINT32     secondary_rc;      /* Secondary (qualifying) return code.    */
  AP_UINT16      source_cp;        /* Source code page for conversion table. */
  AP_UINT16      target_cp;        /* Target code page for conversion table. */
  unsigned char *conv_tbl_addr;    /* Address to put conversion table at.    */
  unsigned char char_not_fnd;      /* Character not found option: either     */
                                   /* substitute character or round trip.    */
  unsigned char substitute_char;   /* Substitute character to use.           */
  };
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: log_message                                                    */
/*                                                                           */
/* Description: verb control block for log_message verb                      */
/*****************************************************************************/
struct log_message
  {
  AP_UINT16      opcode;           /* Verb identifying operation code.       */
  unsigned char opext;             /* Verb extension code - reserved.        */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary return code from verb.         */
  AP_UINT32     secondary_rc;      /* Secondary (qualifying) return code.    */
  AP_UINT16      msg_num;          /* Number of message to log.              */
  unsigned char origntr_id[8];     /* ID of the originator of the message.   */
  unsigned char msg_file_name[3];  /* Message file to search for the required*/
                                   /* message number.                        */
  unsigned char msg_act;           /* Message action - whether to inform     */
                                   /* operator.                              */
  AP_UINT16      msg_ins_len;      /* Length of data for insertion in msg.   */
  unsigned char *msg_ins_ptr;      /* Address of data for insertion in msg.  */
  };
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: copy_trace_to_file                                             */
/*                                                                           */
/* Description: verb control block for copy_trace_to_file verb               */
/*****************************************************************************/
struct copy_trace_to_file
  {
  AP_UINT16      opcode;           /* Verb identifying operation code.       */
  unsigned char opext;             /* Verb extension code - reserved.        */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary return code from verb.         */
  AP_UINT32     secondary_rc;      /* Secondary (qualifying) return code.    */
  unsigned char reserv3[8];        /* Reserved.                              */
  unsigned char file_name[64];     /* Trace file name.                       */
  unsigned char file_option;       /* File options. New or overwrite.        */
  unsigned char reserv4[12];       /* Reserved.                              */
  };
/**STRUCT-********************************************************************/

/*****************************************************************************/
/* The following two verbs are not implemented, but their structures are     */
/* present for compatibility with EE.                                        */
/*****************************************************************************/

/**STRUCT+********************************************************************/
/* Structure: set_user_log_queue                                             */
/*                                                                           */
/* Description: verb control block for set_user_log_queue verb               */
/*****************************************************************************/
struct set_user_log_queue
  {
  AP_UINT16      opcode;           /* Verb operation code                    */
  unsigned char opext;             /* Reserved.                              */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary RETURN_CODE                    */
  AP_UINT32     secondary_rc;      /* Secondary RETURN_CODE                  */
  unsigned char reserv3[8];        /* Reserved.                              */
  unsigned char queue_name[64];    /* Queue on which messages are to be put  */
  unsigned char forward;           /* Types of messages to be put on queue   */
  unsigned char suppress;          /* Messages to be suppressed              */
  unsigned char selection;         /* Messages to be forwarded               */
  AP_UINT16      numbers[10];      /* Message No.s to be forwarded           */
  };
/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: define_dump                                                    */
/*                                                                           */
/* Description: verb control block for define_dump verb                      */
/*****************************************************************************/
struct define_dump
  {
  AP_UINT16      opcode;           /* Verb operation code                    */
  unsigned char opext;             /* Reserved.                              */
  unsigned char reserv2;           /* Reserved.                              */
  AP_UINT16      primary_rc;       /* Primary RETURN_CODE                    */
  AP_UINT32     secondary_rc;      /* Secondary RETURN_CODE                  */
  unsigned char reserv3[8];        /* Reserved.                              */
  unsigned char component_01;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_02;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_03;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_04;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_05;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_06;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_07;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_08;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_09;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_10;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_11;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_12;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_13;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_14;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_15;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_16;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_17;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_18;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_19;      /* ACTIVATE or IGNORE component dump      */
  unsigned char component_20;      /* ACTIVATE or IGNORE component dump      */
  unsigned char reserv4[11];       /* Reserved.                              */
  unsigned char x25_control_blocks;/* ACTIVATE or IGNORE x25 cb dump         */
  unsigned char x25_user_buffers;  /* ACTIVATE or IGNORE x25 ub dump         */
  unsigned char x25_adapter_name[8];/*Adaptor name for x25 dumps             */
  unsigned char file_name[64];     /* File to dump to                        */
  unsigned char file_option;       /* OVERWRITE old file or create NEW       */
  };
/**STRUCT-********************************************************************/

#ifdef __cplusplus
}
#endif

#endif
