/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.bcel.classfile;

import com.ibm.xslt4j.bcel.classfile.Attribute;
import com.ibm.xslt4j.bcel.classfile.Code;
import com.ibm.xslt4j.bcel.classfile.ConstantPool;
import com.ibm.xslt4j.bcel.classfile.ConstantUtf8;
import com.ibm.xslt4j.bcel.classfile.ExceptionTable;
import com.ibm.xslt4j.bcel.classfile.FieldOrMethod;
import com.ibm.xslt4j.bcel.classfile.LineNumberTable;
import com.ibm.xslt4j.bcel.classfile.LocalVariableTable;
import com.ibm.xslt4j.bcel.classfile.Utility;
import com.ibm.xslt4j.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    public Method() {
    }

    public Method(Method c) {
        super(c);
    }

    Method(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatError {
        super(file, constant_pool);
    }

    public Method(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitMethod(this);
    }

    public final Code getCode() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof Code) {
                return (Code)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof ExceptionTable) {
                return (ExceptionTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        String str;
        String access = Utility.accessToString(this.access_flags);
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuffer buf = new StringBuffer(signature);
        int i = 0;
        while (i < this.attributes_count) {
            Attribute a = this.attributes[i];
            if (!(a instanceof Code) && !(a instanceof ExceptionTable)) {
                buf.append(" [" + a.toString() + "]");
            }
            ++i;
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows " + str);
        }
        return buf.toString();
    }

    public final Method copy(ConstantPool constant_pool) {
        return (Method)this.copy_(constant_pool);
    }
}

