/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAPKCS11KeyFactory
extends KeyFactorySpi {
    private PKCS11Session session = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"rsapkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyFactory";
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateKeySpec;

    public RSAPKCS11KeyFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyFactory");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyFactory");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePublic", (Object)keySpec);
        }
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                PKCS11Object pKCS11Object = null;
                byte[] byArray = null;
                Boolean bl = Boolean.FALSE;
                Boolean bl2 = Boolean.TRUE;
                Boolean bl3 = Boolean.TRUE;
                Boolean bl4 = Boolean.TRUE;
                BigInteger bigInteger = rSAPublicKeySpec.getModulus();
                Integer n = new Integer(String.valueOf(rSAPublicKeySpec.getModulus().toByteArray().length * 8));
                BigInteger bigInteger2 = rSAPublicKeySpec.getPublicExponent();
                byArray = this.genID();
                int[] nArray = new int[]{0, 256, 258, 1, 266, 260, 262, 288, 290};
                Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, byArray, bl, bl2, bl3, bl4, bigInteger, bigInteger2};
                pKCS11Object = this.session.createObject(nArray, objectArray);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_1");
                }
                return new RSAPublicKey(pKCS11Object, byArray, null, null, bl, bl2, bl3, bl4, bigInteger, n, bigInteger2);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_2");
                }
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            if (keySpec instanceof PKCS11KeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
                }
                PKCS11Object pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
                return new RSAPublicKey(pKCS11Object, (byte[])this.getAttrValue(pKCS11Object, 258), (byte[])this.getAttrValue(pKCS11Object, 257), (String)this.getAttrValue(pKCS11Object, 3), (Boolean)this.getAttrValue(pKCS11Object, 1), (Boolean)this.getAttrValue(pKCS11Object, 266), (Boolean)this.getAttrValue(pKCS11Object, 260), (Boolean)this.getAttrValue(pKCS11Object, 262), (BigInteger)this.getAttrValue(pKCS11Object, 288), (Integer)this.getAttrValue(pKCS11Object, 289), (BigInteger)this.getAttrValue(pKCS11Object, 290));
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGeneratePublic", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGeneratePublic", (Throwable)invalidKeyException);
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePrivate", (Object)keySpec);
        }
        try {
            PKCS11Object pKCS11Object = null;
            byte[] byArray = null;
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = Boolean.FALSE;
            Boolean bl3 = Boolean.TRUE;
            Boolean bl4 = Boolean.TRUE;
            Boolean bl5 = Boolean.TRUE;
            Boolean bl6 = null;
            BigInteger bigInteger = null;
            BigInteger bigInteger2 = null;
            BigInteger bigInteger3 = null;
            BigInteger bigInteger4 = null;
            BigInteger bigInteger5 = null;
            BigInteger bigInteger6 = null;
            BigInteger bigInteger7 = null;
            BigInteger bigInteger8 = null;
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                byArray = this.genID();
                bigInteger = rSAPrivateCrtKeySpec.getModulus();
                bigInteger2 = rSAPrivateCrtKeySpec.getPublicExponent();
                bigInteger3 = rSAPrivateCrtKeySpec.getPrivateExponent();
                bigInteger4 = rSAPrivateCrtKeySpec.getPrimeP();
                bigInteger5 = rSAPrivateCrtKeySpec.getPrimeQ();
                bigInteger6 = rSAPrivateCrtKeySpec.getPrimeExponentP();
                bigInteger7 = rSAPrivateCrtKeySpec.getPrimeExponentQ();
                bigInteger8 = rSAPrivateCrtKeySpec.getCrtCoefficient();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Modulus: " + bigInteger);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "publicExponent: " + bigInteger2);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent: " + bigInteger3);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "prime1: " + bigInteger4);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "prime2: " + bigInteger5);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "exponent1: " + bigInteger6);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "exponent2: " + bigInteger7);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "coefficient: " + bigInteger8);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "ID: " + byArray);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isToken: " + bl);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isSensitive: " + bl2);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isSign: " + bl3);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isDecrypt: " + bl4);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isUnwrap: " + bl5);
                }
                int[] nArray = new int[]{0, 256, 258, 1, 2, 259, 264, 261, 263, 288, 290, 291, 292, 293, 294, 295, 296};
                Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, byArray, bl, Boolean.TRUE, bl2, bl3, bl4, bl5, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8};
                pKCS11Object = this.session.createObject(nArray, objectArray);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate_1");
                }
                return new RSAPrivateKey(pKCS11Object, byArray, null, null, bl, bl2, bl3, bl4, bl5, bl6, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                byArray = this.genID();
                bigInteger = rSAPrivateKeySpec.getModulus();
                bigInteger3 = rSAPrivateKeySpec.getPrivateExponent();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Modulus not CRT: " + bigInteger.intValue());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent length not CRT: " + bigInteger3.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent not CRT: " + bigInteger3);
                }
                int[] nArray = new int[]{0, 256, 258, 1, 2, 259, 264, 261, 263, 288, 291};
                Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, byArray, bl, Boolean.TRUE, bl2, bl3, bl4, bl5, bigInteger, bigInteger3};
                pKCS11Object = this.session.createObject(nArray, objectArray);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate_2");
                }
                return new RSAPrivateKey(pKCS11Object, byArray, null, null, bl, bl2, bl3, bl4, bl5, bl6, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            }
            if (keySpec instanceof PKCS11KeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
                }
                pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
                return new RSAPrivateKey(pKCS11Object, (byte[])this.getAttrValue(pKCS11Object, 258), (byte[])this.getAttrValue(pKCS11Object, 257), (String)this.getAttrValue(pKCS11Object, 3), (Boolean)this.getAttrValue(pKCS11Object, 1), (Boolean)this.getAttrValue(pKCS11Object, 259), (Boolean)this.getAttrValue(pKCS11Object, 264), (Boolean)this.getAttrValue(pKCS11Object, 261), (Boolean)this.getAttrValue(pKCS11Object, 263), (Boolean)this.getAttrValue(pKCS11Object, 354), (BigInteger)this.getAttrValue(pKCS11Object, 288), (BigInteger)this.getAttrValue(pKCS11Object, 290), (BigInteger)this.getAttrValue(pKCS11Object, 291), (BigInteger)this.getAttrValue(pKCS11Object, 292), (BigInteger)this.getAttrValue(pKCS11Object, 293), (BigInteger)this.getAttrValue(pKCS11Object, 294), (BigInteger)this.getAttrValue(pKCS11Object, 295), (BigInteger)this.getAttrValue(pKCS11Object, 296));
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGeneratePrivate", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGeneratePrivate");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGeneratePrivate", (Throwable)invalidKeyException);
                debug.exit(16384L, (Object)className, "engineGeneratePrivate");
            }
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)key, (Object)clazz);
        }
        try {
            if (key instanceof PKCS11RSAPublicKey) {
                Class<?> clazz2 = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz2.isAssignableFrom(clazz)) {
                    RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec");
                    }
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_1");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_2", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_2");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz4 = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> clazz5 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_3");
                    }
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_4");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_5", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_5");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11RSAPrivateKey) {
                Class<?> clazz6 = Class.forName("java.security.spec.RSAPrivateCrtKeySpec");
                Class<?> clazz7 = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (clazz6.isAssignableFrom(clazz)) {
                    RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                    if (rSAPrivateKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_6", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_6");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_7");
                    }
                    return new RSAPrivateCrtKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                    if (rSAPrivateKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_8", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_8");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_9");
                    }
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof RSAPrivateCrtKey) {
                Class<?> clazz8 = Class.forName("java.security.spec.RSAPrivateCrtKeySpec");
                if (clazz8.isAssignableFrom(clazz)) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_10");
                    }
                    return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_11", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_11");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz9 = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (clazz9.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_12");
                    }
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_13", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_13");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec_14", "Inappropriate key type");
                debug.exit(16384L, (Object)className, "engineGetKeySpec_14");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)classNotFoundException);
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)key);
        }
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPublicKeySpec == null ? (class$java$security$spec$RSAPublicKeySpec = RSAPKCS11KeyFactory.class$("java.security.spec.RSAPublicKeySpec")) : class$java$security$spec$RSAPublicKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPublicKey");
                }
                return this.engineGeneratePublic(rSAPublicKeySpec);
            }
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPrivateCrtKeySpec == null ? (class$java$security$spec$RSAPrivateCrtKeySpec = RSAPKCS11KeyFactory.class$("java.security.spec.RSAPrivateCrtKeySpec")) : class$java$security$spec$RSAPrivateCrtKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPrivateCrtKey");
                }
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPrivateKeySpec == null ? (class$java$security$spec$RSAPrivateKeySpec = RSAPKCS11KeyFactory.class$("java.security.spec.RSAPrivateKeySpec")) : class$java$security$spec$RSAPrivateKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPrivateKey");
                }
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Wrong algorithm type");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)invalidKeySpecException);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }

    private byte[] genID() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        return byArray;
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

