/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11MD5withRSASingle
extends SignatureSpi {
    private Signature sig;
    private Hash md5;
    private String oid = "1.2.840.113549.2.5";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean reset = false;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11md5withrsasingle");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11MD5withRSASingle";

    public PKCS11MD5withRSASingle() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS11MD5withRSASingle");
        }
        this.sig = new Signature(1);
        this.md5 = new Hash(528);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PKCS11MD5withRSASingle");
        }
    }

    protected void engineSetParameter(String string, Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetParameter");
            debug.exit(16384L, (Object)className, "engineSetParameter");
        }
    }

    protected Object engineGetParameter(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameter");
            debug.exit(16384L, (Object)className, "engineGetParameter");
        }
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitSign");
        }
        this.privateKey = privateKey;
        if (this.reset) {
            this.md5.engineReset();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitVerify");
        }
        this.publicKey = publicKey;
        if (this.reset) {
            this.md5.engineReset();
        }
    }

    protected void engineUpdate(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)new String("b = " + by));
        }
        byte[] byArray = new byte[]{by};
        this.md5.engineUpdate(byArray, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)new String("data = " + byArray + " off = " + n + " len = " + n2));
        }
        this.md5.engineUpdate(byArray, n, n2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        byte[] byArray = this.md5.engineDigest();
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            object = new DerOutputStream();
            AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
            algorithmId.encode(object);
            DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray)};
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSign", (Throwable)iOException);
            }
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSign", (Throwable)noSuchAlgorithmException);
            }
            throw new SignatureException("error encoding signature");
        }
        object = derOutputStream.toByteArray();
        try {
            this.sig.engineInitSign(this.privateKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return this.sig.engineSign((byte[])object, ((DerOutputStream)object).length);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify");
        }
        byte[] byArray2 = this.md5.engineDigest();
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            object = new DerOutputStream();
            AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
            algorithmId.encode(object);
            DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray2)};
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineVerify", (Throwable)iOException);
            }
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineVerify", (Throwable)noSuchAlgorithmException);
            }
            throw new SignatureException("error encoding signature");
        }
        object = derOutputStream.toByteArray();
        try {
            this.sig.engineInitVerify(this.publicKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        return this.sig.engineVerify(byArray, (byte[])object, ((DerOutputStream)object).length);
    }
}

