/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private static Date returnDate = new Date(0L);
    private PKCS11Session session = null;
    private Hashtable entries = new Hashtable();

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)v).key;
            }
            if (v instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)v).key;
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
            certificateArray = (Certificate[])((PrivateKeyEntry)v).chain.clone();
        }
        return certificateArray;
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                certificate = ((TrustedCertEntry)v).cert;
            } else if (v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
                certificate = ((PrivateKeyEntry)v).chain[0];
            }
        }
        return certificate;
    }

    public Date engineGetCreationDate(String string) {
        return returnDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object = null;
            if (this.engineIsCertificateEntry(string)) {
                throw new KeyStoreException("Alias exists for a certificate entry");
            }
            if (key instanceof PKCS11PrivateKey) {
                PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                privateKeyEntry.key = key;
                privateKeyEntry.keyObject = ((PKCS11PrivateKey)key).getObject();
                privateKeyEntry.chain = certificateArray != null ? (Certificate[])certificateArray.clone() : null;
                object = privateKeyEntry;
            } else if (key instanceof PKCS11SecretKey) {
                SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                secretKeyEntry.key = key;
                secretKeyEntry.keyObject = ((PKCS11SecretKey)key).getObject();
                object = secretKeyEntry;
            } else if (key instanceof PrivateKey) {
                PKCS11PrivateKey pKCS11PrivateKey;
                block20: {
                    String string2 = key.getAlgorithm();
                    pKCS11PrivateKey = null;
                    KeyFactory keyFactory = null;
                    try {
                        if (string2.equalsIgnoreCase("DSA")) {
                            keyFactory = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                            pKCS11PrivateKey = (PKCS11PrivateKey)keyFactory.translateKey(key);
                            break block20;
                        }
                        if (string2.equalsIgnoreCase("RSA")) {
                            keyFactory = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                            pKCS11PrivateKey = (PKCS11PrivateKey)keyFactory.translateKey(key);
                            break block20;
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + string2);
                    }
                    catch (Exception exception) {
                        throw new KeyStoreException("Keystore can not handle this key: " + exception.getMessage());
                    }
                }
                PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                privateKeyEntry.key = pKCS11PrivateKey;
                privateKeyEntry.keyObject = pKCS11PrivateKey.getObject();
                privateKeyEntry.chain = certificateArray != null ? (Certificate[])certificateArray.clone() : null;
                object = privateKeyEntry;
            } else if (key instanceof SecretKey) {
                PKCS11SecretKey pKCS11SecretKey;
                block21: {
                    String string3 = key.getAlgorithm();
                    pKCS11SecretKey = null;
                    SecretKeyFactory secretKeyFactory = null;
                    try {
                        if (string3.equalsIgnoreCase("DES")) {
                            secretKeyFactory = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                            pKCS11SecretKey = (PKCS11SecretKey)secretKeyFactory.translateKey((SecretKey)key);
                            break block21;
                        }
                        if (string3.equalsIgnoreCase("3DES") || string3.equalsIgnoreCase("DESede") || string3.equalsIgnoreCase("TripleDES")) {
                            secretKeyFactory = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                            pKCS11SecretKey = (PKCS11SecretKey)secretKeyFactory.translateKey((SecretKey)key);
                            break block21;
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + string3);
                    }
                    catch (Exception exception) {
                        throw new KeyStoreException("Keystore can not handle this key: " + exception.getMessage());
                    }
                }
                SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                secretKeyEntry.key = pKCS11SecretKey;
                secretKeyEntry.keyObject = pKCS11SecretKey.getObject();
                object = secretKeyEntry;
            } else {
                throw new KeyStoreException("Invalid key type");
            }
            this.entries.put(string.toLowerCase(), object);
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            PKCS11Object pKCS11Object = null;
            if (certificate instanceof X509Certificate) {
                Object object2;
                object = null;
                byte[] byArray = null;
                try {
                    byArray = string.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                byte[] byArray2 = null;
                BigInteger bigInteger = null;
                DerOutputStream derOutputStream = null;
                if (byArray.length > 20) {
                    object2 = new byte[20];
                    System.arraycopy(byArray, 0, object2, 0, 20);
                    byArray = object2;
                }
                try {
                    object2 = CertificateFactory.getInstance("X509", "IBMPKCS11Impl");
                    if (certificate instanceof X509CertImpl) {
                        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                        object = derOutputStream.toByteArray();
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                        byArray2 = derOutputStream.toByteArray();
                        bigInteger = x509CertImpl.getSerialNumber();
                        pKCS11Object = this.createCertObject(string, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate.getEncoded());
                    X509CertImpl x509CertImpl = (X509CertImpl)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                    object = derOutputStream.toByteArray();
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                    bigInteger = x509CertImpl.getSerialNumber();
                    pKCS11Object = this.createCertObject(string, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                }
                catch (Exception exception) {
                    throw new KeyStoreException("Cannot store certificate :" + exception.getMessage());
                }
            } else {
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            object = new TrustedCertEntry();
            object.cert = certificate;
            object.certObject = pKCS11Object;
            this.entries.put(string.toLowerCase(), object);
        }
    }

    private PKCS11Object createCertObject(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger) throws KeyStoreException {
        int[] nArray = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE, Boolean.FALSE, Boolean.FALSE, string, PKCS11Object.X_509, byArray3, byArray2, bigInteger.toByteArray(), byArray, byArray4};
        PKCS11Object pKCS11Object = null;
        try {
            pKCS11Object = this.session.createObject(nArray, objectArray);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot store certificate: " + exception.getMessage());
        }
        return pKCS11Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (this.engineIsKeyEntry(string)) {
                Object v = this.entries.get(string.toLowerCase());
                if (v instanceof PrivateKeyEntry) {
                    PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)v;
                    ((PKCS11Key)privateKeyEntry.key).getObject().destroy();
                } else {
                    SecretKeyEntry secretKeyEntry = (SecretKeyEntry)v;
                    ((PKCS11Key)secretKeyEntry.key).getObject().destroy();
                }
            } else if (this.engineIsCertificateEntry(string)) {
                TrustedCertEntry trustedCertEntry = (TrustedCertEntry)this.entries.get(string.toLowerCase());
                trustedCertEntry.certObject.destroy();
            }
            this.entries.remove(string.toLowerCase());
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
            bl = true;
        }
        return bl;
    }

    public boolean engineIsCertificateEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof TrustedCertEntry) {
            bl = true;
        }
        return bl;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (!(v instanceof PrivateKeyEntry) || ((PrivateKeyEntry)v).chain == null) continue;
                certificate2 = ((PrivateKeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineLoad");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            int n;
            Object object8;
            int n2;
            int n3;
            Vector<PKCS11Object> vector;
            CertificateFactory certificateFactory;
            block128: {
                String string;
                Object object9;
                PKCS11Object pKCS11Object;
                block119: {
                    this.entries.clear();
                    pKCS11Object = null;
                    object9 = null;
                    certificateFactory = null;
                    try {
                        certificateFactory = CertificateFactory.getInstance("X509", "IBMPKCS11Impl");
                    }
                    catch (Exception exception) {
                        if (debug == null) break block119;
                        exception.printStackTrace();
                        if (debug != null) {
                            debug.exit(16384L, (Object)className, "engineLoad");
                        }
                        System.exit(1);
                    }
                }
                Vector<PKCS11Object> vector2 = new Vector<PKCS11Object>();
                Vector<PKCS11Object> vector3 = new Vector<PKCS11Object>();
                vector = new Vector<PKCS11Object>();
                this.session = IBMPKCS11Impl.session;
                this.session.findObjectsInit(null, null);
                while ((pKCS11Object = this.session.findObject()) != null) {
                    object9 = this.getValue(pKCS11Object, 0);
                    if (object9 != null && ((Integer)object9).equals(PKCS11Object.PRIVATE_KEY)) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "found PRIVATE KEY");
                        }
                        vector2.add(pKCS11Object);
                        continue;
                    }
                    if (object9 != null && ((Integer)object9).equals(PKCS11Object.CERTIFICATE)) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                        }
                        vector.add(pKCS11Object);
                        continue;
                    }
                    if (object9 == null || !((Integer)object9).equals(PKCS11Object.SECRET_KEY)) continue;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                    }
                    vector3.add(pKCS11Object);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + vector2.size() + " # certs=" + vector.size() + " # secret keys=" + vector3.size());
                }
                String string2 = "privateKey";
                n3 = 0;
                n2 = 0;
                if (vector2.size() > 0) {
                    object8 = vector2.elements();
                    n = 0;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                    }
                    while (object8.hasMoreElements()) {
                        Object object10;
                        Object object11;
                        Object object12;
                        X509Certificate[] x509CertificateArray;
                        block121: {
                            Object object13;
                            block120: {
                                Object object14;
                                object7 = (PKCS11Object)object8.nextElement();
                                string = (String)this.getValue((PKCS11Object)object7, 3);
                                object6 = (byte[])this.getValue((PKCS11Object)object7, 258);
                                object5 = (byte[])this.getValue((PKCS11Object)object7, 257);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "within the private key loop");
                                }
                                object4 = "e";
                                if (object6 == null) continue;
                                int n4 = vector.size();
                                object3 = vector.elements();
                                object2 = null;
                                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                                object = new HashSet<TrustAnchor>();
                                X509Certificate x509Certificate = null;
                                X509Certificate x509Certificate2 = null;
                                x509CertificateArray = null;
                                int n5 = 0;
                                while (n5 < n4) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "going through cert objects");
                                    }
                                    object2 = (PKCS11Object)object3.nextElement();
                                    object13 = (byte[])this.getValue((PKCS11Object)object2, 258);
                                    object12 = (byte[])this.getValue((PKCS11Object)object2, 257);
                                    object11 = (byte[])this.getValue((PKCS11Object)object2, 17);
                                    object14 = new ByteArrayInputStream((byte[])object11);
                                    x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object14);
                                    if (object13 != null && this.bytesEquals((byte[])object6, (byte[])object13)) {
                                        x509Certificate = x509Certificate2;
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "found cert at pos" + n5 + " # of certs now = " + arrayList.size());
                                        }
                                    }
                                    arrayList.add(x509Certificate2);
                                    ((HashSet)object).add(new TrustAnchor(x509Certificate2, null));
                                    ++n5;
                                }
                                if (x509Certificate != null) {
                                    try {
                                        object13 = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                                        object12 = new X509CertSelector();
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "building certpath");
                                        }
                                        object11 = x509Certificate.getSubjectDN().toString();
                                        ((X509CertSelector)object12).setSubject((String)object11);
                                        object14 = new PKIXBuilderParameters((Set<TrustAnchor>)object, (CertSelector)object12);
                                        ((PKIXParameters)object14).setRevocationEnabled(false);
                                        ((PKIXBuilderParameters)object14).setMaxPathLength(-1);
                                        object10 = new CollectionCertStoreParameters(arrayList);
                                        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)object10, "IBMCertPath");
                                        ((PKIXParameters)object14).addCertStore(certStore);
                                        try {
                                            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)((CertPathBuilder)object13).build((CertPathParameters)object14);
                                            CertPath certPath = pKIXCertPathBuilderResult.getCertPath();
                                            if (certPath != null) {
                                                List<? extends Certificate> list = certPath.getCertificates();
                                                int n6 = 0;
                                                x509CertificateArray = new X509Certificate[list.size() + 1];
                                                Iterator<? extends Certificate> iterator = list.iterator();
                                                while (iterator.hasNext()) {
                                                    x509CertificateArray[n6++] = (X509Certificate)iterator.next();
                                                }
                                                x509CertificateArray[n6] = pKIXCertPathBuilderResult.getTrustAnchor().getTrustedCert();
                                            }
                                        }
                                        catch (CertPathBuilderException certPathBuilderException) {
                                            if (debug != null) {
                                                debug.text(16384L, (Object)className, "engineLoad_0", "could not build CertPath for certificate " + certPathBuilderException.getMessage());
                                            }
                                            x509CertificateArray = null;
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (debug == null) break block120;
                                        debug.exception(16384L, (Object)className, "engineLoad_1", (Throwable)exception);
                                    }
                                }
                            }
                            object13 = (Integer)this.getValue((PKCS11Object)object7, 256);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "Key Type=" + ((Integer)object13).toString());
                            }
                            object12 = null;
                            if (((Integer)object13).equals(PKCS11Object.RSA)) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA(...) clear");
                                    }
                                    object12 = new RSAPrivateKey((PKCS11Object)object7, (byte[])this.getValue((PKCS11Object)object7, 258), (byte[])this.getValue((PKCS11Object)object7, 257), (String)this.getValue((PKCS11Object)object7, 3), (Boolean)this.getValue((PKCS11Object)object7, 1), (Boolean)this.getValue((PKCS11Object)object7, 259), (Boolean)this.getValue((PKCS11Object)object7, 264), (Boolean)this.getValue((PKCS11Object)object7, 261), (Boolean)this.getValue((PKCS11Object)object7, 263), (Boolean)this.getValue((PKCS11Object)object7, 354), (BigInteger)this.getValue((PKCS11Object)object7, 288), (BigInteger)this.getValue((PKCS11Object)object7, 290), (BigInteger)this.getValue((PKCS11Object)object7, 291), (BigInteger)this.getValue((PKCS11Object)object7, 292), (BigInteger)this.getValue((PKCS11Object)object7, 293), (BigInteger)this.getValue((PKCS11Object)object7, 294), (BigInteger)this.getValue((PKCS11Object)object7, 295), (BigInteger)this.getValue((PKCS11Object)object7, 296));
                                }
                                catch (Exception exception) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA() hardware");
                                        }
                                        object12 = new RSAPrivateKey((PKCS11Object)object7, (byte[])this.getValue((PKCS11Object)object7, 258), (byte[])this.getValue((PKCS11Object)object7, 257), (String)this.getValue((PKCS11Object)object7, 3), (Boolean)this.getValue((PKCS11Object)object7, 1), (Boolean)this.getValue((PKCS11Object)object7, 259), (Boolean)this.getValue((PKCS11Object)object7, 264), (Boolean)this.getValue((PKCS11Object)object7, 261), (Boolean)this.getValue((PKCS11Object)object7, 263), (Boolean)this.getValue((PKCS11Object)object7, 354), (BigInteger)this.getValue((PKCS11Object)object7, 288), (BigInteger)this.getValue((PKCS11Object)object7, 290));
                                        break block121;
                                    }
                                    catch (InvalidKeyException invalidKeyException) {
                                        if (debug != null) {
                                            debug.exception(16384L, (Object)className, "engineLoad_2", (Throwable)invalidKeyException);
                                        }
                                        break block121;
                                    }
                                }
                            }
                            if (!((Integer)object13).equals(PKCS11Object.DSA)) continue;
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA(...) clear");
                                }
                                object12 = new DSAPrivateKey((PKCS11Object)object7, (String)this.getValue((PKCS11Object)object7, 3), (byte[])this.getValue((PKCS11Object)object7, 258), (byte[])this.getValue((PKCS11Object)object7, 257), (Boolean)this.getValue((PKCS11Object)object7, 1), (Boolean)this.getValue((PKCS11Object)object7, 259), (Boolean)this.getValue((PKCS11Object)object7, 354), (BigInteger)this.getValue((PKCS11Object)object7, 304), (BigInteger)this.getValue((PKCS11Object)object7, 305), (BigInteger)this.getValue((PKCS11Object)object7, 306), new BigInteger(1, (byte[])this.getValue((PKCS11Object)object7, 17)));
                            }
                            catch (Exception exception) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                                    }
                                    object12 = new DSAPrivateKey((PKCS11Object)object7, (String)this.getValue((PKCS11Object)object7, 3), (byte[])this.getValue((PKCS11Object)object7, 258), (byte[])this.getValue((PKCS11Object)object7, 257), (Boolean)this.getValue((PKCS11Object)object7, 1), (Boolean)this.getValue((PKCS11Object)object7, 259), (Boolean)this.getValue((PKCS11Object)object7, 354));
                                }
                                catch (InvalidKeyException invalidKeyException) {
                                    if (debug == null) break block121;
                                    debug.exception(16384L, (Object)className, "engineLoad_3", (Throwable)invalidKeyException);
                                }
                            }
                        }
                        object11 = new PrivateKeyEntry();
                        ((PrivateKeyEntry)object11).key = object12;
                        ((PrivateKeyEntry)object11).keyObject = object7;
                        ((PrivateKeyEntry)object11).chain = x509CertificateArray;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Entry: \n key =" + object12.toString() + "\nkeyObject =" + object7 + "\nchain = " + x509CertificateArray + "\nLabel = " + string);
                        }
                        if (string != null && string.length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (!this.entries.containsKey(string.toLowerCase())) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(string.toLowerCase(), object11);
                                if (debug == null) continue;
                                System.out.println("PKCS11IMPLKS: put key entry[" + string.toLowerCase() + "] to entries");
                                continue;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                            }
                            boolean bl = false;
                            while (!bl) {
                                object10 = string + "key" + n2;
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "finding label: " + (String)object10);
                                }
                                if (this.entries.get(((String)object10).toLowerCase()) == null) {
                                    this.entries.put(((String)object10).toLowerCase(), object11);
                                    if (debug != null) {
                                        System.out.println("PKCS11IMPLKS: put key entry[" + ((String)object10).toLowerCase() + "] to entries");
                                    }
                                    bl = true;
                                    continue;
                                }
                                ++n2;
                            }
                            continue;
                        }
                        boolean bl = false;
                        while (!bl) {
                            object10 = string2 + n3;
                            if (!this.entries.containsKey(((String)object10).toLowerCase())) {
                                this.entries.put(((String)object10).toLowerCase(), object11);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put key entry[" + ((String)object10).toLowerCase() + "] to entries");
                                }
                                bl = true;
                                continue;
                            }
                            ++n3;
                        }
                    }
                    vector2.removeAllElements();
                }
                string2 = "secretKey";
                n3 = 0;
                n2 = 0;
                if (vector3.size() <= 0) break block128;
                int n7 = vector3.size();
                Enumeration enumeration = vector3.elements();
                int n8 = 0;
                while (n8 < n7) {
                    block123: {
                        block124: {
                            block122: {
                                string = null;
                                object6 = null;
                                try {
                                    string = (PKCS11Object)enumeration.nextElement();
                                    object6 = (String)this.getValue((PKCS11Object)string, 3);
                                    if (debug == null) break block122;
                                    debug.text(16384L, (Object)className, "engineLoad", "sobj: " + string);
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    n8 = n7;
                                    break block123;
                                }
                            }
                            object5 = (Integer)this.getValue((PKCS11Object)string, 256);
                            object4 = null;
                            if (((Integer)object5).equals(PKCS11Object.DES)) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DES(...) clear");
                                    }
                                    object4 = new DESKey((PKCS11Object)string, (byte[])this.getValue((PKCS11Object)string, 258), (String)this.getValue((PKCS11Object)string, 3), (Boolean)this.getValue((PKCS11Object)string, 1), (Boolean)this.getValue((PKCS11Object)string, 259), (Boolean)this.getValue((PKCS11Object)string, 260), (Boolean)this.getValue((PKCS11Object)string, 262), (Boolean)this.getValue((PKCS11Object)string, 354), (byte[])this.getValue((PKCS11Object)string, 17));
                                }
                                catch (Exception exception) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure DES() hardware");
                                        }
                                        object4 = new DESKey((PKCS11Object)string, (byte[])this.getValue((PKCS11Object)string, 258), (String)this.getValue((PKCS11Object)string, 3), (Boolean)this.getValue((PKCS11Object)string, 1), (Boolean)this.getValue((PKCS11Object)string, 259), (Boolean)this.getValue((PKCS11Object)string, 260), (Boolean)this.getValue((PKCS11Object)string, 262), (Boolean)this.getValue((PKCS11Object)string, 354));
                                        break block124;
                                    }
                                    catch (InvalidKeyException invalidKeyException) {
                                        if (debug != null) {
                                            debug.exception(16384L, (Object)className, "engineLoad_4", (Throwable)invalidKeyException);
                                        }
                                        break block124;
                                    }
                                }
                            }
                            if (!((Integer)object5).equals(PKCS11Object.DES3)) break block123;
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DESede(...) clear");
                                }
                                object4 = new DESedeKey((PKCS11Object)string, (byte[])this.getValue((PKCS11Object)string, 258), (String)this.getValue((PKCS11Object)string, 3), (Boolean)this.getValue((PKCS11Object)string, 1), (Boolean)this.getValue((PKCS11Object)string, 259), (Boolean)this.getValue((PKCS11Object)string, 260), (Boolean)this.getValue((PKCS11Object)string, 262), (Boolean)this.getValue((PKCS11Object)string, 354), (byte[])this.getValue((PKCS11Object)string, 17));
                            }
                            catch (Exception exception) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DESede() hardware");
                                    }
                                    object4 = new DESedeKey((PKCS11Object)string, (byte[])this.getValue((PKCS11Object)string, 258), (String)this.getValue((PKCS11Object)string, 3), (Boolean)this.getValue((PKCS11Object)string, 1), (Boolean)this.getValue((PKCS11Object)string, 259), (Boolean)this.getValue((PKCS11Object)string, 260), (Boolean)this.getValue((PKCS11Object)string, 262), (Boolean)this.getValue((PKCS11Object)string, 354));
                                }
                                catch (InvalidKeyException invalidKeyException) {
                                    if (debug == null) break block124;
                                    exception.printStackTrace();
                                    debug.exception(16384L, (Object)className, "engineLoad_5", (Throwable)invalidKeyException);
                                }
                            }
                        }
                        SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                        secretKeyEntry.key = object4;
                        secretKeyEntry.keyObject = string;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + object4.toString() + "\nkeyObject =" + string + "\nLabel = " + (String)object6);
                        }
                        if (object6 != null && ((String)object6).length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(((String)object6).toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(((String)object6).toLowerCase(), secretKeyEntry);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put secret key entry[" + ((String)object6).toLowerCase() + "] to entries");
                                }
                            } else {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                }
                                boolean bl = false;
                                while (!bl) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                    }
                                    if (this.entries.get(((String)(object2 = (String)object6 + "sec" + n2)).toLowerCase()) == null) {
                                        this.entries.put(((String)object2).toLowerCase(), secretKeyEntry);
                                        if (debug != null) {
                                            System.out.println("PKCS11IMPLKS: put secret key entry[" + ((String)object2).toLowerCase() + "] to entries");
                                        }
                                        bl = true;
                                        continue;
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            boolean bl = false;
                            while (!bl) {
                                object2 = string2 + n3;
                                if (!this.entries.containsKey(((String)object2).toLowerCase())) {
                                    this.entries.put(((String)object2).toLowerCase(), secretKeyEntry);
                                    if (debug != null) {
                                        System.out.println("PKCS11IMPLKS: put secret key entry[" + ((String)object2).toLowerCase() + "] to entries");
                                    }
                                    bl = true;
                                    continue;
                                }
                                ++n3;
                            }
                        }
                    }
                    ++n8;
                }
                vector3.removeAllElements();
            }
            object8 = "cert";
            n3 = 0;
            if (vector.size() > 0) {
                n = vector.size();
                object7 = vector.elements();
                int n9 = 0;
                while (n9 < n) {
                    block126: {
                        byte[] byArray;
                        block127: {
                            block125: {
                                object6 = null;
                                try {
                                    object6 = (PKCS11Object)object7.nextElement();
                                    if (debug == null) break block125;
                                    debug.text(16384L, (Object)className, "engineLoad", "cobj: " + object6);
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    n9 = n;
                                    break block126;
                                }
                            }
                            object5 = (String)this.getValue((PKCS11Object)object6, 3);
                            object4 = (byte[])this.getValue((PKCS11Object)object6, 258);
                            byArray = null;
                            try {
                                byArray = (byte[])this.getValue((PKCS11Object)object6, 17);
                            }
                            catch (Exception exception) {
                                if (debug == null) break block127;
                                debug.text(16384L, (Object)className, "engineLoad", "tries to get cert value2");
                                exception.printStackTrace();
                            }
                        }
                        object3 = new ByteArrayInputStream(byArray);
                        object2 = new TrustedCertEntry();
                        ((TrustedCertEntry)object2).cert = certificateFactory.generateCertificate((InputStream)object3);
                        ((TrustedCertEntry)object2).certObject = (PKCS11Object)object6;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + ((TrustedCertEntry)object2).cert.toString() + "\n CertObject =" + object6 + "\nLabel = " + (String)object5);
                        }
                        if (object5 != null && ((String)object5).length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(((String)object5).toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(((String)object5).toLowerCase(), object2);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put cert entry[" + ((String)object5).toLowerCase() + "] to entries");
                                }
                            } else {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                }
                                boolean bl = false;
                                while (!bl) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                    }
                                    if (this.entries.get(((String)(object = (String)object5 + "cert" + n2)).toLowerCase()) == null) {
                                        this.entries.put(((String)object).toLowerCase(), object2);
                                        if (debug != null) {
                                            System.out.println("PKCS11IMPLKS: put cert entry[" + ((String)object).toLowerCase() + "] to entries");
                                        }
                                        bl = true;
                                        continue;
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            boolean bl = false;
                            while (!bl) {
                                object = (String)object8 + n3;
                                if (!this.entries.containsKey(((String)object).toLowerCase())) {
                                    this.entries.put(((String)object).toLowerCase(), object2);
                                    if (debug != null) {
                                        System.out.println("PKCS11IMPLKS: put cert entry[" + ((String)object).toLowerCase() + "] to entries");
                                    }
                                    bl = true;
                                    continue;
                                }
                                ++n3;
                            }
                        }
                    }
                    ++n9;
                }
                vector.removeAllElements();
            }
            try {
                this.session.findObjectsFinal();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineLoad");
        }
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object = null;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    private Object[] getAttributes(PKCS11Object pKCS11Object) {
        return null;
    }

    private boolean bytesEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void finalize() {
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;

        TrustedCertEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }
}

