/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class genPFX {
    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        char[] cArray = null;
        try {
            PKCSDerObject pKCSDerObject;
            byte[] byArray;
            Object object;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (((String)object).equals("-c")) {
                    if (string != null) {
                        System.out.println("ERROR: Certificate has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    string = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-s")) {
                    if (string2 != null || string3 != null) {
                        System.out.println("ERROR: Key has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    string3 = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-k")) {
                    if (string2 != null || string3 != null) {
                        System.out.println("ERROR: Key has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    string2 = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-p")) {
                    if (string5 != null) {
                        System.out.println("ERROR: Algorithm has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    string5 = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-m")) {
                    if (cArray != null) {
                        System.out.println("ERROR: Password has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    cArray = stringArray[++i].toCharArray();
                    continue;
                }
                if (((String)object).equals("-f")) {
                    if (string6 != null) {
                        System.out.println("ERROR: Friendly name has already been specified.");
                        genPFX.usage();
                        System.exit(1);
                    }
                    string6 = stringArray[++i];
                    continue;
                }
                if (!((String)object).equals("-o")) continue;
                if (string4 != null) {
                    System.out.println("ERROR: Output file has already been specified.");
                    genPFX.usage();
                    System.exit(1);
                }
                string4 = stringArray[++i] + ".p12";
            }
            if (cArray == null) {
                System.out.println("ERROR: Password must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (string == null) {
                System.out.println("ERROR: Certificate must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (string6 == null) {
                System.out.println("ERROR: Friendly name must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (string4 == null) {
                System.out.println("ERROR: Output file must be specified.");
                genPFX.usage();
                System.exit(1);
            }
            if (string5 == null) {
                string5 = "40BitRC2";
            }
            System.out.println("Creating PFX from input files.");
            System.out.println("Using friendly name " + string6);
            object = new PFX();
            System.out.println("Processing certificate from " + string);
            FileInputStream fileInputStream = new FileInputStream(string);
            X509CertImpl x509CertImpl = new X509CertImpl(fileInputStream);
            byte[] byArray2 = ((Certificate)x509CertImpl).getPublicKey().getEncoded();
            fileInputStream.read(byArray2);
            fileInputStream.close();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray2);
            byte[] byArray3 = messageDigest.digest();
            ((PFX)object).addCertificate(x509CertImpl, string6, byArray3);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            System.out.println("key id:");
            System.out.println(hexDumpEncoder.encodeBuffer(byArray3));
            if (string2 != null) {
                System.out.println("Processing private key from " + string2);
                fileInputStream = new FileInputStream(string2);
                byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                pKCSDerObject = new PrivateKeyInfo(byArray);
                ((PFX)object).addPrivateKey((PrivateKey)((Object)pKCSDerObject), string6, byArray3);
                fileInputStream.close();
            }
            if (string3 != null) {
                System.out.println("Processing shrouded key from " + string3);
                fileInputStream = new FileInputStream(string3);
                byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                pKCSDerObject = new EncryptedPrivateKeyInfo(byArray);
                ((PFX)object).addShroudedKey((EncryptedPrivateKeyInfo)pKCSDerObject, string6, byArray3);
                fileInputStream.close();
            }
            System.out.println("Protecting data with algorithm PBEWithSHAAnd" + string5);
            ((PFX)object).protect(string5, cArray);
            System.out.println("Writing PFX to file " + string4);
            ((PKCSDerObject)object).write(string4, false);
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: genPFX -m mac_pwd -f friendly_name -c certfile");
        System.out.println("              [[-k keyfile] | [-s shrouded_keyfile]]");
        System.out.println("              [-p alg] -o outfile");
        System.out.println("       where mac_pwd is a password used for data integrity and privacy");
        System.out.println("             friendly_name is an alias attached to the personal data");
        System.out.println("             certfile contains an X.509 certificate");
        System.out.println("             keyfile or shrouded_keyfile contains a private key");
        System.out.println("                 - only one of them may be specified");
        System.out.println("             alg is the encryption algorithm for data protection");
        System.out.println("                 - the default is 40BitRC2");
        System.out.println("             outfile is the file the DER-encoded PFX will be written to");
        System.out.println("                 (with a .p12 extension)");
    }
}

