/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.util.DerOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class PKCS10NewMimeDataSource
implements DataSource,
Cloneable {
    private CertificationRequest certRequest;
    public static final String CONTENT_TYPE_PKCS10 = "application/pkcs10";
    private static final String CERTIFICATION_REQUEST_NAME = "CertificationRequest";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS10NewMimeDataSource";

    private PKCS10NewMimeDataSource(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "PKCS10NewMimeDataSource", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(8192L, className, "PKCS10NewMimeDataSource");
        }
    }

    public PKCS10NewMimeDataSource(CertificationRequest certificationRequest) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS10NewMimeDataSource", certificationRequest);
        }
        if (certificationRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10NewMimeDataSource", "CertificationRequest is null.");
            }
            throw new IllegalArgumentException("CertificationRequest is null.");
        }
        this.certRequest = certificationRequest;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10NewMimeDataSource");
        }
    }

    public PKCS10NewMimeDataSource(CertificationRequest certificationRequest, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS10NewMimeDataSource", certificationRequest, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (certificationRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10NewMimeDataSource", "CertificationRequest is null.");
            }
            throw new IllegalArgumentException("CertificationRequest is null.");
        }
        this.certRequest = certificationRequest;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10NewMimeDataSource");
        }
    }

    public PKCS10NewMimeDataSource(byte[] byArray, boolean bl) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS10NewMimeDataSource", byArray, new Boolean(bl));
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10NewMimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        byte[] byArray2 = byArray;
        if (bl) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            byArray2 = bASE64Decoder.decodeBuffer(byteArrayInputStream);
        }
        this.certRequest = new CertificationRequest(byArray2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10NewMimeDataSource");
        }
    }

    public PKCS10NewMimeDataSource(byte[] byArray, boolean bl, String string) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, new Boolean(bl), string};
            debug.entry(16384L, (Object)className, "PKCS10NewMimeDataSource", objectArray);
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10NewMimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        objectArray = byArray;
        if (string != null) {
            this.provider = new String(string);
        }
        if (bl) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectArray = bASE64Decoder.decodeBuffer(byteArrayInputStream);
        }
        this.certRequest = new CertificationRequest((byte[])objectArray, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10NewMimeDataSource");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            PKCS10NewMimeDataSource pKCS10NewMimeDataSource = new PKCS10NewMimeDataSource(this.certRequest, this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", pKCS10NewMimeDataSource);
            }
            return pKCS10NewMimeDataSource;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    private void setCertificationRequest(CertificationRequest certificationRequest) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCertificationRequest", certificationRequest);
            debug.exit(8192L, className, "setCertificationRequest");
        }
        this.certRequest = certificationRequest;
    }

    public CertificationRequest getCertificationRequest() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
            debug.exit(16384L, (Object)className, "getCertificationRequest", this.certRequest);
        }
        return this.certRequest;
    }

    public InputStream getInputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getInputStream");
        }
        if (this.certRequest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getInputStream_1", null);
            }
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.certRequest.encode(derOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getInputStream_2", byteArrayInputStream);
        }
        return byteArrayInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOutputStream");
            debug.exit(16384L, (Object)className, "getOutputStream", new ByteArrayOutputStream());
        }
        return new ByteArrayOutputStream();
    }

    public String getContentType() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
        }
        if (this.certRequest != null) {
            string = CONTENT_TYPE_PKCS10;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentType", string);
        }
        return string;
    }

    public String getName() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        if (this.certRequest != null) {
            string = CERTIFICATION_REQUEST_NAME;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", string);
        }
        return string;
    }

    public String toString() {
        String string = "PKCS10NewMimeDataSource:  ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = this.certRequest != null ? string + this.certRequest.toString() : string + "Does not contain a CertificationRequest object.";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

