/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlSupport {
    private static final String PREFS_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    private static final String PREFS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT preferences (root) ><!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\"  ><!ELEMENT root (map, node*) ><!ATTLIST root          type (system|user) #REQUIRED ><!ELEMENT node (map, node*) ><!ATTLIST node          name CDATA #REQUIRED ><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private static final String MAP_XML_VERSION = "1.0";

    XmlSupport() {
    }

    static void export(OutputStream outputStream, Preferences preferences, boolean bl) throws IOException, BackingStoreException {
        if (((AbstractPreferences)preferences).isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        coreDocumentImpl.appendChild((Node)coreDocumentImpl.createDocumentType("preferences", null, PREFS_DTD_URI));
        Element element = (Element)coreDocumentImpl.appendChild((Node)coreDocumentImpl.createElement("preferences"));
        element.setAttribute("EXTERNAL_XML_VERSION", "1.0");
        Element element2 = (Element)element.appendChild(coreDocumentImpl.createElement("root"));
        element2.setAttribute("type", preferences.isUserNode() ? "user" : "system");
        ArrayList arrayList = new ArrayList();
        Preferences preferences2 = preferences;
        Preferences preferences3 = preferences2.parent();
        while (preferences3 != null) {
            arrayList.add(preferences2);
            preferences2 = preferences3;
            preferences3 = preferences2.parent();
        }
        Element element3 = element2;
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element3.appendChild(coreDocumentImpl.createElement("map"));
            element3 = (Element)element3.appendChild(coreDocumentImpl.createElement("node"));
            element3.setAttribute("name", ((Preferences)arrayList.get(n)).name());
            --n;
        }
        XmlSupport.putPreferencesInXml(element3, (Document)coreDocumentImpl, preferences, bl);
        XmlSupport.writeXMLPreferences(coreDocumentImpl, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putPreferencesInXml(Element element, Document document, Preferences preferences, boolean bl) throws BackingStoreException {
        Element element2;
        Preferences[] preferencesArray = null;
        String[] stringArray = null;
        Object object = ((AbstractPreferences)preferences).lock;
        synchronized (object) {
            if (((AbstractPreferences)preferences).isRemoved()) {
                element.getParentNode().removeChild(element);
                return;
            }
            String[] stringArray2 = preferences.keys();
            element2 = (Element)element.appendChild(document.createElement("map"));
            int n = 0;
            while (n < stringArray2.length) {
                Element element3 = (Element)element2.appendChild(document.createElement("entry"));
                element3.setAttribute("key", stringArray2[n]);
                element3.setAttribute("value", preferences.get(stringArray2[n], null));
                ++n;
            }
            if (bl) {
                stringArray = preferences.childrenNames();
                preferencesArray = new Preferences[stringArray.length];
                int n2 = 0;
                while (n2 < stringArray.length) {
                    preferencesArray[n2] = preferences.node(stringArray[n2]);
                    ++n2;
                }
            }
        }
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                element2 = (Element)element.appendChild(document.createElement("node"));
                element2.setAttribute("name", stringArray[n]);
                XmlSupport.putPreferencesInXml(element2, document, preferencesArray[n], bl);
                ++n;
            }
        }
    }

    static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        try {
            Object object;
            Object var1_1 = null;
            String string = null;
            Document document = XmlSupport.load(inputStream);
            if (document instanceof DeferredDocumentImpl) {
                object = (DeferredDocumentImpl)document;
                string = object.getXmlVersion();
            }
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Exported preferences file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            object = (Element)document.getChildNodes().item(1).getChildNodes().item(0);
            Preferences preferences = object.getAttribute("type").equals("user") ? Preferences.userRoot() : Preferences.systemRoot();
            XmlSupport.ImportSubtree(preferences, (Element)object);
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static Document load(InputStream inputStream) throws SAXException, IOException {
        Resolver resolver = new Resolver();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new Resolver());
            documentBuilder.setErrorHandler(new EH());
            return documentBuilder.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
            throw new Error(parserConfigurationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ImportSubtree(Preferences preferences, Element element) {
        Preferences[] preferencesArray;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        Object object = ((AbstractPreferences)preferences).lock;
        synchronized (object) {
            if (((AbstractPreferences)preferences).isRemoved()) {
                return;
            }
            Element element2 = (Element)nodeList.item(0);
            XmlSupport.ImportPrefs(preferences, element2);
            preferencesArray = new Preferences[n - 1];
            int n2 = 1;
            while (n2 < n) {
                Element element3 = (Element)nodeList.item(n2);
                preferencesArray[n2 - 1] = preferences.node(element3.getAttribute("name"));
                ++n2;
            }
        }
        int n3 = 1;
        while (n3 < n) {
            XmlSupport.ImportSubtree(preferencesArray[n3 - 1], (Element)nodeList.item(n3));
            ++n3;
        }
    }

    private static void ImportPrefs(Preferences preferences, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Element element2 = (Element)nodeList.item(n);
            preferences.put(element2.getAttribute("key"), element2.getAttribute("value"));
            ++n;
        }
    }

    static void exportMap(OutputStream outputStream, Map map) throws IOException {
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        coreDocumentImpl.appendChild((Node)coreDocumentImpl.createDocumentType("map", null, PREFS_DTD_URI));
        Element element = (Element)coreDocumentImpl.appendChild((Node)coreDocumentImpl.createElement("map"));
        element.setAttribute("MAP_XML_VERSION", "1.0");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Element element2 = (Element)element.appendChild(coreDocumentImpl.createElement("entry"));
            element2.setAttribute("key", (String)entry.getKey());
            element2.setAttribute("value", (String)entry.getValue());
        }
        XmlSupport.writeXMLPreferences(coreDocumentImpl, outputStream);
    }

    static void importMap(InputStream inputStream, Map map) throws IOException, InvalidPreferencesFormatException {
        try {
            Object object;
            String string = null;
            Document document = XmlSupport.load(inputStream);
            Element element = (Element)document.getChildNodes().item(1);
            if (document instanceof DeferredDocumentImpl) {
                object = (DeferredDocumentImpl)document;
                string = object.getXmlVersion();
            }
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Preferences map file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            object = element.getChildNodes();
            int n = 0;
            int n2 = object.getLength();
            while (n < n2) {
                Element element2 = (Element)object.item(n);
                map.put(element2.getAttribute("key"), element2.getAttribute("value"));
                ++n;
            }
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static void writeXMLPreferences(CoreDocumentImpl coreDocumentImpl, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        int n = coreDocumentImpl.getLength();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            XmlSupport.writeXMLNode(coreDocumentImpl.item(n2), printWriter, 0);
            printWriter.println();
            printWriter.flush();
            ++n2;
        }
    }

    private static void writeXMLNode(Node node, PrintWriter printWriter, int n) {
        int n2 = n;
        if (node == null) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            printWriter.print(' ');
            ++n3;
        }
        short s = node.getNodeType();
        switch (s) {
            case 10: {
                DocumentType documentType = (DocumentType)node;
                printWriter.print("<!DOCTYPE ");
                printWriter.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    printWriter.print(" PUBLIC '");
                    printWriter.print(string);
                    printWriter.print("' '");
                    printWriter.print(string2);
                    printWriter.print('\'');
                } else {
                    printWriter.print(" SYSTEM '");
                    printWriter.print(string2);
                    printWriter.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    printWriter.println(" [");
                    printWriter.print(string3);
                    printWriter.print(']');
                }
                printWriter.println('>');
                break;
            }
            case 1: {
                Node node2;
                printWriter.print('<');
                printWriter.print(node.getNodeName());
                Attr[] attrArray = XmlSupport.sortAttributes(node.getAttributes());
                int n4 = 0;
                while (n4 < attrArray.length) {
                    node2 = attrArray[n4];
                    printWriter.print(' ');
                    printWriter.print(node2.getNodeName());
                    printWriter.print("=\"");
                    XmlSupport.normalizeAndPrint(node2.getNodeValue(), printWriter);
                    printWriter.print('\"');
                    ++n4;
                }
                node2 = node.getFirstChild();
                if (node2 != null) {
                    printWriter.print('>');
                    printWriter.println();
                    while (node2 != null) {
                        XmlSupport.writeXMLNode(node2, printWriter, n2 + 2);
                        node2 = node2.getNextSibling();
                    }
                    int n5 = 0;
                    while (n5 < n2) {
                        printWriter.print(' ');
                        ++n5;
                    }
                    printWriter.print("</");
                    printWriter.print(node.getNodeName());
                    printWriter.println('>');
                } else {
                    printWriter.println(" />");
                }
                printWriter.flush();
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                printWriter.flush();
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                printWriter.flush();
                break;
            }
            case 3: {
                XmlSupport.normalizeAndPrint(node.getNodeValue(), printWriter);
                printWriter.flush();
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
                printWriter.flush();
            }
        }
    }

    protected static void normalizeAndPrint(String string, PrintWriter printWriter) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            XmlSupport.normalizeAndPrint(c, printWriter);
            ++n2;
        }
    }

    protected static void normalizeAndPrint(char c, PrintWriter printWriter) {
        switch (c) {
            case '<': {
                printWriter.print("&lt;");
                break;
            }
            case '>': {
                printWriter.print("&gt;");
                break;
            }
            case '&': {
                printWriter.print("&amp;");
                break;
            }
            case '\"': {
                printWriter.print("&quot;");
                break;
            }
            default: {
                printWriter.print(c);
            }
        }
    }

    private static Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            Object object;
            Object object2 = attrArray[n3].getNodeName();
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n) {
                object = attrArray[n5].getNodeName();
                if (((String)object).compareTo((String)object2) < 0) {
                    object2 = object;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                object = attrArray[n3];
                attrArray[n3] = attrArray[n4];
                attrArray[n4] = object;
            }
            ++n3;
        }
        return attrArray;
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.equals(XmlSupport.PREFS_DTD_URI)) {
                InputSource inputSource = new InputSource(new StringReader(XmlSupport.PREFS_DTD));
                inputSource.setSystemId(XmlSupport.PREFS_DTD_URI);
                return inputSource;
            }
            throw new SAXException("Invalid system identifier: " + string2);
        }
    }
}

