/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import sun.security.action.LoadLibraryAction;

public final class Bidi {
    byte dir;
    byte baselevel;
    int length;
    int[] runs;
    int[] cws;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    private static final int DIR_MIXED = 2;
    private static final char NUMLEVELS = '>';
    private static final int RMASK = 57378;

    public Bidi(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        Bidi.nativeBidiChars(this, string.toCharArray(), 0, null, 0, string.length(), n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Serializable serializable;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        int n2 = -2;
        byte[] byArray = null;
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        int n5 = n4 - n3;
        int n6 = 0;
        char[] cArray = new char[n5];
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            cArray[n6++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        try {
            serializable = (Boolean)attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
            if (serializable != null) {
                n2 = TextAttribute.RUN_DIRECTION_LTR.equals(serializable) ? 0 : 1;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            serializable = (NumericShaper)attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
            if (serializable != null) {
                ((NumericShaper)serializable).shape(cArray, 0, cArray.length);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int n7 = n3;
        do {
            attributedCharacterIterator.setIndex(n7);
            Object object = attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            n = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
            if (object == null) continue;
            try {
                int n8 = (Integer)object;
                if (n8 < -61 || n8 >= 61) continue;
                byte by = (byte)(n8 < 0 ? -n8 | 0x80 : n8);
                if (byArray == null) {
                    byArray = new byte[n5];
                }
                int n9 = n7 - n3;
                while (n9 < n - n3) {
                    byArray[n9] = by;
                    ++n9;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        } while ((n7 = n) < n4);
        Bidi.nativeBidiChars(this, cArray, 0, byArray, 0, cArray.length, n2);
    }

    public Bidi(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (cArray == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bad length: " + n3);
        }
        if (n < 0 || n3 > cArray.length - n) {
            throw new IllegalArgumentException("bad range: " + n + " length: " + n3 + " for text of length: " + cArray.length);
        }
        if (n2 + n3 < n2) {
            throw new IllegalArgumentException("bad range: " + n2 + " to " + (n2 + n3) + " for embeddings of length: " + cArray.length);
        }
        if (byArray != null && (n2 < 0 || n2 + n3 > byArray.length)) {
            throw new IllegalArgumentException("bad range: " + n2 + " to " + (n2 + n3) + " for embeddings of length: " + cArray.length);
        }
        if (byArray != null) {
            int n5 = n2;
            int n6 = n2 + n3;
            while (n5 < n6) {
                if (byArray[n5] < 0) {
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, n2, byArray2, 0, n3);
                    n5 -= n2;
                    while (n5 < n3) {
                        if (byArray2[n5] < 0) {
                            byArray2[n5] = (byte)(-byArray2[n5] | 0x80);
                        }
                        ++n5;
                    }
                    byArray = byArray2;
                    n2 = 0;
                    break;
                }
                ++n5;
            }
        }
        Bidi.nativeBidiChars(this, cArray, n, byArray, n2, n3, n4);
    }

    private Bidi(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.reset(n, n2, n3, nArray, nArray2);
    }

    private void reset(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.dir = (byte)n;
        this.baselevel = (byte)n2;
        this.length = n3;
        this.runs = nArray;
        this.cws = nArray2;
    }

    public Bidi createLineBidi(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n == 0 && n2 == this.length) {
            return this;
        }
        int n7 = n2 - n;
        if (n < 0 || n2 < n || n2 > this.length) {
            throw new IllegalArgumentException("range " + n + " to " + n2 + " is invalid for paragraph of length " + this.length);
        }
        if (this.runs == null) {
            return new Bidi(this.dir, this.baselevel, n7, null, null);
        }
        int n8 = -1;
        int[] nArray = null;
        if (this.cws != null) {
            int n9 = 0;
            n6 = this.cws.length;
            while (n9 < n6) {
                if (this.cws[n9] >= n) {
                    n6 = n9;
                    while (n6 < this.cws.length && this.cws[n6] < n2) {
                        ++n6;
                    }
                    n5 = n2 - 1;
                    while (n6 > n9 && this.cws[n6 - 1] == n5) {
                        n8 = n5--;
                        --n6;
                    }
                    if (n8 == n) {
                        return new Bidi(this.dir, this.baselevel, n7, null, null);
                    }
                    n4 = n6 - n9;
                    if (n4 <= 0) break;
                    nArray = new int[n4];
                    n3 = 0;
                    while (n3 < n4) {
                        nArray[n3] = this.cws[n9 + n3] - n;
                        ++n3;
                    }
                    break;
                }
                ++n9;
            }
        }
        int[] nArray2 = null;
        n6 = this.baselevel;
        n5 = n8 == -1 ? n2 : n8;
        n4 = 0;
        n3 = this.runs.length;
        byte by = this.dir;
        while (n4 < this.runs.length) {
            if (this.runs[n4] > n) {
                n3 = n4;
                while (n3 < this.runs.length && this.runs[n3] < n5) {
                    n3 += 2;
                }
                if (n3 > n4 || this.runs[n4 + 1] != this.baselevel) {
                    if (n8 != -1 && (n3 += 2) > n4 && this.runs[n3 - 1] != this.baselevel) {
                        nArray2 = new int[n3 - n4 + 2];
                        nArray2[n3 - n4] = n7;
                        nArray2[n3 - n4 + 1] = this.baselevel;
                    } else {
                        n5 = n2;
                        nArray2 = new int[n3 - n4];
                    }
                    int n10 = 0;
                    int n11 = n4;
                    while (n11 < n3) {
                        nArray2[n10++] = this.runs[n11] - n;
                        nArray2[n10++] = this.runs[n11 + 1];
                        n11 += 2;
                    }
                    nArray2[n10 - 2] = n5 - n;
                    break;
                }
                by = (this.runs[n4 + 1] & 1) == 0 ? (byte)0 : 1;
                break;
            }
            n4 += 2;
        }
        return new Bidi(by, this.baselevel, n7, nArray2, nArray);
    }

    public boolean isMixed() {
        return this.dir == 2;
    }

    public boolean isLeftToRight() {
        return this.dir == 0;
    }

    public boolean isRightToLeft() {
        return this.dir == 1;
    }

    public int getLength() {
        return this.length;
    }

    public boolean baseIsLeftToRight() {
        return (this.baselevel & 1) == 0;
    }

    public int getBaseLevel() {
        return this.baselevel;
    }

    public int getLevelAt(int n) {
        if (this.runs == null || n < 0 || n >= this.length) {
            return this.baselevel;
        }
        int n2 = 0;
        while (n >= this.runs[n2]) {
            n2 += 2;
        }
        return this.runs[n2 + 1];
    }

    public int getRunCount() {
        return this.runs == null ? 1 : this.runs.length / 2;
    }

    public int getRunLevel(int n) {
        return this.runs == null ? this.baselevel : this.runs[n * 2 + 1];
    }

    public int getRunStart(int n) {
        return this.runs == null || n == 0 ? 0 : this.runs[n * 2 - 2];
    }

    public int getRunLimit(int n) {
        return this.runs == null ? this.length : this.runs[n * 2];
    }

    public static boolean requiresBidi(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4;
            char c = cArray[n3];
            if (c >= '\u0591' && c <= '\u202e' && (0xE022 & 1 << (n4 = Bidi.nativeGetDirectionCode(c))) != 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] var0, int var1_1, Object[] var2_2, int var3_3, int var4_4) {
        if (var4_4 < 0) {
            throw new IllegalArgumentException("count " + var4_4 + " must be >= 0");
        }
        if (var1_1 < 0 || var1_1 + var4_4 > var0.length) {
            throw new IllegalArgumentException("levelStart " + var1_1 + " and count " + var4_4 + " out of range [0, " + var0.length + "]");
        }
        if (var3_3 < 0 || var3_3 + var4_4 > var2_2.length) {
            throw new IllegalArgumentException("objectStart " + var3_3 + " and count " + var4_4 + " out of range [0, " + var2_2.length + "]");
        }
        var5_5 = 63;
        var6_6 = 0;
        var7_7 = var1_1 + var4_4;
        var8_8 = var1_1;
        while (var8_8 < var7_7) {
            var9_9 = var0[var8_8];
            if (var9_9 > var6_6) {
                var6_6 = var9_9;
            }
            if ((var9_9 & 1) != 0 && var9_9 < var5_5) {
                var5_5 = var9_9;
            }
            ++var8_8;
        }
        var9_9 = var3_3 - var1_1;
        while (var6_6 >= var5_5) {
            var10_10 = var1_1;
            block2: while (true) {
                if (var10_10 < var7_7 && var0[var10_10] < var6_6) {
                    ++var10_10;
                    continue;
                }
                if ((var11_11 = var10_10++) != var7_7) ** GOTO lbl29
                break;
lbl-1000:
                // 1 sources

                {
                    ++var10_10;
lbl29:
                    // 2 sources

                    ** while (var10_10 < var7_7 && var0[var10_10] >= var6_6)
                }
lbl30:
                // 1 sources

                var12_12 = var10_10 - 1;
                var11_11 += var9_9;
                var12_12 += var9_9;
                while (true) {
                    if (var11_11 < var12_12) ** break;
                    continue block2;
                    var13_13 = var2_2[var11_11];
                    var2_2[var11_11] = var2_2[var12_12];
                    var2_2[var12_12] = var13_13;
                    ++var11_11;
                    --var12_12;
                }
                break;
            }
            var6_6 = (byte)(var6_6 - 1);
        }
    }

    private static native int nativeGetDirectionCode(char var0);

    private static synchronized native void nativeBidiChars(Bidi var0, char[] var1, int var2, byte[] var3, int var4, int var5, int var6);

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[dir: " + this.dir);
        stringBuffer.append(" baselevel: " + this.baselevel);
        stringBuffer.append(" length: " + this.length);
        if (this.runs == null) {
            stringBuffer.append(" runs: null");
        } else {
            stringBuffer.append(" runs: [");
            n = 0;
            while (n < this.runs.length) {
                if (n != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.runs[n]);
                stringBuffer.append('/');
                stringBuffer.append(this.runs[n + 1]);
                n += 2;
            }
            stringBuffer.append(']');
        }
        if (this.cws == null) {
            stringBuffer.append(" cws: null");
        } else {
            stringBuffer.append(" cws: [");
            n = 0;
            while (n < this.cws.length) {
                if (n != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toHexString(this.cws[n]));
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        AccessController.doPrivileged(new LoadLibraryAction("fontmanager"));
    }
}

