/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.oldformat;

import com.ibm.jvm.oldformat.MessageFile;
import com.ibm.jvm.oldformat.TraceBufferHeader;
import com.ibm.jvm.oldformat.TraceFormat;
import com.ibm.jvm.oldformat.Util;
import com.ibm.jvm.oldformat.VariableSection;
import java.io.BufferedWriter;
import java.io.IOException;

public final class TraceFileHeader {
    protected static final int LENGTH_OFFSET = 4;
    protected static final int VERSIONINFO_OFFSET = 8;
    protected static final int MODIFICATION_OFFSET = 12;
    protected static final int BUFFERSIZE_OFFSET = 16;
    private int length;
    private long bufferSize;
    private VariableSection[] sections;

    protected TraceFileHeader(byte[] byArray) {
        this.length = byArray.length;
        TraceFormat.versionInfo = Util.constructUnsignedInt(byArray, 8);
        TraceFormat.modificationInfo = Util.constructUnsignedInt(byArray, 12);
        TraceFormat.verMod = (float)TraceFormat.versionInfo + (float)TraceFormat.modificationInfo / 10.0f;
        this.bufferSize = Util.constructUnsignedInt(byArray, 16);
        if (TraceFormat.verMod != MessageFile.verMod) {
            System.out.println("TraceFormat.dat (Version " + MessageFile.verMod + ") does not match this trace file (Version " + TraceFormat.verMod + ")");
        }
        if ((double)TraceFormat.verMod >= 1.1) {
            TraceBufferHeader.WRITE_PLATFORM_OFFSET = 16;
            TraceBufferHeader.WRITE_SYSTEM_OFFSET = 24;
            TraceBufferHeader.THREADID_OFFSET = 32;
            TraceBufferHeader.THREADNAME_OFFSET = 40;
            TraceBufferHeader.NEXTENTRY_OFFSET = 68;
            TraceBufferHeader.HEADER_LENGTH = 72;
            TraceFormat.Chars[0] = "-";
            TraceFormat.Chars[1] = "*";
            TraceFormat.Chars[2] = ">";
            TraceFormat.Chars[3] = ">";
            TraceFormat.Chars[4] = "<";
            TraceFormat.Chars[5] = "<";
            TraceFormat.EVENT_TYPE = 0;
            TraceFormat.EXCEPTION_TYPE = 1;
            TraceFormat.ENTRY_TYPE = (byte)2;
            TraceFormat.EXIT_TYPE = (byte)4;
            TraceFormat.MEM_TYPE = (byte)6;
            TraceFormat.DEBUG_TYPE = (byte)8;
            TraceFormat.PERF_TYPE = (byte)10;
            TraceFormat.MAX_TYPES = (byte)12;
            TraceFormat.types[0] = "Event     ";
            TraceFormat.types[1] = "Exception ";
            TraceFormat.types[2] = "Entry     ";
            TraceFormat.types[3] = "Entry     ";
            TraceFormat.types[4] = "Exit      ";
            TraceFormat.types[5] = "Exit      ";
            TraceFormat.types[6] = "Mem       ";
            TraceFormat.types[7] = "Mem       ";
            TraceFormat.types[8] = "Debug     ";
            TraceFormat.types[9] = "Debug     ";
            TraceFormat.types[10] = "Perf      ";
            TraceFormat.types[11] = "Perf      ";
        }
        Util.Debug.println("TraceFileHeader: length: " + this.length);
        Util.Debug.println("TraceFileHeader: versionInfo: " + TraceFormat.verMod);
        Util.Debug.println("TraceFileHeader: bufferSize: " + this.bufferSize);
        this.sections = new VariableSection[5];
        int n = 0;
        while (n < this.sections.length) {
            int n2 = (int)Util.constructUnsignedInt(byArray, VariableSection.OFFSETS[n]);
            if (n2 != 0) {
                this.sections[n] = VariableSection.newSection(n, byArray, n2);
                this.sections[n].process();
            }
            ++n;
        }
    }

    protected void summarize(BufferedWriter bufferedWriter) throws IOException {
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n] != null) {
                this.sections[n].summary(bufferedWriter);
            }
            ++n;
        }
    }

    protected int getLength() {
        return this.length;
    }

    protected long getBufferSize() {
        return this.bufferSize;
    }
}

