/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ActiveSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long active_offset;
    private long active_end;
    private TraceFile traceFile;

    public ActiveSection(TraceFile traceFile, int n) throws IOException {
        this.traceFile = traceFile;
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.active_offset = traceFile.getFilePointer();
        this.active_end = n + this.length;
        Util.Debug.println("ActiveSection: eyecatcher:         " + this.eyecatcher_string);
        Util.Debug.println("ActiveSection: length:             " + this.length);
        Util.Debug.println("ActiveSection: version:            " + this.version);
        Util.Debug.println("ActiveSection: modification:       " + this.modification);
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        this.traceFile.seek(this.active_offset);
        byte[] byArray = new byte[(int)(this.active_end - this.active_offset)];
        Util.Debug.println("ActiveSection: active_offset:        " + this.active_offset);
        Util.Debug.println("ActiveSection: active_end:           " + this.active_end);
        bufferedWriter.write("Activation Info :");
        bufferedWriter.newLine();
        int n = 0;
        this.traceFile.read(byArray);
        n = 0;
        while (n < byArray.length) {
            StringBuffer stringBuffer = new StringBuffer();
            while (byArray[n] != 0) {
                stringBuffer.append((char)byArray[n]);
                ++n;
            }
            if (stringBuffer.length() == 0) break;
            bufferedWriter.write("        ");
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
            ++n;
        }
        bufferedWriter.newLine();
    }
}

