/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.io.RandomAccessStream;
import com.ibm.jvm.svcdump.Address;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.MemRange;
import com.ibm.jvm.svcdump.Page;
import com.ibm.jvm.svcdump.Process;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.svcdump.TraceEntry;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Table;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public final class AddressSpace
extends DvAddressSpace
implements Serializable,
RandomAccessStream {
    static int ascbasxb;
    static AddressSpace root;
    IntegerArray addresses = new IntegerArray();
    IntegerArray blocks = new IntegerArray();
    SoftReference[] blockPointers;
    int id;
    Dump dump;
    Hashtable traceTable = new Hashtable();
    IntHashtable strings = new IntHashtable();
    Hashtable functionOffsets = new Hashtable();
    Function[] traceFunctions;
    Tcb[] tcbs;
    Tcb lastTcb;
    HashMap tcbMap = new HashMap();
    private Jvm[] jvms;
    boolean checkedJvms;
    int currentOffset;
    int firsttcb = 0;
    int lastAddress;
    BitSet pages = new BitSet();
    MemRange[] memRanges;
    Process[] processes;
    int cacheMisses;
    ArrayList traceEntries = new ArrayList();
    int jvmRasAddress;
    int[] lastBlock;
    int lastBlockAddress = -1;
    FunctionOffset unknownOffset = new FunctionOffset("unknown function", 0, 0);

    public DvMemRanges[] getMemRanges() {
        return this.memRanges;
    }

    public DvProcess[] getProcesses() {
        if (this.processes == null) {
            this.processes = new Process[1];
            this.processes[0] = new Process(this);
        }
        return this.processes;
    }

    public DvProcess getCurrentProcess() {
        AddressSpace addressSpace = (AddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        return new Process(addressSpace);
    }

    public DvAddress createAddress(long l) {
        Address address = new Address((int)l);
        return address;
    }

    public long readNumeric(DvAddress dvAddress, int n) throws DvAddressException {
        long l = 0L;
        switch (n) {
            case 1: {
                l = this.readByte(dvAddress);
                break;
            }
            case 2: {
                l = this.readShort(dvAddress);
                break;
            }
            case 4: {
                l = this.readInt(dvAddress);
                break;
            }
            case 8: {
                l = this.readLong(dvAddress);
                break;
            }
            default: {
                throw new DvAddressException("Illegal size of numeric item - " + n);
            }
        }
        return l;
    }

    public byte[] readBytes(DvAddress dvAddress, long l) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            try {
                byArray[n2] = this.readByte(n + n2);
            }
            catch (IOException iOException) {
                if (n2 == 0) {
                    throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                break;
            }
            ++n2;
        }
        return byArray;
    }

    public byte readByte(DvAddress dvAddress) throws DvAddressException {
        byte by;
        int n = (int)dvAddress.getAddressAsLong();
        try {
            by = this.readByte(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
        return by;
    }

    public short readShort(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            return this.readShort(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public int readInt(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            return this.readInt(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public long readLong(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            long l = this.readInt(n);
            long l2 = this.readInt(n + 4);
            return l << 32 | l2;
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public String id() {
        return Integer.toHexString(this.id);
    }

    public boolean isValid(DvAddress dvAddress) {
        long l = dvAddress.getAddressAsLong();
        return this.isValidAddress((int)l);
    }

    public DvAddress readPointer(DvAddress dvAddress) throws DvAddressException {
        int n;
        int n2 = (int)dvAddress.getAddressAsLong();
        try {
            n = this.readInt(n2);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n2));
        }
        Address address = new Address(n);
        return address;
    }

    public Jvm addJvm(int n, boolean bl) throws Exception {
        if (Dump.debug) {
            System.out.println("add jvm " + AddressSpace.hex(n));
        }
        int n2 = 0;
        while (this.jvms != null && n2 < this.jvms.length) {
            if (this.jvms[n2].jvmp == n) {
                return this.jvms[n2];
            }
            ++n2;
        }
        Jvm jvm = new Jvm(this, n, bl);
        this.addJvm(jvm);
        return jvm;
    }

    void addJvm(Jvm jvm) {
        if (this.jvms == null) {
            this.jvms = new Jvm[0];
        }
        Jvm[] jvmArray = new Jvm[this.jvms.length + 1];
        System.arraycopy(this.jvms, 0, jvmArray, 0, this.jvms.length);
        this.jvms = jvmArray;
        this.jvms[this.jvms.length - 1] = jvm;
    }

    public Jvm[] jvms() {
        if (this.checkedJvms) {
            return this.jvms;
        }
        this.checkedJvms = true;
        this.tcbs();
        if (this.jvms != null) {
            Jvm[] jvmArray = this.jvms;
            this.jvms = null;
            int n = 0;
            while (n < jvmArray.length) {
                block6: {
                    try {
                        Jvm jvm = jvmArray[n];
                        if (Dump.debug) {
                            System.out.println("about to init jvm " + jvm);
                        }
                        jvm.init();
                        this.addJvm(jvm);
                    }
                    catch (Throwable throwable) {
                        if (!Dump.debug) break block6;
                        System.out.println("failed to init jvm: " + throwable);
                        throwable.printStackTrace(System.out);
                    }
                }
                ++n;
            }
        }
        return this.jvms;
    }

    public String getString(int n, int n2) throws Exception {
        String string = (String)this.strings.get(n);
        if (string == null) {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = (byte)this.readUnsignedByte(n + n3);
                ++n3;
            }
            string = Dump.getEbcdicString(byArray);
            this.strings.put(n, (Object)string);
        }
        return string;
    }

    public boolean isJava() {
        if (this.jvmRasAddress != 0) {
            return true;
        }
        this.tcbs();
        return this.jvms() != null;
    }

    public void mapTid(int n, Tcb tcb) {
        this.tcbMap.put(new Integer(n), tcb);
    }

    public int zeroBlocks() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.addresses.size()) {
            if (this.addresses.get(n2) != 0) break;
            ++n;
            ++n2;
        }
        return n;
    }

    static long milli(long l) {
        l >>>= 12;
        l /= 1000L;
        long l2 = 613608L;
        l2 *= 3600L;
        return l -= (l2 *= 1000L);
    }

    public static Date mvsClockToDate(long l) {
        return new Date(AddressSpace.milli(l));
    }

    public void printFullTrace(Document document) {
        if (this.traceEntries.size() == 0) {
            return;
        }
        TraceEntry[] traceEntryArray = this.traceEntries.toArray(new TraceEntry[0]);
        Arrays.sort(traceEntryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                TraceEntry traceEntry = (TraceEntry)object;
                TraceEntry traceEntry2 = (TraceEntry)object2;
                if (traceEntry.tod > traceEntry2.tod) {
                    return 1;
                }
                if (traceEntry.tod < traceEntry2.tod) {
                    return -1;
                }
                return 0;
            }
        });
        TraceEntry traceEntry = traceEntryArray[0];
        Date date = new Date(AddressSpace.milli(traceEntry.tod));
        document.printHeader("Trace for asid " + this.hexId() + " started at " + date);
        document.println("");
        Table table = new Table(new String[]{"Time", "Tcb", "Psw", "Offset", "Type", "Function"});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        int n = 0;
        while (n < traceEntryArray.length) {
            TraceEntry traceEntry2 = traceEntryArray[n];
            Date date2 = new Date(AddressSpace.milli(traceEntry2.tod));
            String string = simpleDateFormat.format(date2);
            table.addRow(new String[]{string, AddressSpace.hex(traceEntry2.tcb), AddressSpace.hex(traceEntry2.psw), AddressSpace.hex(traceEntry2.offset), traceEntry2.typeString, traceEntry2.functionName});
            if (n % 4096 == 0) {
                document.addElement(table);
                table = new Table(new String[]{"", "", "", "", "", ""});
            }
            ++n;
        }
        document.addElement(table);
    }

    public void addTraceEntry(int n, String string, int n2, int n3, long l) {
        Integer n4;
        Integer n5 = (Integer)this.traceTable.get(n4 = new Integer(n2));
        this.traceTable.put(n4, new Integer(n5 == null ? 1 : n5 + 1));
        if (this.lastTcb != null && this.lastTcb.tcbid == n3) {
            this.lastTcb.addTraceEntry(n, n2);
        } else if (this.tcbs() != null && n3 != 0) {
            int n6 = 0;
            while (n6 < this.tcbs.length) {
                this.lastTcb = this.tcbs[n6];
                if (this.lastTcb.tcbid == n3) {
                    this.lastTcb.addTraceEntry(n, n2);
                    break;
                }
                ++n6;
            }
        }
        FunctionOffset functionOffset = this.functionOffset(new Integer(n2));
        this.traceEntries.add(new TraceEntry(functionOffset.name, string, n2, n3, l, functionOffset.offset));
    }

    FunctionOffset functionOffset(Integer n) {
        int n2 = n;
        n2 &= 0x7FFFFFFC;
        FunctionOffset functionOffset = null;
        Integer n3 = null;
        functionOffset = (FunctionOffset)this.functionOffsets.get(n);
        if (functionOffset != null) {
            functionOffset.offset = n2 - functionOffset.ep;
            return functionOffset;
        }
        boolean bl = Dump.debug;
        int n4 = n2 + 4;
        int n5 = 0;
        while (n5 < 4096) {
            block13: {
                block14: {
                    int n6 = this.readInt(n4);
                    if (n6 == 0xC3C5C5 || n6 == 29607365) {
                        n3 = new Integer(n4);
                        functionOffset = (FunctionOffset)this.functionOffsets.get(n3);
                        if (functionOffset != null) {
                            functionOffset.offset = n2 - functionOffset.ep;
                            return functionOffset;
                        }
                        try {
                            String string = Dsa.function(this, n4 - 4);
                            functionOffset = new FunctionOffset(string, n2 - n4, n4);
                        }
                        catch (Exception exception) {
                            if (!bl) break;
                            System.out.println("problem creating function at " + AddressSpace.hex(n4));
                        }
                        break;
                    }
                    if (n6 != 12779717 || this.readInt(n4 + 4) != 12910833) break block13;
                    n3 = new Integer(n4);
                    functionOffset = (FunctionOffset)this.functionOffsets.get(n3);
                    if (functionOffset == null) break block14;
                    functionOffset.offset = n2 - functionOffset.ep;
                    return functionOffset;
                }
                try {
                    String string = this.xplinkFunction(n4 + 16);
                    functionOffset = new FunctionOffset(string, n2 - n4, n4);
                }
                catch (Exception exception) {
                    try {
                        break block13;
                    }
                    catch (Exception exception2) {
                        if (!bl) break;
                        System.out.println("problem reading " + AddressSpace.hex(n4));
                    }
                }
                break;
            }
            n4 -= 4;
            ++n5;
        }
        if (functionOffset == null) {
            functionOffset = Dump.verbose ? new FunctionOffset("unknown function (0x" + AddressSpace.hex(n2) + ")", 0, 0) : this.unknownOffset;
        } else {
            this.functionOffsets.put(n3, functionOffset);
        }
        this.functionOffsets.put(n, functionOffset);
        return functionOffset;
    }

    public Function[] traceFunctions(Hashtable hashtable) {
        Function[] functionArray;
        Hashtable<String, Function> hashtable2 = new Hashtable<String, Function>();
        boolean bl = Dump.debug;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            functionArray = (Function[])enumeration.nextElement();
            String string = this.functionOffset((Integer)functionArray).name;
            if (bl) {
                System.out.println("address " + AddressSpace.hex(functionArray.intValue()) + " maps to " + string);
            }
            int n = (Integer)hashtable.get(functionArray);
            Function function = (Function)hashtable2.get(string);
            if (function == null) {
                function = new Function(string, n);
            } else {
                function.addCount(n);
            }
            hashtable2.put(string, function);
        }
        functionArray = hashtable2.values().toArray(new Function[0]);
        Arrays.sort(functionArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Function function = (Function)object;
                Function function2 = (Function)object2;
                return function2.entryCount - function.entryCount;
            }
        });
        return functionArray;
    }

    public String xplinkFunction(int n) throws Exception {
        String string = "(unknown)";
        int n2 = n - 16;
        long l = this.readLong(n2);
        if (l == 54888466580046065L) {
            int n3 = this.readInt(n2 + 8);
            int n4 = n2 + n3;
            int n5 = n4 + 20;
            int n6 = this.readUnsignedByte(n4 + 10);
            int n7 = this.readUnsignedByte(n4 + 11);
            if ((n6 & 0x80) != 0) {
                n5 += 4;
            }
            if ((n6 & 0x40) != 0) {
                n5 += 4;
            }
            if ((n6 & 0x20) != 0) {
                n5 += 4;
            }
            if ((n6 & 0x10) != 0) {
                n5 += 4;
            }
            if ((n6 & 8) != 0) {
                n5 += 4;
            }
            if ((n6 & 4) != 0) {
                n5 += 4;
            }
            if ((n6 & 2) != 0) {
                n5 += 4;
            }
            if ((n6 & 1) != 0) {
                n5 += 8;
            }
            if ((n7 & 1) == 0) {
                string = "(bad ppa1flags4)";
            } else {
                int n8 = this.readUnsignedShort(n5);
                if (n8 > 500) {
                    string = "(bad xplink length)";
                } else {
                    byte[] byArray = new byte[n8];
                    int n9 = 0;
                    while (n9 < n8) {
                        byArray[n9] = (byte)this.readUnsignedByte(n5 + 2 + n9);
                        ++n9;
                    }
                    string = Dump.getEbcdicString(byArray);
                }
            }
        } else {
            string = "(unknown)";
        }
        return string;
    }

    public Function[] traceFunctions() {
        if (this.traceFunctions == null) {
            this.traceFunctions = this.traceFunctions(this.traceTable);
        }
        return this.traceFunctions;
    }

    public boolean isTrace() {
        int n = this.addresses.get(0);
        try {
            int n2 = this.readInt(n);
            if (Dump.debug) {
                System.out.println("asid " + this + ": block1 = " + AddressSpace.hex(n) + ": eyecatcher = " + AddressSpace.hex(n2));
            }
            return n2 == -471612472;
        }
        catch (Exception exception) {
            block3: {
                if (!Dump.debug) break block3;
                System.out.println("asid " + this + ": problem reading " + AddressSpace.hex(n) + ": " + exception);
            }
            return false;
        }
    }

    AddressSpace(Dump dump, int n) {
        this.dump = dump;
        this.id = n;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public String hexId() {
        return Integer.toHexString(this.id);
    }

    public String toString() {
        return this.hexId();
    }

    public boolean validTCB(int n, boolean bl) {
        try {
            int n2 = this.readInt(n + 256);
            if (n2 == -473710016) {
                return true;
            }
            if (!bl && Dump.debug) {
                System.out.println("bad eyecatcher: " + AddressSpace.hex(n2));
            }
            return false;
        }
        catch (Exception exception) {
            if (!bl && Dump.debug) {
                System.out.println("could not read " + AddressSpace.hex(n + 256));
            }
            return false;
        }
    }

    public int nextTcb(int n) throws Exception {
        return this.readInt(n + 116);
    }

    public int prevTcb(int n) throws Exception {
        return this.readInt(n + 220);
    }

    public int validTCBs() {
        int n = 0;
        int n2 = 0;
        try {
            this.firsttcb = this.readInt(ascbasxb + 4);
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": could not read first tcb at " + AddressSpace.hex(ascbasxb + 4));
            }
            return 0;
        }
        try {
            n2 = this.readInt(ascbasxb + 8);
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": could not read last tcb at " + AddressSpace.hex(ascbasxb + 8));
            }
            return 0;
        }
        if (this.firsttcb == n2) {
            if (Dump.debug) {
                System.out.println("first and last tcb the same! " + AddressSpace.hex(this.firsttcb));
            }
            try {
                this.firsttcb = root.readInt(ascbasxb + 4);
                n2 = root.readInt(ascbasxb + 8);
            }
            catch (Exception exception) {
                if (Dump.debug) {
                    System.out.println("nice try");
                }
                return 0;
            }
            if (this.firsttcb == n2) {
                if (Dump.debug) {
                    System.out.println("first and last tcb STILL the same! " + AddressSpace.hex(this.firsttcb));
                }
                return 0;
            }
        }
        try {
            int n3 = this.firsttcb;
            while (n3 != 0) {
                if (Dump.debug) {
                    System.out.println("asid " + this.hexId() + ": process tcb at " + AddressSpace.hex(n3));
                }
                if (!this.validTCB(n3, false)) {
                    if (Dump.debug) {
                        System.out.println("asid " + this.hexId() + ": invalid tcb at " + AddressSpace.hex(n3));
                    }
                    return 0;
                }
                ++n;
                if (n3 == n2) break;
                n3 = this.nextTcb(n3);
            }
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": processed all tcbs from " + AddressSpace.hex(this.firsttcb) + " to " + AddressSpace.hex(n2));
            }
            return n;
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": error processing a tcb");
            }
            return 0;
        }
    }

    void lastDitch() {
        try {
            int n = this.readInt(ascbasxb + 4);
            int n2 = (n &= 0xFFF00000) + 0x100000;
            Vector<Tcb> vector = new Vector<Tcb>();
            while (n < n2) {
                if (this.validTCB(n, true)) {
                    vector.add(new Tcb(this, n));
                }
                n += 4;
            }
            this.tcbs = vector.toArray(new Tcb[0]);
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("could not recover tcbs");
            }
            this.tcbs = new Tcb[0];
        }
    }

    void addTcb(Tcb tcb) {
        Tcb[] tcbArray = new Tcb[this.tcbs.length + 1];
        System.arraycopy(this.tcbs, 0, tcbArray, 0, this.tcbs.length);
        tcbArray[this.tcbs.length] = tcb;
        this.tcbs = tcbArray;
        if (Dump.debug) {
            System.out.println("added tcb " + tcb + " new size " + this.tcbs.length);
        }
    }

    public Tcb getTcb(int n) {
        int n2 = 0;
        while (n2 < this.tcbs().length) {
            Tcb tcb = this.tcbs()[n2];
            if (tcb.tcbid == n) {
                return tcb;
            }
            ++n2;
        }
        return null;
    }

    public Tcb[] tcbs() {
        int n;
        if (this.tcbs != null) {
            return this.tcbs;
        }
        int n2 = this.validTCBs();
        if (n2 != 0) {
            try {
                this.tcbs = new Tcb[n2];
                n = this.firsttcb;
                int n3 = 0;
                while (n3 < n2) {
                    this.tcbs[n3] = new Tcb(this, n);
                    if (Dump.debug) {
                        System.out.println("created tcb " + AddressSpace.hex(n) + " at index " + n3);
                    }
                    n = this.nextTcb(n);
                    ++n3;
                }
            }
            catch (Exception exception) {
                if (Dump.debug) {
                    System.out.println("in asid " + this.hexId() + " problem creating tcbs:");
                    exception.printStackTrace(System.out);
                }
                return null;
            }
        } else {
            if (Dump.debug) {
                System.out.println("in asid " + this.hexId() + " corrupt tcb chain...");
            }
            this.lastDitch();
        }
        if (this.tcbs == null) {
            return null;
        }
        n = 0;
        while (n < this.tcbs.length) {
            block23: {
                int n4;
                Tcb tcb = this.tcbs[n];
                if (Dump.debug) {
                    System.out.println("zombie check on tcb: " + tcb);
                }
                if (!tcb.scannedTid && (n4 = tcb.tid()) != 0) {
                    try {
                        if (Dump.debug) {
                            System.out.println("do scan starting at tid " + AddressSpace.hex(n4));
                        }
                        int n5 = this.readInt(n4);
                        while (n5 != 0) {
                            Tcb tcb2 = (Tcb)this.tcbMap.get(new Integer(n5));
                            if (tcb2 == null) {
                                if (Dump.debug) {
                                    System.out.println("adding zombie tid " + AddressSpace.hex(n5) + " from forward chain of " + AddressSpace.hex(n4));
                                }
                                tcb2 = new Tcb(this, 0, n5);
                                this.mapTid(n5, tcb2);
                                if (tcb2.isKnownType()) {
                                    this.addTcb(tcb2);
                                }
                            } else if (tcb2.scannedTid) break;
                            tcb2.scannedTid = true;
                            n5 = this.readInt(n5);
                        }
                    }
                    catch (Exception exception) {
                        if (!Dump.debug) break block23;
                        System.out.println("caught exception: " + exception);
                    }
                }
            }
            ++n;
        }
        return this.tcbs;
    }

    public void add(int n, int n2) {
        if ((n & 0xFFF) != 0) {
            System.out.println("Warning: in asid " + this.hexId() + " address " + AddressSpace.hex(n) + " is not page aligned!");
            return;
        }
        int n3 = n >>> 12;
        if (this.pages.get(n3)) {
            if (Dump.debug) {
                System.out.println("duplicate address " + AddressSpace.hex(n) + " for asid " + this.hexId());
            }
            return;
        }
        this.pages.set(n3);
        this.addresses.add(n);
        this.blocks.add(n2);
    }

    public void sort() {
        int n;
        int n2;
        this.addresses.sort(this.blocks);
        Vector<MemRange> vector = new Vector<MemRange>();
        int n3 = n2 = this.addresses.get(0);
        boolean bl = false;
        int n4 = 1;
        while (n4 < this.addresses.size()) {
            n = this.addresses.get(n4);
            if (n != n3 + 4096) {
                int n5 = n3 + 4096 - n2;
                MemRange memRange = new MemRange(n2, n5);
                vector.addElement(memRange);
                n2 = n;
                bl = false;
            } else {
                bl = true;
            }
            n3 = n;
            ++n4;
        }
        if (bl) {
            n = n3 + 4096 - n2;
            MemRange memRange = new MemRange(n2, n);
            vector.addElement(memRange);
        }
        this.memRanges = vector.toArray(new MemRange[0]);
    }

    public final void seek(long l) throws IOException {
        this.currentOffset = (int)l;
    }

    public int search(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.memRanges.length) {
            block12: {
                int n4;
                int n5;
                block11: {
                    MemRange memRange = this.memRanges[n3];
                    n5 = (int)memRange.addressStart.getAddressAsLong();
                    n4 = n5 + memRange.length;
                    if (bl) break block11;
                    if (n == 0) {
                        n = n5;
                    }
                    if (n < n5 || n >= n4) break block12;
                    bl = true;
                    n5 = n;
                    if (n5 == 0) {
                        n5 = 4;
                    }
                }
                try {
                    int n6 = n5;
                    while (n6 < n4) {
                        if (this.readInt(n6) == n2) {
                            return n6;
                        }
                        n6 += 4;
                    }
                }
                catch (Exception exception) {
                    throw new Error("Unexpected exception: " + exception);
                }
            }
            ++n3;
        }
        if (!bl && n != 0) {
            throw new Error("Could not find offset " + AddressSpace.hex(n) + " in asid " + this);
        }
        return -1;
    }

    int[] getBlock(int n) throws IOException {
        int[] nArray;
        int n2 = n & 0x7FFFF000;
        if (n2 == this.lastBlockAddress) {
            return this.lastBlock;
        }
        if (this.blockPointers == null || this.blockPointers[n2 >> 12] == null || (nArray = (int[])this.blockPointers[n2 >> 12].get()) == null) {
            int n3 = this.addresses.indexOf(n2);
            if (n3 == -1) {
                throw new IOException("cannot read " + Integer.toHexString(n));
            }
            int n4 = this.blocks.get(n3);
            this.dump.seek(n4);
            nArray = this.dump.readBlock();
            if (this.blockPointers != null) {
                this.blockPointers[n2 >> 12] = new SoftReference<int[]>(nArray);
            }
            if (this.cacheMisses++ > 10 && this.blockPointers == null) {
                this.blockPointers = new SoftReference[524288];
            }
        }
        this.lastBlock = nArray;
        this.lastBlockAddress = n2;
        return nArray;
    }

    public final int readInt(long l) throws IOException {
        int n = (int)l;
        if (n == 0 || (n & Integer.MIN_VALUE) != 0) {
            throw new IOException("cannot read " + Integer.toHexString(n));
        }
        int[] nArray = null;
        try {
            nArray = this.getBlock(n);
        }
        catch (IOException iOException) {
            if (root == null || this == root) {
                throw iOException;
            }
            return root.readInt(l);
        }
        int n2 = (n & 0xFFF) >> 2;
        int n3 = 0;
        switch (n & 3) {
            case 0: {
                n3 = nArray[n2];
                break;
            }
            case 1: {
                n3 = nArray[n2] << 8 | this.readInt((n & 0xFFFFFFFC) + 4) >>> 24;
                break;
            }
            case 2: {
                n3 = nArray[n2] << 16 | this.readInt((n & 0xFFFFFFFC) + 4) >>> 16;
                break;
            }
            case 3: {
                n3 = nArray[n2] << 24 | this.readInt((n & 0xFFFFFFFC) + 4) >>> 8;
            }
        }
        return n3;
    }

    public final int readInt() throws IOException {
        int n = this.readInt(this.currentOffset);
        this.currentOffset += 4;
        return n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.readInt(this.currentOffset) >>> 24;
        ++this.currentOffset;
        return n;
    }

    public final int readUnsignedByte(long l) throws IOException {
        return this.readInt(l) >>> 24;
    }

    public final byte readByte(long l) throws IOException {
        return (byte)this.readUnsignedByte(l);
    }

    public final byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public int readUnsignedShort(int n) throws IOException {
        return this.readInt(n) >>> 16;
    }

    public short readShort(int n) throws IOException {
        return (short)this.readUnsignedShort(n);
    }

    public final long readLong(int n) throws IOException {
        long l = this.readInt(n);
        long l2 = this.readInt(n + 4);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public String readString(int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.readUnsignedByte(n++)) != 0) {
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    void expect(int n, String string, boolean bl) throws Exception {
        byte[] byArray = bl ? string.getBytes("8859_1") : string.getBytes("Cp500");
        int n2 = Dump.getInt(byArray, 0);
        int n3 = this.readInt(n);
        if (n3 != n2) {
            throw new Exception("did not find expected eyecatcher! found " + AddressSpace.hex(n3) + " expected " + AddressSpace.hex(n2));
        }
    }

    public String readStringObject(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.readInt(n + 8);
        int n3 = this.readInt(n + 12);
        int n4 = this.readInt(n + 16);
        int n5 = 0;
        while (n5 < n4) {
            char c = (char)this.readShort(n2 + 8 + n3 + (n5 << 1));
            if (c != '\n') {
                stringBuffer.append(c);
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.id);
        objectOutputStream.writeInt(this.jvmRasAddress);
        objectOutputStream.writeObject(this.addresses);
        objectOutputStream.writeObject(this.blocks);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = objectInputStream.readInt();
        this.jvmRasAddress = objectInputStream.readInt();
        this.addresses = (IntegerArray)objectInputStream.readObject();
        this.blocks = (IntegerArray)objectInputStream.readObject();
        this.traceTable = new Hashtable();
        this.strings = new IntHashtable();
        this.functionOffsets = new Hashtable();
        this.traceEntries = new ArrayList();
        this.tcbMap = new HashMap();
        this.lastBlockAddress = -1;
        this.unknownOffset = new FunctionOffset("unknown function", 0, 0);
    }

    public int pointerSize() {
        return 4;
    }

    public void setJvmRasAddress(int n) {
        boolean bl = Dump.debug;
        if (bl) {
            System.out.println("set jvm ras address: " + AddressSpace.hex(n));
        }
        this.jvmRasAddress = n;
    }

    public Enumeration getPages() {
        return new Enumeration(){
            int p;

            public boolean hasMoreElements() {
                return this.p < AddressSpace.this.addresses.size();
            }

            public Object nextElement() {
                return new Page(AddressSpace.this, AddressSpace.this.addresses.get(this.p++));
            }
        };
    }

    public boolean isValidAddress(int n) {
        int n2 = this.addresses.indexOf(n &= 0x7FFFF000);
        return n2 != -1;
    }

    public int getId() {
        return this.id;
    }

    public int ascb() throws IOException {
        return this.readInt(548L);
    }

    class FunctionOffset {
        String name;
        int offset;
        int ep;

        FunctionOffset(String string, int n, int n2) {
            this.name = string;
            this.offset = n;
            this.ep = n2;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.name);
            objectOutputStream.writeInt(this.offset);
            objectOutputStream.writeInt(this.ep);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.name = (String)objectInputStream.readObject();
            this.offset = objectInputStream.readInt();
            this.ep = objectInputStream.readInt();
        }
    }
}

