/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.StrongComponentsGraph;
import com.ibm.jvm.util.IntegerArray;

public class PrintComponents
extends PrintBase {
    StrongComponentsGraph sc;
    IntegerArray dagIndexes = new IntegerArray();
    IntegerArray vertexIds = new IntegerArray();

    public static void main(String[] stringArray) {
        PrintComponents printComponents = new PrintComponents();
        printComponents.start(stringArray, "PrintComponents");
    }

    String[] options() {
        return new String[]{"-excludeobject <addr>", "-excludeclass <name>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tExclude object with this address (hex)", "\tExclude all objects of this class (eg java/lang/Object)"};
    }

    protected void parseEnd() {
        super.parseEnd();
        this.sc = this.graph.findStrongComponents();
        this.sc.deleted.set(0);
        int n = 0;
        while (n < this.graph.size) {
            this.dagIndexes.add(this.graph.dagIndex[n]);
            this.vertexIds.add(this.graph.vertexIds.get(n));
            ++n;
        }
        this.dagIndexes.sort(this.vertexIds);
        this.print(this);
        System.out.println("");
        System.out.println("Now print the contents of the strong components referred to by the #n above");
        int n2 = 1;
        while (n2 < this.sc.size) {
            int n3 = this.sc.vertexIds.get(n2);
            int n4 = this.sc.dagSizes.get(n2);
            if (n4 != 1) {
                int n5 = this.dagIndexes.indexOf(n2);
                while (n5 > 0 && this.dagIndexes.get(n5 - 1) == n2) {
                    --n5;
                }
                System.out.println("");
                System.out.println("*** #" + n3 + " ***");
                System.out.println("");
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = this.vertexIds.get(n5 + n6);
                    System.out.println("0x" + Base.hex(n7) + " " + super.getName(n7));
                    ++n6;
                }
            }
            ++n2;
        }
    }

    int reachability(int n) {
        return this.sc.reach[n];
    }

    public void print(PrintClient printClient) {
        int n = 0;
        while (n < this.maxroots()) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (n > 0) {
                System.out.println("");
            }
            System.out.println("*** doing root " + n + " ***");
            System.out.println("");
            this.sc.transitiveClosure();
            this.log("after trans closure");
            int n5 = 0;
            while (n5 < this.sc.vertexIds.size()) {
                n2 = this.sc.reach[n5];
                if (n2 > n4) {
                    n4 = n2;
                    n3 = n5;
                }
                ++n5;
            }
            if (n4 == 0) {
                this.log("no more roots!");
                break;
            }
            n2 = this.sc.vertexIds.get(n3);
            this.log("max reach = " + n4 + " for vertex " + Base.hex(n2) + " " + printClient.getName(n2));
            this.printTree(this.sc, n3);
            this.sc.deleteTree(n3);
            ++n;
        }
    }

    public String getName(int n) {
        if (this.sc == null) {
            return super.getName(n);
        }
        int n2 = this.sc.idToIndex(n);
        int n3 = this.sc.dagSizes.get(n2);
        if (n3 == 1) {
            n = this.vertexIds.get(this.dagIndexes.indexOf(n2));
            return "0x" + Base.hex(n) + " " + super.getName(n);
        }
        return "#" + n + " " + n3;
    }
}

