/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.CompareVisitor;
import com.ibm.jvm.findroots.Heapdump;
import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.VertexClass;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;

public class Condense
extends PrintBase {
    Hashtable classTable = new Hashtable();
    VertexClass[] classes;
    SimpleGraph inverse = new SimpleGraph();
    String outputFilename;

    public static void main(String[] stringArray) {
        Condense condense = new Condense();
        Base.verbose = true;
        condense.start(stringArray, "Condense");
    }

    String[] options() {
        return new String[]{"-o <filename>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tSpecify filename for the new .phd file"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-o".equals(string)) {
            this.outputFilename = string2;
            return true;
        }
        return super.parseOption(string, string2);
    }

    void printInfo() {
        this.log("about to parse file");
    }

    protected void parseStart() {
        if (this.outputFilename == null) {
            System.err.println("you must supply the -o option");
            this.usage();
        }
    }

    protected void parseEnd() {
        int n;
        int n2;
        super.parseEnd();
        this.log("finished parsing");
        this.inverse = this.graph.inverse(this.inverse);
        this.log("done inverse");
        BitSet bitSet = new BitSet();
        Enumeration enumeration = this.classTable.elements();
        while (enumeration.hasMoreElements()) {
            VertexClass vertexClass = (VertexClass)enumeration.nextElement();
            if (vertexClass.type != 1) continue;
            this.log("found class " + vertexClass.name + " with " + vertexClass.ids.size() + " objects");
            BitSet bitSet2 = new BitSet();
            n2 = 0;
            while (n2 < vertexClass.ids.size()) {
                if (!bitSet2.get(n2)) {
                    n = vertexClass.ids.get(n2);
                    int n3 = n2 + 1;
                    while (n3 < vertexClass.ids.size()) {
                        if (!bitSet2.get(n3)) {
                            int n4 = vertexClass.ids.get(n3);
                            Base.Assert(n != n4);
                            if (this.compare(n, n4)) {
                                bitSet2.set(n3);
                                int n5 = this.graph.getSize(n);
                                int n6 = this.graph.getSize(n4);
                                this.graph.setSize(n, n5 + n6);
                                this.log("found match between " + Base.hex(n) + " and " + Base.hex(n4) + " adding " + n6 + " gives " + (n5 + n6));
                                bitSet.set(this.ids.indexOf(n4));
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        this.log("create new .phd file");
        try {
            this.dump = new Heapdump(this.outputFilename, true);
        }
        catch (Exception exception) {
            throw new Error("uh oh");
        }
        int n7 = 0;
        while (n7 < this.strings.size()) {
            this.dump.stringDump(this.getString(n7));
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.ids.size()) {
            if (!bitSet.get(n8)) {
                n2 = this.ids.get(n8);
                n = this.indexes.get(n8);
                switch (this.type(n8)) {
                    case 1: {
                        this.dump.objectDump(n2, n, 0, this.graph.getSize(n2), this.graph.getReferences(n2));
                        break;
                    }
                    case 2: {
                        this.dump.classDump(n2, n, 0, this.graph.getSize(n2), this.graph.getReferences(n2));
                        break;
                    }
                    case 3: {
                        this.dump.primitiveArrayDump(n2, n, 0, this.graph.getSize(n2));
                        break;
                    }
                    case 4: {
                        this.dump.objectArrayDump(n2, n, 0, this.graph.getSize(n2), this.graph.getReferences(n2));
                        break;
                    }
                    default: {
                        Base.Assert(false);
                    }
                }
            }
            ++n8;
        }
        this.dump.close();
        this.log("finished!");
    }

    VertexClass getVertexClass(int n) {
        int n2 = this.ids.indexOf(n);
        Base.Assert(n2 != -1);
        VertexClass vertexClass = this.classes[n2];
        Base.Assert(vertexClass != null);
        return vertexClass;
    }

    boolean compare(int n, int n2) {
        CompareVisitor compareVisitor = new CompareVisitor(){

            public boolean continueSearch(int n, int n2) {
                return n != n2;
            }

            public boolean compare(int n, int n2) {
                int n3 = Condense.this.graph.vertexIds.get(n);
                int n4 = Condense.this.graph.vertexIds.get(n2);
                return Condense.this.getVertexClass(n3) == Condense.this.getVertexClass(n4);
            }
        };
        boolean bl = this.graph.dfsCompare(compareVisitor, n, n2);
        boolean bl2 = this.inverse.dfsCompare(compareVisitor, n, n2);
        return bl && bl2;
    }
}

