/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.FreeList;
import com.ibm.jvm.dump.format.HeapUtil;
import com.ibm.jvm.dump.format.SubPool;
import com.ibm.jvm.dump.plugins.BufferedOutputStrategy;
import com.ibm.jvm.dump.plugins.ChunkWalker;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import com.ibm.jvm.dump.plugins.HeapVisitor;
import com.ibm.jvm.dump.plugins.IndentingOutputStrategy;
import com.ibm.jvm.dump.plugins.ListChunkVisitor;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import com.ibm.jvm.dump.plugins.STGlobalData;
import com.ibm.jvm.dump.plugins.SimpleOutputStrategy;
import com.ibm.jvm.dump.plugins.SummariseChunkVisitor;
import com.ibm.jvm.dump.plugins.WhatIsChunkVisitor;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvStorageCommands
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvStorageCommands";
    private static String[] commandsSupported = new String[]{"STORAGE,GC,freeList,free,doFreeList,Y,N", "STORAGE,GC,pinnedFreeList,pfree,doPinnedFreeList,Y,N", "STORAGE,GC,information,info,information,Y,N", "STORAGE,GC,gcHelpers,h,doGcHelpers,Y,N", "STORAGE,GC,CPUs,c,doCPUs,Y,N", "STORAGE,GC,MarkStacks,M,doMarkStacks,Y,N", "STORAGE,GC,All,a,doAll,Y,N", "STORAGE,GC,VerifyHeap,VH,doVerifyHeap,Y,Y", "STORAGE,GC,FindObject,FO,doFindObject,Y,Y", "STORAGE,GC,SubPoolInfo,SP,doSubPool,Y,N", "STORAGE,GC,ItemGroup,IG,doItemGroup,Y,N", "STORAGE,GC,Help,?,doGCHelp,N,N", "Help,?,STORAGE,GC,doGCHelp,N,N"};
    private static final int INTSIZE = 4;
    OutputStrategy currentOutputStrategy;
    private static final int INDENTTHISMUCH = 4;

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public String pluginName() {
        return "Storage (or GC) commands Plugin";
    }

    public void reset() {
        DvUtils.writetoTrace("Entry:DvStorageCommands.reset");
        if (this.currentOutputStrategy != null) {
            this.currentOutputStrategy.flush();
        }
        STGlobalData.reset();
        DvUtils.writetoTrace("Exit:1 DvStorageCommands.reset");
    }

    public static Object getGenericHelp() {
        DvUtils.writetoTrace("Entry:DvStorageCommands.getGenericHelp");
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvStorageCommands.properties");
        DvUtils.writetoTrace("Exit:1 DvStorageCommands.getGenericHelp");
        return vector;
    }

    public void doPinnedFreeList() {
        boolean bl = false;
        if (this.paramString == null) {
            bl = false;
        } else if (this.paramString.equalsIgnoreCase("-verbose") || this.paramString.equalsIgnoreCase("-v")) {
            bl = true;
        }
        this.showPinnedFreeList(bl);
    }

    private void showPinnedFreeList(boolean bl) {
        DvUtils.writetoTrace("Entry:DvStorageCommands.pinnedFreeList");
        this.currentOutputStrategy = new BufferedOutputStrategy(this.cpr);
        if (STGlobalData.getSTGlobalData().subPoolsActive()) {
            this.currentOutputStrategy.output("SubPools are available and enabled in this dump, so there will be no pinned freelist - please use SubPool operations instead");
            this.returnControl();
            return;
        }
        this.currentOutputStrategy.output("Going to try and print out all the start, end points and the size of ");
        this.currentOutputStrategy.output("all the items on the pinnedFreeList ");
        this.currentOutputStrategy.output("");
        try {
            FreeList freeList = new FreeList(2);
            ChunkWalker chunkWalker = new ChunkWalker(freeList);
            this.currentOutputStrategy.output("");
            chunkWalker.doWalk(new ListChunkVisitor(bl, freeList, this.currentOutputStrategy));
            if (!chunkWalker.lastElementSeen()) {
                this.currentOutputStrategy.output("We have not come across the pointer to the Pinned Freelist Tail while traversing along the freelist");
                this.currentOutputStrategy.output("This could be a sign of a problem.");
                this.currentOutputStrategy.output("pinnedFreeTail 0x" + Long.toHexString(chunkWalker.getFreeTail()) + " Hint \"for 0x" + Long.toHexString(chunkWalker.getFreeTail()) + " as chunk\"");
            }
        }
        catch (NullPointerException nullPointerException) {
            this.currentOutputStrategy.output("!!This Dump does not have a pinned free list");
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:1 DvStorageCommands.freelist");
    }

    public void doFreeList() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        boolean bl = false;
        int n = 60;
        int n2 = 6;
        if (null != this.paramString) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                    bl = true;
                    continue;
                }
                if (string.length() > 13 && string.substring(0, 13).equalsIgnoreCase("-largechunks=")) {
                    n2 = Integer.parseInt(string.substring(13));
                    continue;
                }
                if (string.length() > 4 && string.substring(0, 4).equalsIgnoreCase("-lc=")) {
                    n2 = Integer.parseInt(string.substring(4));
                    continue;
                }
                if (string.length() > 10 && string.substring(0, 10).equalsIgnoreCase("-segments=")) {
                    n = Integer.parseInt(string.substring(10));
                    continue;
                }
                if (string.length() <= 3 || !string.substring(0, 3).equalsIgnoreCase("-s=")) continue;
                n = Integer.parseInt(string.substring(3));
            }
        }
        this.currentOutputStrategy.output("gc free(" + n + "," + n2 + ")" + (bl ? " verbose" : ""));
        this.showFreeList(bl, n, n2);
    }

    private void showFreeList(boolean bl, int n, int n2) {
        if (STGlobalData.getSTGlobalData().subPoolsActive()) {
            this.currentOutputStrategy.output("SubPools are available and enabled - please use SubPool operations instead");
            this.returnControl();
            return;
        }
        DvUtils.writetoTrace("Entry:DvStorageCommands.freelist");
        FreeList freeList = new FreeList(1);
        SummariseChunkVisitor summariseChunkVisitor = new SummariseChunkVisitor(bl, freeList, n, n2, this.currentOutputStrategy);
        ChunkWalker chunkWalker = new ChunkWalker(freeList);
        chunkWalker.doWalk(summariseChunkVisitor);
        this.currentOutputStrategy.output("");
        summariseChunkVisitor.report(freeList);
        this.returnControl();
        DvUtils.writetoTrace("Exit:1 DvStorageCommands.freelist");
    }

    public void information() {
        DvUtils.writetoTrace("Entry:DvStorageCommands.information");
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        this.currentOutputStrategy.output("General information on gc");
        STGlobalData sTGlobalData = STGlobalData.getSTGlobalData();
        long l = sTGlobalData.getAddressItemAsLong("real_heapbase");
        long l2 = sTGlobalData.getAddressItemAsLong("real_heaptop");
        long l3 = sTGlobalData.getAddressItemAsLong("MH_heapbase");
        long l4 = sTGlobalData.getAddressItemAsLong("MH_heaplimit");
        long l5 = sTGlobalData.getAddressItemAsLong("TH_heapbase");
        long l6 = sTGlobalData.getAddressItemAsLong("TH_heaplimit");
        int n = sTGlobalData.getIntItem("gcctr");
        long l7 = sTGlobalData.getIntItem("last_compactgc");
        long l8 = sTGlobalData.getIntItem("last_icompactgc");
        long l9 = sTGlobalData.getIntItem("last_fullgc");
        long l10 = sTGlobalData.getLongItem("mark_time");
        long l11 = sTGlobalData.getLongItem("sweep_time");
        long l12 = sTGlobalData.getLongItem("compact_time");
        this.currentOutputStrategy.output("");
        this.currentOutputStrategy.output("real heap size       = 0x" + Long.toHexString(l2 - l) + " " + (l2 - l));
        this.currentOutputStrategy.output("Middleware Heap size = 0x" + Long.toHexString(l4 - l3) + " " + (l4 - l3));
        this.currentOutputStrategy.output("Transient Heap size  = 0x" + Long.toHexString(l6 - l5) + " " + (l6 - l5));
        this.currentOutputStrategy.output("");
        this.currentOutputStrategy.output("gcctr                = 0x" + Long.toHexString(n));
        this.currentOutputStrategy.output("last_compactgc       = 0x" + Long.toHexString(l7));
        this.currentOutputStrategy.output("last_icompactgc      = 0x" + Long.toHexString(l8));
        this.currentOutputStrategy.output("last_fullgc          = 0x" + Long.toHexString(l9));
        this.currentOutputStrategy.output("");
        if (l10 != 0L && l11 != 0L && l12 != 0L) {
            this.currentOutputStrategy.output("VerboseGC on");
        } else {
            this.currentOutputStrategy.output("VerboseGC off");
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:1 DvStorageCommands.information");
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        BufferedOutputStrategy bufferedOutputStrategy = new BufferedOutputStrategy(this.cpr);
        DvUtils.writetoTrace("Entry:DvStorageCommands.whatIs(DvAddress, String, DvDump)");
        STGlobalData sTGlobalData = STGlobalData.getSTGlobalData();
        if (DvUtils.checkAddressInDump(dvAddress, sTGlobalData.getCurrentAddressSpace())) {
            if (sTGlobalData.subPoolsActive()) {
                this.whatIsSubPool(dvAddress, bufferedOutputStrategy, sTGlobalData);
            } else {
                this.whatIsFreeList(dvAddress, bufferedOutputStrategy);
            }
        } else {
            bufferedOutputStrategy.output("  \"0x" + dvAddress.convertToHex() + "\" address is not in dump");
        }
        DvUtils.writetoTrace("Exit:1 DvStorageCommands.whatIs(DvAddress, String, DvDump)");
        return bufferedOutputStrategy.bufferContents();
    }

    private void whatIsFreeList(DvAddress dvAddress, OutputStrategy outputStrategy) {
        FreeList freeList = new FreeList(1);
        WhatIsChunkVisitor whatIsChunkVisitor = new WhatIsChunkVisitor(freeList, dvAddress, outputStrategy);
        ChunkWalker chunkWalker = new ChunkWalker(freeList);
        chunkWalker.doWalk(whatIsChunkVisitor);
        try {
            freeList = new FreeList(2);
            WhatIsChunkVisitor whatIsChunkVisitor2 = new WhatIsChunkVisitor(freeList, dvAddress, outputStrategy);
            chunkWalker = new ChunkWalker(freeList);
            chunkWalker.doWalk(whatIsChunkVisitor2);
            if (whatIsChunkVisitor.foundIt() && whatIsChunkVisitor2.foundIt()) {
                outputStrategy.output("  !!! Found in both free and pinned free lists!!!");
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void whatIsSubPool(DvAddress dvAddress, OutputStrategy outputStrategy, STGlobalData sTGlobalData) {
        int n = sTGlobalData.getLastSubPoolIndex();
        int n2 = 0;
        while (n2 <= n) {
            SubPool subPool = sTGlobalData.getSubPool(n2);
            ChunkWalker chunkWalker = new ChunkWalker(subPool);
            chunkWalker.doWalk(new WhatIsChunkVisitor(false, subPool, dvAddress, outputStrategy));
            ++n2;
        }
    }

    private void returnControl() {
        this.currentOutputStrategy.flush();
        this.currentOutputStrategy = null;
        this.forcedEnd = true;
    }

    public void doAll() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        this.currentOutputStrategy.output("");
        STGlobalData.getSTGlobalData().getCpuDetails().report(this.currentOutputStrategy);
        this.currentOutputStrategy.output("");
        STGlobalData.getSTGlobalData().getGcHelperDetails().report(this.currentOutputStrategy);
        this.currentOutputStrategy.output("");
        STGlobalData.getSTGlobalData().getMarkStackDetails().report(this.currentOutputStrategy);
        this.currentOutputStrategy.output("");
        this.returnControl();
    }

    public void doCPUs() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        this.currentOutputStrategy.output("");
        STGlobalData.getSTGlobalData().getCpuDetails().report(this.currentOutputStrategy);
        this.returnControl();
    }

    public void doFindObject() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        this.currentOutputStrategy.output("");
        DvAddressSpace dvAddressSpace = STGlobalData.getSTGlobalData().getCurrentAddressSpace();
        long l = STGlobalData.getSTGlobalData().getPtrSize();
        long l2 = 0L;
        boolean bl = false;
        if (null == this.paramString) {
            this.currentOutputStrategy.output("\"GC fo(v)\" without parameters is invalid");
            this.returnControl();
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                bl = true;
                continue;
            }
            try {
                if (string.charAt(0) != '0' || string.charAt(1) != 'x' && string.charAt(1) != 'X') continue;
                l2 = Long.parseLong(string.substring(2), 16);
                if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l2), dvAddressSpace)) {
                    this.currentOutputStrategy.output("Not a valid address");
                    this.returnControl();
                    return;
                }
                if (DvObjectsCommands.checkForKnownObject(l2 - l)) continue;
                this.currentOutputStrategy.output("0x" + Long.toHexString(l2) + " not the start of an object in the heap");
                this.returnControl();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.returnControl();
                throw numberFormatException;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.returnControl();
                throw stringIndexOutOfBoundsException;
            }
        }
        HeapUtil.visitAllObjects(new FindObjectVisitor(l2, bl, this.currentOutputStrategy));
        this.returnControl();
    }

    public void doGcHelpers() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        this.currentOutputStrategy.output("");
        STGlobalData.getSTGlobalData().getGcHelperDetails().report(this.currentOutputStrategy);
        this.returnControl();
    }

    public void doMarkStacks() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        this.currentOutputStrategy.output("");
        STGlobalData.getSTGlobalData().getMarkStackDetails().report(this.currentOutputStrategy);
        this.currentOutputStrategy.output("");
        this.returnControl();
    }

    public void doGCHelp() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        if (this.paramString == null) {
            this.paramString = "STG HP FL SP";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim().toUpperCase();
            Vector vector = DvUtils.getMultiplePropertyValues(string + "Help", "DvStorageCommands.properties");
            this.currentOutputStrategy.output(vector);
        }
        this.returnControl();
    }

    public void doSubPool() {
        boolean bl = false;
        if (this.paramString == null) {
            bl = false;
        } else if (this.paramString.equalsIgnoreCase("-verbose") || this.paramString.equalsIgnoreCase("-v")) {
            bl = true;
        }
        this.currentOutputStrategy = bl ? new IndentingOutputStrategy(new BufferedOutputStrategy(this.cpr)) : new SimpleOutputStrategy(this.cpr);
        STGlobalData sTGlobalData = STGlobalData.getSTGlobalData();
        if (!sTGlobalData.subPoolsActive()) {
            this.currentOutputStrategy.output("Subpools unavailable/disabled - use FreeList operations instead");
            this.returnControl();
            return;
        }
        DvAddressSpace dvAddressSpace = sTGlobalData.getCurrentAddressSpace();
        long l = sTGlobalData.getAddressItemAsLong("lastPool");
        long l2 = sTGlobalData.getAddressItemAsLong("TLHstealPool");
        long l3 = sTGlobalData.getAddressItemAsLong("minTLHstealPool");
        DvAddress dvAddress = dvAddressSpace.createAddress(sTGlobalData.getAddressOf("poolSizes"));
        int n = sTGlobalData.getIntItem("largePoolsize");
        int n2 = sTGlobalData.getLastSubPoolIndex();
        int n3 = 0;
        while (n3 <= n2) {
            SubPool subPool = sTGlobalData.getSubPool(n3);
            StringBuffer stringBuffer = new StringBuffer(100);
            int n4 = subPool.getSubPoolSize();
            stringBuffer.append(subPool.getFreeListName());
            stringBuffer.append(" first Chunk 0x" + DvUtils.rJustifyZ(Long.toHexString(subPool.getFreeList()), 0));
            stringBuffer.append(" Chunks >= " + DvUtils.rJustify(Integer.toString(n4), 6) + " bytes");
            stringBuffer.append(" Hits (smoothed) : " + DvUtils.rJustify(Integer.toString(subPool.getPoolHits()), 6));
            stringBuffer.append(" (" + DvUtils.rJustify(Integer.toString(subPool.getSmoothedPoolHits()), 6) + ")");
            if (n4 == n) {
                stringBuffer.append(" (Large Pool)");
            } else {
                long l4 = subPool.getPoolAnchor();
                if (l4 == l3) {
                    stringBuffer.append(" (minTLH Steal Pool)");
                } else if (l4 == l2) {
                    stringBuffer.append(" (TLH Steal Pool)");
                }
            }
            this.currentOutputStrategy.output(stringBuffer.toString());
            if (bl) {
                ChunkWalker chunkWalker = new ChunkWalker(subPool);
                ((IndentingOutputStrategy)this.currentOutputStrategy).increaseIndentationLevel(4);
                chunkWalker.doWalk(new ListChunkVisitor(false, subPool, this.currentOutputStrategy));
                ((IndentingOutputStrategy)this.currentOutputStrategy).decreaseIndentationLevel(4);
            }
            ++n3;
        }
        this.returnControl();
    }

    public void doVerifyHeap() {
        this.currentOutputStrategy = new SimpleOutputStrategy(this.cpr);
        boolean bl = false;
        if (this.paramString == null) {
            bl = false;
        } else if (this.paramString.equalsIgnoreCase("-verbose") || this.paramString.equalsIgnoreCase("-v")) {
            bl = true;
        }
        this.currentOutputStrategy.output("");
        HeapUtil.visitAllObjects(new VerifyVisitor(bl, this.currentOutputStrategy));
        this.returnControl();
    }

    public void doItemGroup() {
        this.currentOutputStrategy = new IndentingOutputStrategy(new SimpleOutputStrategy(this.cpr));
        STGlobalData sTGlobalData = STGlobalData.getSTGlobalData();
        if (null == this.paramString) {
            this.currentOutputStrategy.output("\"GC ig\" without parameters is invalid");
            this.returnControl();
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.equalsIgnoreCase("-list") || string.equalsIgnoreCase("-l")) {
                this.currentOutputStrategy.output("\nItem Groups available:");
                ((IndentingOutputStrategy)this.currentOutputStrategy).increaseIndentationLevel(4);
                sTGlobalData.listItemGroups(this.currentOutputStrategy);
                ((IndentingOutputStrategy)this.currentOutputStrategy).decreaseIndentationLevel(4);
                continue;
            }
            if (string.equalsIgnoreCase("-all") || string.equalsIgnoreCase("-a")) {
                Iterator iterator = sTGlobalData.itemGroupsIterator();
                while (iterator.hasNext()) {
                    this.showItemGroup(sTGlobalData, (String)iterator.next());
                }
                continue;
            }
            this.showItemGroup(sTGlobalData, string);
        }
        this.returnControl();
    }

    private void showItemGroup(STGlobalData sTGlobalData, String string) {
        this.currentOutputStrategy.output("\nItem group \"" + string + "\"");
        ((IndentingOutputStrategy)this.currentOutputStrategy).increaseIndentationLevel(4);
        sTGlobalData.showItemgroup(string, this.currentOutputStrategy);
        ((IndentingOutputStrategy)this.currentOutputStrategy).decreaseIndentationLevel(4);
    }

    private class VerifyVisitor
    extends HeapVisitor {
        VerifyVisitor(boolean bl, OutputStrategy outputStrategy) {
            super(bl, outputStrategy);
        }

        VerifyVisitor(OutputStrategy outputStrategy) {
            this(false, outputStrategy);
        }

        void processObject(String string, long l, int[] nArray) {
            DvAddressSpace dvAddressSpace = STGlobalData.getSTGlobalData().getCurrentAddressSpace();
            long l2 = STGlobalData.getSTGlobalData().getPtrSize();
            int n = 0;
            while (n < nArray.length) {
                long l3 = 0L;
                DvAddress dvAddress = dvAddressSpace.createAddress(l + 3L * l2 + (long)nArray[n]);
                try {
                    l3 = dvAddressSpace.readPointer(dvAddress).getAddressAsLong();
                }
                catch (DvAddressException dvAddressException) {
                    dvAddressException.printStackTrace();
                }
                if (0L != l3 && !DvObjectsCommands.checkForKnownObject(l3 - l2)) {
                    this.outputStrategy.output(string + " at 0x" + DvUtils.rJustifyZ(Long.toHexString(l + l2), 0) + " contains an invalid Reference - 0x" + DvUtils.rJustifyZ(Long.toHexString(l3), 0) + " in slot " + n + " at address " + Long.toHexString(dvAddress.getAddressAsLong()));
                }
                ++n;
            }
        }

        void processArray(String string, long l) {
            DvAddressSpace dvAddressSpace = STGlobalData.getSTGlobalData().getCurrentAddressSpace();
            long l2 = STGlobalData.getSTGlobalData().getPtrSize();
            int n = 0;
            DvAddress dvAddress = dvAddressSpace.createAddress(l + 2L * l2 - 4L);
            try {
                n = dvAddressSpace.readInt(dvAddress);
                dvAddress.offsetBy(4L + l2);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
            }
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    long l3 = 0L;
                    try {
                        l3 = dvAddressSpace.readPointer(dvAddress).getAddressAsLong();
                        if (l3 != 0L && !DvObjectsCommands.checkForKnownObject(l3 - l2)) {
                            this.outputStrategy.output(string + " at 0x" + DvUtils.rJustifyZ(Long.toHexString(l + l2), 0) + " contains an invalid Reference - 0x" + DvUtils.rJustifyZ(Long.toHexString(l3), 0) + " in slot " + n2);
                        }
                        dvAddress.offsetBy(l2);
                    }
                    catch (DvAddressException dvAddressException) {
                        dvAddressException.printStackTrace();
                    }
                    ++n2;
                }
            }
        }
    }

    private class FindObjectVisitor
    extends HeapVisitor {
        private long objectToFind;

        FindObjectVisitor(long l, OutputStrategy outputStrategy) {
            this(l, false, outputStrategy);
        }

        FindObjectVisitor(long l, boolean bl, OutputStrategy outputStrategy) {
            super(bl, outputStrategy);
            this.objectToFind = l;
        }

        void processObject(String string, long l, int[] nArray) {
            DvAddressSpace dvAddressSpace = STGlobalData.getSTGlobalData().getCurrentAddressSpace();
            long l2 = STGlobalData.getSTGlobalData().getPtrSize();
            StringBuffer stringBuffer = new StringBuffer(40);
            int n = 0;
            while (n < nArray.length) {
                long l3 = 0L;
                DvAddress dvAddress = dvAddressSpace.createAddress(l + l2 + 8L + (long)nArray[n]);
                try {
                    l3 = dvAddressSpace.readPointer(dvAddress).getAddressAsLong();
                }
                catch (DvAddressException dvAddressException) {
                    dvAddressException.printStackTrace();
                }
                if (0L != l3 && l3 == this.objectToFind) {
                    stringBuffer.append(" ");
                    stringBuffer.append(n);
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                this.outputStrategy.output(string + " at 0x" + DvUtils.rJustifyZ(Long.toHexString(l + l2), 0) + " contains a reference(s) to 0x" + DvUtils.rJustifyZ(Long.toHexString(this.objectToFind), 0) + " in reference slot(s) " + stringBuffer);
                this.outputStrategy.output(DvClassCommands.getInstanceValues(l + l2, string, DvConsole.theDump, null) + "\n");
            }
        }

        void processArray(String string, long l) {
            DvAddressSpace dvAddressSpace = STGlobalData.getSTGlobalData().getCurrentAddressSpace();
            long l2 = STGlobalData.getSTGlobalData().getPtrSize();
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(40);
            DvAddress dvAddress = dvAddressSpace.createAddress(l + 4L);
            try {
                n = dvAddressSpace.readInt(dvAddress);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
            }
            DvAddress dvAddress2 = dvAddressSpace.createAddress(l + 8L + l2);
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    long l3 = 0L;
                    try {
                        l3 = dvAddressSpace.readPointer(dvAddress2).getAddressAsLong();
                        if (0L != l3 && l3 == this.objectToFind) {
                            stringBuffer.append(" ");
                            stringBuffer.append(n2);
                        }
                        dvAddress2.offsetBy(l2);
                    }
                    catch (DvAddressException dvAddressException) {
                        dvAddressException.printStackTrace();
                    }
                    ++n2;
                }
            }
            if (stringBuffer.length() > 0) {
                this.outputStrategy.output(string + " at 0x" + DvUtils.rJustifyZ(Long.toHexString(l + l2), 0) + " contains a reference(s) to 0x" + DvUtils.rJustifyZ(Long.toHexString(this.objectToFind), 0) + " in slot(s) " + stringBuffer + "\n");
            }
        }
    }
}

