/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.util.ResourcesMgr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public final class PrivateCredentialPermission
extends Permission {
    private static final long serialVersionUID = 5284372143517237068L;
    private String credentialClass;
    private Set principals;
    private boolean testing = false;

    static String buildTarget(String string, Set set) {
        if (string == null || set == null || set.size() == 0) {
            throw new IllegalArgumentException(ResourcesMgr.getString("invalid null input(s)"));
        }
        String string2 = string;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            string2 = string2 + " " + principal.getClass().getName() + " \"" + principal.getName() + "\"";
        }
        return string2;
    }

    Set getPrincipalSet() {
        return this.principals;
    }

    PrivateCredentialPermission(String string, Set set) {
        super(string);
        this.credentialClass = string;
        this.principals = set;
    }

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        if (!"read".equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException(ResourcesMgr.getString("actions can only be 'read'"));
        }
        this.init(string);
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        if (this.principals == null) {
            return new String[0][0];
        }
        String[][] stringArray = new String[this.principals.size()][2];
        Iterator iterator = this.principals.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            stringArray[n][0] = credOwner.principalClass;
            stringArray[n][1] = credOwner.principalName;
            ++n;
        }
        return stringArray;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!this.impliesCredentialClass(this.credentialClass, privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        return this.impliesPrincipalSet(this.principals, privateCredentialPermission.getPrincipalSet());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        return this.implies(privateCredentialPermission) && privateCredentialPermission.implies(this);
    }

    public int hashCode() {
        return this.getCredentialClass().hashCode();
    }

    public String getActions() {
        return "read";
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void init(String var1_1) {
        this.principals = new HashSet<E>();
        var2_2 = new StringTokenizer(var1_1, " ", true);
        var3_3 = null;
        var4_4 = null;
        if (this.testing) {
            System.out.println("whole name = " + var1_1);
        }
        this.credentialClass = var2_2.nextToken();
        if (this.testing) {
            System.out.println("Credential Class = " + this.credentialClass);
        }
        if (var2_2.hasMoreTokens()) ** GOTO lbl48
        var5_5 = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
        var6_7 = new Object[]{var1_1};
        throw new IllegalArgumentException(var5_5.format(var6_7) + ResourcesMgr.getString("Credential Class not followed by a Principal Class and Name"));
lbl-1000:
        // 1 sources

        {
            var2_2.nextToken();
            var3_3 = var2_2.nextToken();
            if (this.testing) {
                System.out.println("    Principal Class = " + var3_3);
            }
            if (!var2_2.hasMoreTokens()) {
                var5_6 = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
                var6_8 = new Object[]{var1_1};
                throw new IllegalArgumentException(var5_6.format(var6_8) + ResourcesMgr.getString("Principal Class not followed by a Principal Name"));
            }
            var2_2.nextToken();
            var4_4 = var2_2.nextToken();
            if (!var4_4.startsWith("\"")) {
                var5_6 = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
                var6_9 = new Object[]{var1_1};
                throw new IllegalArgumentException(var5_6.format(var6_9) + ResourcesMgr.getString("Principal Name must be surrounded by quotes"));
            }
            if (!var4_4.endsWith("\"")) {
                while (var2_2.hasMoreTokens()) {
                    if ((var4_4 = var4_4 + var2_2.nextToken()).endsWith("\"")) break;
                }
                if (!var4_4.endsWith("\"")) {
                    var5_6 = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
                    var6_10 = new Object[]{var1_1};
                    throw new IllegalArgumentException(var5_6.format(var6_10) + ResourcesMgr.getString("Principal Name missing end quote"));
                }
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + var4_4 + "'");
            }
            var4_4 = var4_4.substring(1, var4_4.length() - 1);
            if (var3_3.equals("*") && !var4_4.equals("*")) {
                throw new IllegalArgumentException(ResourcesMgr.getString("PrivateCredentialPermission Principal Class can not be a wildcard (*) value if Principal Name is not a wildcard (*) value"));
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + var4_4 + "'");
            }
            var5_6 = new CredOwner(var3_3, var4_4);
            this.principals.add(var5_6);
lbl48:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl49:
        // 1 sources

    }

    private boolean impliesCredentialClass(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.testing) {
            System.out.println("credential class comparison: " + string + "/" + string2);
        }
        if (string.equals("*")) {
            return true;
        }
        return string.equals(string2);
    }

    private boolean impliesPrincipalSet(Set set, Set set2) {
        Object object;
        Iterator iterator;
        if (set == null || set2 == null) {
            return false;
        }
        if (this.testing) {
            iterator = set.iterator();
            int n = 0;
            while (n < set.size()) {
                object = (CredOwner)iterator.next();
                System.out.println("this permission set [" + n + "]= " + ((CredOwner)object).toString());
                ++n;
            }
        }
        if (set2.size() == 0) {
            return true;
        }
        if (set.size() == 0) {
            return false;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            object = set2.iterator();
            boolean bl = false;
            while (object.hasNext()) {
                CredOwner credOwner2 = (CredOwner)object.next();
                if (!credOwner.implies(credOwner2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getName().indexOf(" ") == -1 && this.getName().indexOf("\"") == -1) {
            this.credentialClass = this.getName();
            this.principals = new HashSet();
        } else {
            this.init(this.getName());
        }
    }

    static class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        String principalClass;
        String principalName;

        CredOwner(String string, String string2) {
            this.principalClass = string;
            this.principalName = string2;
        }

        public boolean implies(Object object) {
            if (object == null || !(object instanceof CredOwner)) {
                return false;
            }
            CredOwner credOwner = (CredOwner)object;
            return !(!this.principalClass.equals("*") && !this.principalClass.equals(credOwner.principalClass) || !this.principalName.equals("*") && !this.principalName.equals(credOwner.principalName));
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("CredOwner:\n\tPrincipal Class = class\n\tPrincipal Name = name"));
            Object[] objectArray = new Object[]{this.principalClass, this.principalName};
            return messageFormat.format(objectArray);
        }
    }
}

