/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import sun.awt.font.BidiUtils;
import sun.awt.font.Decoration;
import sun.awt.font.TextLineComponent;

public final class GraphicComponent
implements TextLineComponent,
Decoration.Label {
    public static final float GRAPHIC_LEADING = 2.0f;
    private GraphicAttribute graphic;
    private int graphicCount;
    private int[] charsLtoV;
    private byte[] levels;
    private Rectangle2D visualBounds = null;
    private float graphicAdvance;
    private LineMetrics lineMetrics;
    private Decoration decorator;

    public GraphicComponent(GraphicAttribute graphicAttribute, Decoration decoration, int[] nArray, byte[] byArray, int n, int n2) {
        if (n2 <= n) {
            throw new IllegalArgumentException("0 or negative length in GraphicComponent");
        }
        this.graphic = graphicAttribute;
        this.graphicAdvance = graphicAttribute.getAdvance();
        this.lineMetrics = new GraphicLineMetrics();
        this.decorator = decoration;
        this.initLocalOrdering(nArray, byArray, n, n2);
    }

    private GraphicComponent(GraphicComponent graphicComponent, int n, int n2, int n3) {
        this.graphic = graphicComponent.graphic;
        this.graphicAdvance = graphicComponent.graphicAdvance;
        this.decorator = graphicComponent.decorator;
        this.lineMetrics = new GraphicLineMetrics();
        int[] nArray = null;
        byte[] byArray = null;
        if (n3 == 2) {
            nArray = graphicComponent.charsLtoV;
            byArray = graphicComponent.levels;
        } else if (n3 == 0 || n3 == 1) {
            n2 -= n;
            n = 0;
            if (n3 == 1) {
                nArray = new int[n2];
                byArray = new byte[n2];
                int n4 = 0;
                while (n4 < n2) {
                    nArray[n4] = n2 - n4 - 1;
                    byArray[n4] = 1;
                    ++n4;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid direction flag");
        }
        this.initLocalOrdering(nArray, byArray, n, n2);
    }

    private void initLocalOrdering(int[] nArray, byte[] byArray, int n, int n2) {
        this.graphicCount = n2 - n;
        this.charsLtoV = nArray == null || nArray.length == this.graphicCount ? nArray : BidiUtils.createNormalizedMap(nArray, byArray, n, n2);
        if (byArray == null || byArray.length == this.graphicCount) {
            this.levels = byArray;
        } else {
            this.levels = new byte[this.graphicCount];
            System.arraycopy(byArray, n, this.levels, 0, this.graphicCount);
        }
    }

    public Rectangle2D handleGetVisualBounds() {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        float f = (float)rectangle2D.getWidth() + this.graphicAdvance * (float)(this.graphicCount - 1);
        return new Rectangle2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), f, (float)rectangle2D.getHeight());
    }

    public LineMetrics getLineMetrics() {
        return this.lineMetrics;
    }

    public float getItalicAngle() {
        return 0.0f;
    }

    public Rectangle2D getVisualBounds() {
        if (this.visualBounds == null) {
            this.visualBounds = this.decorator.getVisualBounds(this);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.visualBounds);
        return float_;
    }

    public Shape handleGetOutline(float f, float f2) {
        return this.getVisualBounds();
    }

    public Shape getOutline(float f, float f2) {
        return this.decorator.getOutline(this, f, f2);
    }

    public void handleDraw(Graphics2D graphics2D, float f, float f2) {
        int n = 0;
        while (n < this.graphicCount) {
            this.graphic.draw(graphics2D, f, f2);
            f += this.graphicAdvance;
            ++n;
        }
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.decorator.drawTextAndDecorations(this, graphics2D, f, f2);
    }

    public Rectangle2D getCharVisualBounds(int n) {
        return this.decorator.getCharVisualBounds(this, n);
    }

    public int getNumCharacters() {
        return this.graphicCount;
    }

    public float getCharX(int n) {
        int n2 = this.charsLtoV == null ? n : this.charsLtoV[n];
        return this.graphicAdvance * (float)n2;
    }

    public float getCharY(int n) {
        return 0.0f;
    }

    public float getCharAdvance(int n) {
        return this.graphicAdvance;
    }

    public boolean caretAtOffsetIsValid(int n) {
        return true;
    }

    public Rectangle2D handleGetCharVisualBounds(int n) {
        Rectangle2D rectangle2D = this.graphic.getBounds();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(rectangle2D);
        float_.x += this.graphicAdvance * (float)n;
        return float_;
    }

    public int getLineBreakIndex(int n, float f) {
        int n2 = (int)(f / this.graphicAdvance);
        if (n2 > this.graphicCount - n) {
            n2 = this.graphicCount - n;
        }
        return n2;
    }

    public float getAdvanceBetween(int n, int n2) {
        return this.graphicAdvance * (float)(n2 - n);
    }

    public Rectangle2D getLogicalBounds() {
        float f = 0.0f;
        float f2 = -this.lineMetrics.getAscent();
        float f3 = this.graphicAdvance * (float)this.graphicCount;
        float f4 = this.lineMetrics.getDescent() - f2;
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    public TextLineComponent getSubset(int n, int n2, int n3) {
        if (n < 0 || n2 > this.graphicCount || n >= n2) {
            throw new IllegalArgumentException("Invalid range.  start=" + n + "; limit=" + n2);
        }
        if (n == 0 && n2 == this.graphicCount && n3 == 2) {
            return this;
        }
        return new GraphicComponent(this, n, n2, n3);
    }

    public String toString() {
        return "[graphic=" + this.graphic + ":count=" + this.getNumCharacters() + "]";
    }

    public int getNumJustificationInfos() {
        return 0;
    }

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n, int n2, int n3) {
    }

    public TextLineComponent applyJustificationDeltas(float[] fArray, int n, boolean[] blArray) {
        return this;
    }

    private final class GraphicLineMetrics
    extends LineMetrics {
        private GraphicLineMetrics() {
        }

        public int getNumChars() {
            return GraphicComponent.this.graphicCount;
        }

        public float getAscent() {
            return GraphicComponent.this.graphic.getAscent();
        }

        public float getDescent() {
            return GraphicComponent.this.graphic.getDescent();
        }

        public float getLeading() {
            return 2.0f;
        }

        public float getHeight() {
            return this.getAscent() + this.getDescent() + this.getLeading();
        }

        public int getBaselineIndex() {
            return GraphicComponent.this.graphic.getAlignment();
        }

        public float[] getBaselineOffsets() {
            return new float[]{0.0f, -7.0f, -14.0f};
        }

        public float getStrikethroughOffset() {
            return -(this.getAscent() / 2.0f);
        }

        public float getStrikethroughThickness() {
            return this.getAscent() / 12.0f;
        }

        public float getUnderlineOffset() {
            return this.getDescent() / 3.0f;
        }

        public float getUnderlineThickness() {
            return this.getAscent() / 12.0f;
        }
    }
}

