/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$EventDispatchThread == null ? (class$java$awt$EventDispatchThread = EventDispatchThread.class$("java.awt.EventDispatchThread")) : class$java$awt$EventDispatchThread);
    private static final boolean FILTER_MODAL_INPUT = System.getProperty("os.name", "").indexOf("4690") == -1;
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static final int ANY_EVENT = -1;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();
    static /* synthetic */ Class class$java$awt$EventDispatchThread;
    static /* synthetic */ Class class$java$lang$Throwable;

    EventDispatchThread(ThreadGroup threadGroup, String string, EventQueue eventQueue) {
        super(threadGroup, string);
        this.theQueue = eventQueue;
    }

    void stopDispatchingImpl(boolean bl) {
        block3: {
            this.doDispatch = false;
            if (Thread.currentThread() == this) break block3;
            this.theQueue.postEventPrivate(new EmptyEvent());
            if (bl) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stopDispatching() {
        this.stopDispatchingImpl(true);
    }

    public void stopDispatchingLater() {
        this.stopDispatchingImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.pumpEvents(new Conditional(){

                public boolean evaluate() {
                    return true;
                }
            });
        }
        finally {
            EventQueue eventQueue = this.theQueue;
            synchronized (eventQueue) {
                this.theQueue.detachDispatchThread();
                if (this.theQueue.peekEvent() != null || !SunToolkit.isPostEventQueueEmpty()) {
                    this.theQueue.initDispatchThread();
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this);
            }
        }
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEvents(-1, conditional);
    }

    void pumpEventsForHierarchy(Conditional conditional, Component component) {
        this.pumpEventsForHierarchy(-1, conditional, component);
    }

    void pumpEvents(int n, Conditional conditional) {
        this.pumpEventsForHierarchy(n, conditional, null);
    }

    void pumpEventsForHierarchy(int n, Conditional conditional, Component component) {
        while (this.doDispatch && conditional.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForHierarchy(n, component)) continue;
            this.doDispatch = false;
        }
    }

    boolean pumpOneEventForHierarchy(int n, Component component) {
        try {
            AWTEvent aWTEvent;
            boolean bl;
            do {
                Object object;
                int n2;
                aWTEvent = n == -1 ? this.theQueue.getNextEvent() : this.theQueue.getNextEvent(n);
                bl = true;
                if (component != null && FILTER_MODAL_INPUT && ((n2 = aWTEvent.getID()) >= 500 && n2 <= 507 || n2 >= 1001 && n2 <= 1001) && (object = aWTEvent.getSource()) instanceof Component) {
                    Component component2 = (Component)object;
                    if (component instanceof Container) {
                        while (component2 != component && component2 != null) {
                            component2 = component2.getParent();
                        }
                    }
                    if (component2 != component) {
                        bl = false;
                    }
                }
                boolean bl2 = bl = bl && SunDragSourceContextPeer.checkEvent(aWTEvent);
                if (bl) continue;
                aWTEvent.consume();
            } while (!bl);
            this.theQueue.dispatchEvent(aWTEvent);
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            this.processException(runtimeException, component != null);
        }
        catch (Error error) {
            this.processException(error, component != null);
        }
        return true;
    }

    private void processException(Throwable throwable, boolean bl) {
        if (!this.handleException(throwable)) {
            if (bl) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            } else {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
        }
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object obj;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", class$java$lang$Throwable == null ? (class$java$lang$Throwable = EventDispatchThread.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                obj = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(obj, throwable);
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
        }
    }
}

