/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.XMLCharacterProperties;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;

final class CharArrayParsedEntity
extends ParsedEntity {
    private ParsedEntityFactory fEntityFactory;
    private int fEncodedCharLength;

    public CharArrayParsedEntity(ParsedEntityFactory parsedEntityFactory) {
        this.fEntityFactory = parsedEntityFactory;
    }

    public void release() {
        this.fEntityFactory.releaseParsedEntity(this);
    }

    public void getContent(XMLString xMLString) {
        xMLString.setValues(this);
    }

    public void setValues(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        throw new RuntimeException("CharArrayParsedEntity.setValues(byte[] ...)");
    }

    public int decodeInvalidCharacter() {
        int n = this.decodeUTF16Character();
        return n;
    }

    public boolean skipValidCharacter() {
        int n = this.decodeUTF16Character();
        if (XMLCharacterProperties.validChar(n)) {
            this.offset += this.fEncodedCharLength;
            return true;
        }
        return false;
    }

    public boolean skipInitialNameCharacter() {
        int n = this.decodeUTF16Character();
        if (XMLCharacterProperties.initialNameChar(n)) {
            this.offset += this.fEncodedCharLength;
            return true;
        }
        return false;
    }

    public boolean skipNameCharacter() {
        int n = this.decodeUTF16Character();
        if (XMLCharacterProperties.nameChar(n)) {
            this.offset += this.fEncodedCharLength;
            return true;
        }
        return false;
    }

    private int decodeUTF16Character() {
        if (this.offset == this.endOffset) {
            return 0;
        }
        int n = this.chars[this.offset];
        this.fEncodedCharLength = 1;
        if (n >= 55296 && n < 56320) {
            char c;
            if (this.offset + 1 == this.endOffset) {
                CharConversionError.missingSecondHalfOfSurrogatePair();
            }
            if ((c = this.chars[this.offset + 1]) >= '\udc00' && c < '\ue000') {
                n = 65536 + (n - 55296 << 10) + (c - 56320);
                this.fEncodedCharLength = 2;
            }
        }
        return n;
    }
}

