/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PathDasher;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.FillSpans;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class LoopPipe
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        int n5 = sunGraphics2D.transX;
        int n6 = sunGraphics2D.transY;
        sunGraphics2D.loops.drawLineLoop.DrawLine(sunGraphics2D, sunGraphics2D.getSurfaceData(), n + n5, n2 + n6, n3 + n5, n4 + n6);
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.loops.drawRectLoop.DrawRect(sunGraphics2D, sunGraphics2D.getSurfaceData(), n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[]{n};
        sunGraphics2D.loops.drawPolygonsLoop.DrawPolygons(sunGraphics2D, sunGraphics2D.getSurfaceData(), nArray, nArray2, nArray3, 1, sunGraphics2D.transX, sunGraphics2D.transY, false);
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[]{n};
        sunGraphics2D.loops.drawPolygonsLoop.DrawPolygons(sunGraphics2D, sunGraphics2D.getSurfaceData(), nArray, nArray2, nArray3, 1, sunGraphics2D.transX, sunGraphics2D.transY, true);
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.loops.fillRectLoop.FillRect(sunGraphics2D, sunGraphics2D.getSurfaceData(), n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(sunGraphics2D, false);
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompClip());
            shapeSpanIterator.appendPoly(nArray, nArray2, n, sunGraphics2D.transX, sunGraphics2D.transY);
            LoopPipe.fillSpans(sunGraphics2D, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            Polygon polygon = new Polygon();
            AffineTransform affineTransform = sunGraphics2D.transformState > 1 ? sunGraphics2D.transform : null;
            PathIterator pathIterator = shape.getPathIterator(affineTransform, 0.5);
            float[] fArray = new float[2];
            int[] nArray = new int[1];
            SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
            DrawPolygons drawPolygons = sunGraphics2D.loops.drawPolygonsLoop;
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        if (polygon.npoints > 1) {
                            nArray[0] = polygon.npoints;
                            drawPolygons.DrawPolygons(sunGraphics2D, surfaceData, polygon.xpoints, polygon.ypoints, nArray, 1, sunGraphics2D.transX, sunGraphics2D.transY, false);
                        }
                        polygon.reset();
                        polygon.addPoint((int)fArray[0], (int)fArray[1]);
                        break;
                    }
                    case 1: {
                        if (polygon.npoints == 0) {
                            throw new IllegalPathStateException("missing initial moveto in path definition");
                        }
                        polygon.addPoint((int)fArray[0], (int)fArray[1]);
                        break;
                    }
                    case 4: {
                        if (polygon.npoints <= 1) break;
                        nArray[0] = polygon.npoints;
                        drawPolygons.DrawPolygons(sunGraphics2D, surfaceData, polygon.xpoints, polygon.ypoints, nArray, 1, sunGraphics2D.transX, sunGraphics2D.transY, true);
                        int n = polygon.xpoints[0];
                        int n2 = polygon.ypoints[0];
                        polygon.reset();
                        polygon.addPoint(n, n2);
                        break;
                    }
                    default: {
                        throw new IllegalPathStateException("path not flattened");
                    }
                }
                pathIterator.next();
            }
            if (polygon.npoints > 1) {
                nArray[0] = polygon.npoints;
                drawPolygons.DrawPolygons(sunGraphics2D, surfaceData, polygon.xpoints, polygon.ypoints, nArray, 1, sunGraphics2D.transX, sunGraphics2D.transY, false);
            }
            return;
        }
        if (sunGraphics2D.strokeState == 2) {
            this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
            return;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
        try {
            LoopPipe.fillSpans(sunGraphics2D, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShapeSpanIterator getStrokeSpans(SunGraphics2D sunGraphics2D, Shape shape) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(sunGraphics2D, true);
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompClip());
            shapeSpanIterator.setRule(1);
            BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
            AffineTransform affineTransform = sunGraphics2D.transformState > 1 ? sunGraphics2D.transform : null;
            boolean bl = sunGraphics2D.strokeState == 0;
            PathConsumer pathConsumer = DuctusRenderer.createStroker(shapeSpanIterator, basicStroke, bl, affineTransform);
            try {
                affineTransform = sunGraphics2D.transformState == 0 ? null : sunGraphics2D.transform;
                PathIterator pathIterator = shape.getPathIterator(affineTransform);
                try {
                    boolean bl2 = sunGraphics2D.strokeHint != 2;
                    DuctusRenderer.feedConsumer(pathIterator, pathConsumer, bl2, 0.25f);
                }
                catch (PathException pathException) {
                    throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (pathConsumer instanceof PathDasher) {
                    PathConsumer pathConsumer2 = ((PathDasher)pathConsumer).getConsumerReferent();
                    pathConsumer2.dispose();
                }
                pathConsumer.dispose();
                throw throwable;
            }
            if (pathConsumer instanceof PathDasher) {
                PathConsumer pathConsumer3 = ((PathDasher)pathConsumer).getConsumerReferent();
                pathConsumer3.dispose();
            }
            pathConsumer.dispose();
            {
            }
        }
        catch (Throwable throwable) {
            shapeSpanIterator.dispose();
            shapeSpanIterator = null;
            throw new InternalError("Unable to Stroke shape (" + throwable.getMessage() + ")");
        }
        return shapeSpanIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(sunGraphics2D, false);
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompClip());
            AffineTransform affineTransform = sunGraphics2D.transformState == 0 ? null : sunGraphics2D.transform;
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            LoopPipe.fillSpans(sunGraphics2D, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    private static void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        Object object;
        if (sunGraphics2D.clipState == 2) {
            spanIterator = sunGraphics2D.clipRegion.filter(spanIterator);
        } else {
            object = sunGraphics2D.loops.fillSpansLoop;
            if (object != null) {
                ((FillSpans)object).FillSpans(sunGraphics2D, sunGraphics2D.getSurfaceData(), spanIterator);
                return;
            }
        }
        object = new int[4];
        SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
        while (spanIterator.nextSpan((int[])object)) {
            Object object2 = object[0];
            Object object3 = object[1];
            reference var6_6 = object[2] - object2;
            reference var7_7 = object[3] - object3;
            sunGraphics2D.loops.fillRectLoop.FillRect(sunGraphics2D, surfaceData, (int)object2, (int)object3, (int)var6_6, (int)var7_7);
        }
    }
}

