/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.AWTError;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.io.CharToByteConverter;
import sun.io.CharacterEncoding;
import sun.security.action.GetPropertyAction;

public abstract class DataTransferer {
    private static final DebugHelper dbg = DebugHelper.create(DataTransferer.class);
    public static final Class charArrayClass;
    public static final Class byteArrayClass;
    public static final DataFlavor plainTextStringFlavor;
    public static final DataFlavor javaTextEncodingFlavor;
    private static SortedSet standardEncodings;
    private static final Map knownEncodings;
    private static final Map textMIMESubtypeCharsetSupport;
    private static String defaultEncoding;
    private static final Set textNatives;
    private static final Map nativeCharsets;
    private static final Map nativeEOLNs;
    private static final Map nativeTerminators;
    private static final String DATA_CONVERTER_KEY = "DATA_CONVERTER_KEY";
    private static DataTransferer transferer;
    private static CharsetComparator defaultCharsetComparator;
    private static DataFlavorComparator defaultFlavorComparator;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTransferer getInstance() {
        if (transferer == null) {
            Class clazz = DataTransferer.class;
            synchronized (clazz) {
                String string;
                if (transferer == null && (string = SunToolkit.getDataTransfererClassName()) != null) {
                    PrivilegedAction privilegedAction = new PrivilegedAction(){

                        public Object run() {
                            Object object;
                            Method method;
                            Class<?> clazz;
                            block11: {
                                clazz = null;
                                method = null;
                                object = null;
                                try {
                                    clazz = Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                    if (classLoader == null) break block11;
                                    try {
                                        clazz = classLoader.loadClass(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        classNotFoundException2.printStackTrace();
                                        throw new AWTError("DataTransferer not found: " + string);
                                    }
                                }
                            }
                            if (clazz != null) {
                                try {
                                    method = clazz.getMethod("getInstanceImpl", null);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    noSuchMethodException.printStackTrace();
                                    throw new AWTError("Cannot instantiate DataTransferer: " + string);
                                }
                            }
                            if (method != null) {
                                try {
                                    object = method.invoke(null, null);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    invocationTargetException.printStackTrace();
                                    throw new AWTError("Cannot instantiate DataTransferer: " + string);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    illegalAccessException.printStackTrace();
                                    throw new AWTError("Cannot access DataTransferer: " + string);
                                }
                            }
                            return object;
                        }
                    };
                    transferer = (DataTransferer)AccessController.doPrivileged(privilegedAction);
                }
            }
        }
        return transferer;
    }

    public static String canonicalName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = CharacterEncoding.aliasName((String)string);
        if (string2 == null) {
            try {
                string2 = Charset.forName(string).name();
            }
            catch (Exception exception) {
                string2 = string;
            }
        }
        return string2;
    }

    public static String getTextCharset(DataFlavor dataFlavor) {
        if (!DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            return null;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? string : DataTransferer.getDefaultTextCharset();
    }

    public static String getDefaultTextCharset() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
        String string = AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            defaultEncoding = DataTransferer.canonicalName(string);
            if (!DataTransferer.isEncodingSupported(defaultEncoding)) {
                defaultEncoding = "ISO8859_1";
            }
            return defaultEncoding;
        }
        return "ISO8859_1";
    }

    public static boolean doesSubtypeSupportCharset(DataFlavor dataFlavor) {
        String string = dataFlavor.getSubType();
        if (string == null) {
            return false;
        }
        Object v = textMIMESubtypeCharsetSupport.get(string);
        if (v != null) {
            return v == Boolean.TRUE;
        }
        boolean bl = dataFlavor.getParameter("charset") != null;
        textMIMESubtypeCharsetSupport.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    public static boolean doesSubtypeSupportCharset(String string, String string2) {
        Object v = textMIMESubtypeCharsetSupport.get(string);
        if (v != null) {
            return v == Boolean.TRUE;
        }
        boolean bl = string2 != null;
        textMIMESubtypeCharsetSupport.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    public static boolean isFlavorCharsetTextType(DataFlavor dataFlavor) {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return true;
        }
        if (!"text".equals(dataFlavor.getPrimaryType()) || !DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        Class clazz = dataFlavor.getRepresentationClass();
        if (dataFlavor.isRepresentationClassReader() || String.class.equals(clazz) || dataFlavor.isRepresentationClassCharBuffer() || charArrayClass.equals(clazz)) {
            return true;
        }
        if (!(dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(clazz))) {
            return false;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? DataTransferer.isEncodingSupported(string) : true;
    }

    public static boolean isFlavorNoncharsetTextType(DataFlavor dataFlavor) {
        if (!"text".equals(dataFlavor.getPrimaryType()) || DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        return dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(dataFlavor.getRepresentationClass());
    }

    public static boolean isEncodingSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = DataTransferer.canonicalName(string);
        Boolean bl = (Boolean)knownEncodings.get(string2);
        if (bl == null) {
            try {
                new String("abc".getBytes(string2), string2);
                bl = Boolean.TRUE;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl = Boolean.FALSE;
            }
            knownEncodings.put(string2, bl);
        }
        return bl == Boolean.TRUE;
    }

    public static Iterator standardEncodings() {
        if (standardEncodings == null) {
            TreeSet<String> treeSet = new TreeSet<String>(defaultCharsetComparator);
            treeSet.add("US-ASCII");
            treeSet.add("ISO-8859-1");
            treeSet.add("UTF-8");
            treeSet.add("UTF-16BE");
            treeSet.add("UTF-16LE");
            treeSet.add("UTF-16");
            treeSet.add(DataTransferer.getDefaultTextCharset());
            standardEncodings = Collections.unmodifiableSortedSet(treeSet);
        }
        return standardEncodings.iterator();
    }

    public static FlavorTable adaptFlavorMap(final FlavorMap flavorMap) {
        if (flavorMap instanceof FlavorTable) {
            return (FlavorTable)flavorMap;
        }
        return new FlavorTable(){

            public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
                return flavorMap.getNativesForFlavors(dataFlavorArray);
            }

            public Map getFlavorsForNatives(String[] stringArray) {
                return flavorMap.getFlavorsForNatives(stringArray);
            }

            public List getNativesForFlavor(DataFlavor dataFlavor) {
                Map map = this.getNativesForFlavors(new DataFlavor[]{dataFlavor});
                String string = (String)map.get(dataFlavor);
                if (string != null) {
                    ArrayList<String> arrayList = new ArrayList<String>(1);
                    arrayList.add(string);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }

            public List getFlavorsForNative(String string) {
                Map map = this.getFlavorsForNatives(new String[]{string});
                DataFlavor dataFlavor = (DataFlavor)map.get(string);
                if (dataFlavor != null) {
                    ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(1);
                    arrayList.add(dataFlavor);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }
        };
    }

    public abstract String getDefaultUnicodeEncoding();

    public void registerTextFlavorProperties(String string, String string2, String string3, String string4) {
        Integer n;
        Long l = this.getFormatForNativeAsLong(string);
        textNatives.add(l);
        nativeCharsets.put(l, string2 != null && string2.length() != 0 ? string2 : DataTransferer.getDefaultTextCharset());
        if (string3 != null && string3.length() != 0 && !string3.equals("\n")) {
            nativeEOLNs.put(l, string3);
        }
        if (string4 != null && string4.length() != 0 && (n = Integer.valueOf(string4)) > 0) {
            nativeTerminators.put(l, n);
        }
    }

    private boolean isTextFormat(long l) {
        return textNatives.contains(new Long(l));
    }

    public abstract boolean isLocaleDependentTextFormat(long var1);

    public abstract boolean isFileFormat(long var1);

    public abstract boolean isImageFormat(long var1);

    public Map getFormatsForTransferable(Transferable transferable, FlavorTable flavorTable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray == null) {
            return new HashMap(0);
        }
        return this.getFormatsForFlavors(dataFlavorArray, flavorTable);
    }

    public Map getFormatsForFlavor(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return this.getFormatsForFlavors(new DataFlavor[]{dataFlavor}, flavorTable);
    }

    public Map getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        HashMap<Long, DataFlavor> hashMap = new HashMap<Long, DataFlavor>(dataFlavorArray.length);
        HashMap<Long, DataFlavor> hashMap2 = new HashMap<Long, DataFlavor>(dataFlavorArray.length);
        for (int i = dataFlavorArray.length - 1; i >= 0; --i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (dataFlavor == null || !dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
            List list = flavorTable.getNativesForFlavor(dataFlavor);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Long l = this.getFormatForNativeAsLong((String)iterator.next());
                hashMap.put(l, dataFlavor);
                if ((!"text".equals(dataFlavor.getPrimaryType()) || !"plain".equals(dataFlavor.getSubType())) && !dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                hashMap2.put(l, dataFlavor);
            }
        }
        hashMap.putAll(hashMap2);
        return hashMap;
    }

    public long[] getFormatsForTransferableAsArray(Transferable transferable, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForTransferable(transferable, flavorTable));
    }

    public long[] getFormatsForFlavorAsArray(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavor(dataFlavor, flavorTable));
    }

    public long[] getFormatsForFlavorsAsArray(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavors(dataFlavorArray, flavorTable));
    }

    public Map getFlavorsForFormat(long l, FlavorTable flavorTable) {
        return this.getFlavorsForFormats(new long[]{l}, flavorTable);
    }

    public Map getFlavorsForFormats(long[] lArray, FlavorTable flavorTable) {
        Object object;
        Object object2;
        Object object3;
        HashMap<DataFlavor, Object> hashMap = new HashMap<DataFlavor, Object>(lArray.length);
        HashSet<Object> hashSet = new HashSet<Object>(lArray.length);
        HashSet<DataFlavor> hashSet2 = new HashSet<DataFlavor>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            object3 = this.getNativeForFormat(l);
            object2 = flavorTable.getFlavorsForNative((String)object3);
            object = object2.iterator();
            while (object.hasNext()) {
                DataFlavor dataFlavor = (DataFlavor)object.next();
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                Long l2 = new Long(l);
                Object object4 = DataTransferer.createMapping(l2, dataFlavor);
                hashMap.put(dataFlavor, l2);
                hashSet.add(object4);
                hashSet2.add(dataFlavor);
            }
        }
        Iterator iterator = hashSet2.iterator();
        block2: while (iterator.hasNext()) {
            DataFlavor dataFlavor = (DataFlavor)iterator.next();
            List list = flavorTable.getNativesForFlavor(dataFlavor);
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = this.getFormatForNativeAsLong((String)object3.next());
                object = DataTransferer.createMapping(object2, dataFlavor);
                if (!hashSet.contains(object)) continue;
                hashMap.put(dataFlavor, object2);
                continue block2;
            }
        }
        return hashMap;
    }

    public Set getFlavorsForFormatsAsSet(long[] lArray, FlavorTable flavorTable) {
        HashSet<DataFlavor> hashSet = new HashSet<DataFlavor>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            String string = this.getNativeForFormat(lArray[i]);
            List list = flavorTable.getFlavorsForNative(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DataFlavor dataFlavor = (DataFlavor)iterator.next();
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                hashSet.add(dataFlavor);
            }
        }
        return hashSet;
    }

    public DataFlavor[] getFlavorsForFormatAsArray(long l, FlavorTable flavorTable) {
        return this.getFlavorsForFormatsAsArray(new long[]{l}, flavorTable);
    }

    public DataFlavor[] getFlavorsForFormatsAsArray(long[] lArray, FlavorTable flavorTable) {
        return DataTransferer.setToSortedDataFlavorArray(this.getFlavorsForFormatsAsSet(lArray, flavorTable));
    }

    private static Object createMapping(Object object, Object object2) {
        return Arrays.asList(object, object2);
    }

    protected abstract Long getFormatForNativeAsLong(String var1);

    protected abstract String getNativeForFormat(long var1);

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        Object object;
        boolean bl;
        Object object2;
        try {
            object2 = transferable.getTransferData(dataFlavor);
            if (object2 == null) {
                return null;
            }
            if (dataFlavor.equals(DataFlavor.plainTextFlavor) && !(object2 instanceof InputStream)) {
                object2 = transferable.getTransferData(DataFlavor.stringFlavor);
                if (object2 == null) {
                    return null;
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new IOException(unsupportedFlavorException.getMessage());
        }
        if (bl || String.class.equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
            int n;
            String string = (String)object2;
            Long l2 = new Long(l);
            String string2 = (String)nativeCharsets.get(l2);
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            String string3 = (String)nativeEOLNs.get(l2);
            Integer n2 = (Integer)nativeTerminators.get(l2);
            if (string3 != null) {
                int n3 = string.length();
                StringBuffer stringBuffer = new StringBuffer(n3 * 2);
                for (int i = 0; i < n3; ++i) {
                    n = string.charAt(i);
                    if (n == 10) {
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append((char)n);
                }
                string = stringBuffer.toString();
            }
            byte[] byArray = string.getBytes(string2);
            if (n2 != null) {
                int n4 = n2;
                byte[] byArray2 = new byte[byArray.length + n4];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                for (n = byArray.length; n < byArray2.length; ++n) {
                    byArray2[n] = 0;
                }
                byArray = byArray2;
            }
            return byArray;
        }
        if (dataFlavor.isRepresentationClassReader()) {
            int n;
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            Reader reader = (Reader)object2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = reader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            reader.close();
            return this.translateTransferable(new StringSelection(stringBuffer.toString()), DataFlavor.plainTextFlavor, l);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = (CharBuffer)object2;
            int n = charBuffer.remaining();
            char[] cArray = new char[n];
            charBuffer.get(cArray, 0, n);
            return this.translateTransferable(new StringSelection(new String(cArray)), DataFlavor.plainTextFlavor, l);
        }
        if (charArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return this.translateTransferable(new StringSelection(new String((char[])object2)), DataFlavor.plainTextFlavor, l);
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            ByteBuffer byteBuffer = (ByteBuffer)object2;
            int n = byteBuffer.remaining();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray, string)), DataFlavor.plainTextFlavor, l);
            }
            return byArray;
        }
        if (byteArrayClass.equals(dataFlavor.getRepresentationClass())) {
            byte[] byArray = (byte[])object2;
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray, string)), DataFlavor.plainTextFlavor, l);
            }
            return byArray;
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            if (!this.isImageFormat(l)) {
                throw new IOException("Data translation failed: not an image format");
            }
            Image image = (Image)object2;
            byte[] byArray = this.imageToPlatformBytes(image, l);
            if (byArray == null) {
                throw new IOException("Data translation failed: cannot convert java image to native format");
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.isFileFormat(l)) {
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            object = (List)object2;
            int n = 0;
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                if (!(e instanceof File) && !(e instanceof String)) continue;
                ++n;
            }
            String[] stringArray = new String[n];
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction((List)object, stringArray){
                    private final /* synthetic */ List val$list;
                    private final /* synthetic */ String[] val$files;
                    {
                        this.val$list = list;
                        this.val$files = stringArray;
                    }

                    public Object run() throws IOException {
                        int n = 0;
                        for (int i = 0; i < this.val$list.size(); ++i) {
                            Object e = this.val$list.get(i);
                            if (e instanceof File) {
                                this.val$files[n++] = ((File)e).getCanonicalPath();
                                continue;
                            }
                            if (!(e instanceof String)) continue;
                            this.val$files[n++] = (String)e;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new IOException(privilegedActionException.getMessage());
            }
            for (int i = 0; i < stringArray.length; ++i) {
                byte[] byArray = stringArray[i].getBytes("UTF-8");
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(0);
        } else if (dataFlavor.isRepresentationClassInputStream()) {
            object = (InputStream)object2;
            boolean bl2 = false;
            int n = ((InputStream)object).available();
            byte[] byArray = new byte[n > 8192 ? n : 8192];
            do {
                int n5;
                if (bl2 = (n5 = ((InputStream)object).read(byArray, 0, byArray.length)) == -1) continue;
                byteArrayOutputStream.write(byArray, 0, n5);
            } while (!bl2);
            ((InputStream)object).close();
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray3, string)), DataFlavor.plainTextFlavor, l);
            }
        } else if (dataFlavor.isRepresentationClassRemote()) {
            object = new MarshalledObject<Object>(object2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        } else if (dataFlavor.isRepresentationClassSerializable()) {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(object2);
            ((ObjectOutputStream)object).close();
        } else {
            throw new IOException("data translation failed");
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return object;
    }

    public Object translateBytes(byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        return this.translateBytesOrStream(null, byArray, dataFlavor, l, transferable);
    }

    public Object translateStream(InputStream inputStream, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        return this.translateBytesOrStream(inputStream, null, dataFlavor, l, transferable);
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(byArray);
        }
        if (this.isFileFormat(l)) {
            String[] stringArray;
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            if ((stringArray = this.dragQueryFile(byArray)) == null) {
                inputStream.close();
                return null;
            }
            File[] fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(stringArray[i]);
            }
            inputStream.close();
            return Arrays.asList(fileArray);
        }
        if (String.class.equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
            int n;
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            inputStream.close();
            Long l2 = new Long(l);
            String string = null;
            if (this.isLocaleDependentTextFormat(l) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string = (String)nativeCharsets.get(l2);
            }
            if (string == null) {
                string = DataTransferer.getDefaultTextCharset();
            }
            String string2 = (String)nativeEOLNs.get(l2);
            Integer n2 = (Integer)nativeTerminators.get(l2);
            if (n2 != null) {
                int n3 = n2;
                block7: for (n = 0; n < byArray.length - n3 + 1; n += n3) {
                    for (int i = n; i < n + n3; ++i) {
                        if (byArray[i] != 0) continue block7;
                    }
                    break;
                }
            } else {
                n = byArray.length;
            }
            String string3 = new String(byArray, 0, n, string);
            if (string2 != null) {
                char[] cArray = string3.toCharArray();
                char[] cArray2 = string2.toCharArray();
                string3 = null;
                int n4 = 0;
                int n5 = 0;
                while (n5 < cArray.length) {
                    if (n5 + cArray2.length > cArray.length) {
                        cArray[n4++] = cArray[n5++];
                        continue;
                    }
                    boolean bl = true;
                    int n6 = 0;
                    int n7 = n5;
                    while (n6 < cArray2.length) {
                        if (cArray2[n6] != cArray[n7]) {
                            bl = false;
                            break;
                        }
                        ++n6;
                        ++n7;
                    }
                    if (bl) {
                        cArray[n4++] = 10;
                        n5 += cArray2.length;
                        continue;
                    }
                    cArray[n4++] = cArray[n5++];
                }
                string3 = new String(cArray, 0, n4);
            }
            return string3;
        }
        if (DataFlavor.plainTextFlavor.equals(dataFlavor)) {
            return new StringReader((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l, transferable));
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            return this.translateBytesOrStreamToInputStream(inputStream, dataFlavor, l, transferable);
        }
        if (dataFlavor.isRepresentationClassReader()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            InputStream inputStream2 = (InputStream)this.translateBytesOrStreamToInputStream(inputStream, DataFlavor.plainTextFlavor, l, transferable);
            String string = DataTransferer.getTextCharset(DataFlavor.plainTextFlavor);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, string);
            return this.constructFlavoredObject(inputStreamReader, dataFlavor, Reader.class);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = CharBuffer.wrap((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l, transferable));
            return this.constructFlavoredObject(charBuffer, dataFlavor, CharBuffer.class);
        }
        if (charArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l, transferable)).toCharArray();
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                byArray = ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l, transferable)).getBytes(DataTransferer.getTextCharset(dataFlavor));
            } else if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            return this.constructFlavoredObject(byteBuffer, dataFlavor, ByteBuffer.class);
        }
        if (byteArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                return ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l, transferable)).getBytes(DataTransferer.getTextCharset(dataFlavor));
            }
            return byArray != null ? byArray : DataTransferer.inputStreamToByteArray(inputStream);
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            try {
                byte[] byArray2 = DataTransferer.inputStreamToByteArray(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray2));
                Object t = ((MarshalledObject)objectInputStream.readObject()).get();
                objectInputStream.close();
                inputStream.close();
                return t;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassSerializable()) {
            try {
                byte[] byArray3 = DataTransferer.inputStreamToByteArray(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray3));
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            if (!this.isImageFormat(l)) {
                throw new IOException("data translation failed");
            }
            Image image = this.platformImageBytesOrStreamToImage(inputStream, byArray, l);
            inputStream.close();
            return image;
        }
        throw new IOException("data translation failed");
    }

    private Object translateBytesOrStreamToInputStream(InputStream inputStream, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
            inputStream = new ReencodingInputStream(inputStream, l, DataTransferer.getTextCharset(dataFlavor), transferable);
        }
        return this.constructFlavoredObject(inputStream, dataFlavor, InputStream.class);
    }

    private Object constructFlavoredObject(Object object, DataFlavor dataFlavor, Class clazz) throws IOException {
        final Class clazz2 = dataFlavor.getRepresentationClass();
        if (clazz.equals(clazz2)) {
            return object;
        }
        Constructor[] constructorArray = null;
        try {
            constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz2.getConstructors();
                }
            });
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getMessage());
        }
        Constructor constructor = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray;
            if (!Modifier.isPublic(constructorArray[i].getModifiers()) || (classArray = constructorArray[i].getParameterTypes()) == null || classArray.length != 1 || !clazz.equals(classArray[0])) continue;
            constructor = constructorArray[i];
            break;
        }
        if (constructor == null) {
            throw new IOException("can't find <init>(L" + clazz + ";)V for class: " + clazz2.getName());
        }
        try {
            return constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private native String[] dragQueryFile(byte[] var1);

    protected abstract Image platformImageBytesOrStreamToImage(InputStream var1, byte[] var2, long var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image standardImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, String string) throws IOException {
        Iterator iterator;
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(byArray);
        }
        if (!(iterator = ImageIO.getImageReadersByMIMEType(string)).hasNext()) {
            throw new IOException("No registered service provider can decode  an image from " + string);
        }
        IOException iOException = null;
        while (true) {
            if (!iterator.hasNext()) {
                if (iOException != null) throw iOException;
                iOException = new IOException("Registered service providers failed to decode an image from " + string);
                throw iOException;
            }
            ImageReader imageReader = (ImageReader)iterator.next();
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                try {
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    BufferedImage bufferedImage = imageReader.read(imageReader.getMinIndex(), imageReadParam);
                    if (bufferedImage == null) continue;
                    BufferedImage bufferedImage2 = bufferedImage;
                    return bufferedImage2;
                }
                finally {
                    imageInputStream.close();
                    imageReader.dispose();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
            break;
        }
    }

    protected abstract byte[] imageToPlatformBytes(Image var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToStandardBytes(Image image, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = null;
        Iterator iterator = ImageIO.getImageWritersByMIMEType(string);
        if (!iterator.hasNext()) {
            throw new IOException("No registered service provider can encode  an image to " + string);
        }
        if (image instanceof RenderedImage) {
            object5 = (RenderedImage)((Object)image);
        } else {
            int n = 0;
            int n2 = 0;
            if (image instanceof sun.awt.image.Image) {
                object4 = ((sun.awt.image.Image)image).getImageRep();
                ((ImageRepresentation)object4).reconstruct(32);
                n = ((ImageRepresentation)object4).getWidth();
                n2 = ((ImageRepresentation)object4).getHeight();
            } else {
                n = image.getWidth(null);
                n2 = image.getHeight(null);
            }
            object4 = ColorModel.getRGBdefault();
            object3 = ((ColorModel)object4).createCompatibleWritableRaster(n, n2);
            object2 = new BufferedImage((ColorModel)object4, (WritableRaster)object3, ((ColorModel)object4).isAlphaPremultiplied(), null);
            object = ((BufferedImage)object2).getGraphics();
            try {
                ((Graphics)object).drawImage(image, 0, 0, n, n2, null);
            }
            finally {
                ((Graphics)object).dispose();
            }
            object5 = object2;
        }
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier((RenderedImage)object5);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object4 = null;
        while (iterator.hasNext()) {
            object3 = (ImageWriter)iterator.next();
            object2 = ((ImageWriter)object3).getOriginatingProvider();
            if (!((ImageWriterSpi)object2).canEncodeImage(imageTypeSpecifier)) continue;
            try {
                object = ImageIO.createImageOutputStream(byteArrayOutputStream);
                try {
                    ((ImageWriter)object3).setOutput(object);
                    ((ImageWriter)object3).write((RenderedImage)object5);
                    object.flush();
                }
                finally {
                    object.close();
                }
            }
            catch (IOException iOException) {
                ((ImageWriter)object3).dispose();
                byteArrayOutputStream.reset();
                object4 = iOException;
                continue;
            }
            ((ImageWriter)object3).dispose();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        byteArrayOutputStream.close();
        if (object4 == null) {
            object4 = new IOException("Registered service providers failed to encode " + object5 + " to " + string);
        }
        throw object4;
    }

    private Object concatData(Object object, Object object2) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (object2 instanceof byte[]) {
                byte[] byArray2 = (byte[])object2;
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                return byArray3;
            }
            inputStream = new ByteArrayInputStream(byArray);
            inputStream2 = (InputStream)object2;
        } else {
            inputStream = (InputStream)object;
            inputStream2 = object2 instanceof byte[] ? new ByteArrayInputStream((byte[])object2) : (InputStream)object2;
        }
        return new SequenceInputStream(inputStream, inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertData(Object object, final Transferable transferable, final long l, final Map map, boolean bl) throws IOException {
        byte[] byArray = null;
        if (bl) {
            try {
                final Stack stack = new Stack();
                Runnable runnable = new Runnable(){
                    private boolean done = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (this.done) {
                            return;
                        }
                        byte[] byArray = null;
                        try {
                            DataFlavor dataFlavor = (DataFlavor)map.get(new Long(l));
                            if (dataFlavor != null) {
                                byArray = DataTransferer.this.translateTransferable(transferable, dataFlavor, l);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            byArray = null;
                        }
                        try {
                            DataTransferer.this.getToolkitThreadBlockedHandler().lock();
                            stack.push(byArray);
                            DataTransferer.this.getToolkitThreadBlockedHandler().exit();
                        }
                        finally {
                            DataTransferer.this.getToolkitThreadBlockedHandler().unlock();
                            this.done = true;
                        }
                    }
                };
                AppContext appContext = SunToolkit.targetToAppContext(object);
                this.getToolkitThreadBlockedHandler().lock();
                if (appContext != null) {
                    appContext.put(DATA_CONVERTER_KEY, runnable);
                }
                SunToolkit.executeOnEventHandlerThread(object, runnable);
                while (stack.empty()) {
                    this.getToolkitThreadBlockedHandler().enter();
                }
                if (appContext != null) {
                    appContext.remove(DATA_CONVERTER_KEY);
                }
                byArray = (byte[])stack.pop();
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        } else {
            DataFlavor dataFlavor = (DataFlavor)map.get(new Long(l));
            if (dataFlavor != null) {
                byArray = this.translateTransferable(transferable, dataFlavor, l);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataConversionRequests() {
        if (EventQueue.isDispatchThread()) {
            AppContext appContext = AppContext.getAppContext();
            this.getToolkitThreadBlockedHandler().lock();
            try {
                Runnable runnable = (Runnable)appContext.get(DATA_CONVERTER_KEY);
                if (runnable != null) {
                    runnable.run();
                    appContext.remove(DATA_CONVERTER_KEY);
                }
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        }
    }

    public abstract ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler();

    public static long[] keysToLongArray(Map map) {
        Set set = map.keySet();
        long[] lArray = new long[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            lArray[n] = (Long)iterator.next();
            ++n;
        }
        return lArray;
    }

    public static DataFlavor[] keysToDataFlavorArray(Map map) {
        return DataTransferer.setToSortedDataFlavorArray(map.keySet(), map);
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set) {
        DataFlavor[] dataFlavorArray = new DataFlavor[set.size()];
        set.toArray(dataFlavorArray);
        Arrays.sort(dataFlavorArray, defaultFlavorComparator);
        return dataFlavorArray;
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set, Map map) {
        DataFlavor[] dataFlavorArray = new DataFlavor[set.size()];
        set.toArray(dataFlavorArray);
        DataFlavorComparator dataFlavorComparator = new DataFlavorComparator(map, false);
        Arrays.sort(dataFlavorArray, dataFlavorComparator);
        return dataFlavorArray;
    }

    protected static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        textNatives = Collections.synchronizedSet(new HashSet());
        nativeCharsets = Collections.synchronizedMap(new HashMap());
        nativeEOLNs = Collections.synchronizedMap(new HashMap());
        nativeTerminators = Collections.synchronizedMap(new HashMap());
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        try {
            clazz = Class.forName("[C");
            clazz2 = Class.forName("[B");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        charArrayClass = clazz;
        byteArrayClass = clazz2;
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/plain;charset=Unicode;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        plainTextStringFlavor = dataFlavor;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor2 = new DataFlavor("application/x-java-text-encoding;class=\"[B\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        javaTextEncodingFlavor = dataFlavor2;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(11);
        hashMap.put("ASCII", Boolean.TRUE);
        hashMap.put("ISO8859_1", Boolean.TRUE);
        hashMap.put("UTF8", Boolean.TRUE);
        hashMap.put("UnicodeBigUnmarked", Boolean.TRUE);
        hashMap.put("UnicodeLittleUnmarked", Boolean.TRUE);
        hashMap.put("UTF16", Boolean.TRUE);
        knownEncodings = Collections.synchronizedMap(hashMap);
        hashMap = new HashMap(17);
        hashMap.put("sgml", Boolean.TRUE);
        hashMap.put("xml", Boolean.TRUE);
        hashMap.put("html", Boolean.TRUE);
        hashMap.put("enriched", Boolean.TRUE);
        hashMap.put("richtext", Boolean.TRUE);
        hashMap.put("uri-list", Boolean.TRUE);
        hashMap.put("directory", Boolean.TRUE);
        hashMap.put("css", Boolean.TRUE);
        hashMap.put("calendar", Boolean.TRUE);
        hashMap.put("plain", Boolean.TRUE);
        hashMap.put("rtf", Boolean.FALSE);
        hashMap.put("tab-separated-values", Boolean.FALSE);
        hashMap.put("t140", Boolean.FALSE);
        hashMap.put("rfc822-headers", Boolean.FALSE);
        hashMap.put("parityfec", Boolean.FALSE);
        textMIMESubtypeCharsetSupport = Collections.synchronizedMap(hashMap);
        defaultCharsetComparator = new CharsetComparator(false);
        defaultFlavorComparator = new DataFlavorComparator(false);
    }

    public static class DataFlavorComparator
    extends IndexedComparator {
        protected final Map flavorToFormatMap;
        private final CharsetComparator charsetComparator;
        private static final Map exactTypes;
        private static final Map primaryTypes;
        private static final Map nonTextRepresentations;
        private static final Map textTypes;
        private static final Map decodedTextRepresentations;
        private static final Map encodedTextRepresentations;
        private static final Integer UNKNOWN_OBJECT_LOSES;
        private static final Integer UNKNOWN_OBJECT_WINS;
        private static final Long UNKNOWN_OBJECT_LOSES_L;
        private static final Long UNKNOWN_OBJECT_WINS_L;

        public DataFlavorComparator() {
            this(true);
        }

        public DataFlavorComparator(boolean bl) {
            super(bl);
            this.charsetComparator = new CharsetComparator(bl);
            this.flavorToFormatMap = Collections.EMPTY_MAP;
        }

        public DataFlavorComparator(Map map) {
            this(map, true);
        }

        public DataFlavorComparator(Map map, boolean bl) {
            super(bl);
            this.charsetComparator = new CharsetComparator(bl);
            HashMap hashMap = new HashMap(map.size());
            hashMap.putAll(map);
            this.flavorToFormatMap = Collections.unmodifiableMap(hashMap);
        }

        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            if (this.order) {
                dataFlavor = (DataFlavor)object;
                dataFlavor2 = (DataFlavor)object2;
            } else {
                dataFlavor = (DataFlavor)object2;
                dataFlavor2 = (DataFlavor)object;
            }
            if (dataFlavor.equals(dataFlavor2)) {
                return 0;
            }
            int n = 0;
            String string = dataFlavor.getPrimaryType();
            String string2 = dataFlavor.getSubType();
            String string3 = string + "/" + string2;
            Class clazz = dataFlavor.getRepresentationClass();
            String string4 = dataFlavor2.getPrimaryType();
            String string5 = dataFlavor2.getSubType();
            String string6 = string4 + "/" + string5;
            Class clazz2 = dataFlavor2.getRepresentationClass();
            if (dataFlavor.isFlavorTextType() && dataFlavor2.isFlavorTextType()) {
                n = DataFlavorComparator.compareIndices(textTypes, string3, string6, UNKNOWN_OBJECT_LOSES);
                if (n != 0) {
                    return n;
                }
                if (DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
                    n = DataFlavorComparator.compareIndices(decodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                    if (n != 0) {
                        return n;
                    }
                    n = this.charsetComparator.compareCharsets(DataTransferer.getTextCharset(dataFlavor), DataTransferer.getTextCharset(dataFlavor2));
                    if (n != 0) {
                        return n;
                    }
                }
                if ((n = DataFlavorComparator.compareIndices(encodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES)) != 0) {
                    return n;
                }
            } else {
                n = DataFlavorComparator.compareIndices(primaryTypes, string, string4, UNKNOWN_OBJECT_LOSES);
                if (n != 0) {
                    return n;
                }
                n = DataFlavorComparator.compareIndices(exactTypes, string3, string6, UNKNOWN_OBJECT_WINS);
                if (n != 0) {
                    return n;
                }
                n = DataFlavorComparator.compareIndices(nonTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                if (n != 0) {
                    return n;
                }
            }
            return DataFlavorComparator.compareLongs(this.flavorToFormatMap, dataFlavor, dataFlavor2, UNKNOWN_OBJECT_LOSES_L);
        }

        static {
            UNKNOWN_OBJECT_LOSES = new Integer(Integer.MIN_VALUE);
            UNKNOWN_OBJECT_WINS = new Integer(Integer.MAX_VALUE);
            UNKNOWN_OBJECT_LOSES_L = new Long(Long.MIN_VALUE);
            UNKNOWN_OBJECT_WINS_L = new Long(Long.MAX_VALUE);
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(4, 1.0f);
            hashMap.put("application/x-java-file-list", new Integer(0));
            hashMap.put("application/x-java-serialized-object", new Integer(1));
            hashMap.put("application/x-java-jvm-local-objectref", new Integer(2));
            hashMap.put("application/x-java-remote-object", new Integer(3));
            exactTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(1, 1.0f);
            hashMap.put("application", new Integer(0));
            primaryTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream, new Integer(0));
            hashMap.put(class$java$io$Serializable == null ? (class$java$io$Serializable = DataTransferer.class$("java.io.Serializable")) : class$java$io$Serializable, new Integer(1));
            hashMap.put(class$java$rmi$Remote == null ? (class$java$rmi$Remote = DataTransferer.class$("java.rmi.Remote")) : class$java$rmi$Remote, new Integer(2));
            nonTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(16, 1.0f);
            hashMap.put("text/plain", new Integer(0));
            hashMap.put("application/x-java-serialized-object", new Integer(1));
            hashMap.put("text/calendar", new Integer(2));
            hashMap.put("text/css", new Integer(3));
            hashMap.put("text/directory", new Integer(4));
            hashMap.put("text/parityfec", new Integer(5));
            hashMap.put("text/rfc822-headers", new Integer(6));
            hashMap.put("text/t140", new Integer(7));
            hashMap.put("text/tab-separated-values", new Integer(8));
            hashMap.put("text/uri-list", new Integer(9));
            hashMap.put("text/richtext", new Integer(10));
            hashMap.put("text/enriched", new Integer(11));
            hashMap.put("text/rtf", new Integer(12));
            hashMap.put("text/html", new Integer(13));
            hashMap.put("text/xml", new Integer(14));
            hashMap.put("text/sgml", new Integer(15));
            textTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(4, 1.0f);
            hashMap.put(charArrayClass, new Integer(0));
            hashMap.put(class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = DataTransferer.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer, new Integer(1));
            hashMap.put(class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String, new Integer(2));
            hashMap.put(class$java$io$Reader == null ? (class$java$io$Reader = DataTransferer.class$("java.io.Reader")) : class$java$io$Reader, new Integer(3));
            decodedTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(byteArrayClass, new Integer(0));
            hashMap.put(class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = DataTransferer.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer, new Integer(1));
            hashMap.put(class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream, new Integer(2));
            encodedTextRepresentations = Collections.unmodifiableMap(hashMap);
        }
    }

    public static class CharsetComparator
    extends IndexedComparator {
        private static final Map charsets;
        private static String defaultEncoding;
        private static final Integer DEFAULT_CHARSET_INDEX;
        private static final Integer OTHER_CHARSET_INDEX;
        private static final Integer WORST_CHARSET_INDEX;
        private static final Integer UNSUPPORTED_CHARSET_INDEX;
        private static final String UNSUPPORTED_CHARSET = "UNSUPPORTED";

        public CharsetComparator() {
            this(true);
        }

        public CharsetComparator(boolean bl) {
            super(bl);
        }

        public int compare(Object object, Object object2) {
            String string = null;
            String string2 = null;
            if (this.order) {
                string = (String)object;
                string2 = (String)object2;
            } else {
                string = (String)object2;
                string2 = (String)object;
            }
            return this.compareCharsets(string, string2);
        }

        protected int compareCharsets(String string, String string2) {
            int n = CharsetComparator.compareIndices(charsets, string = CharsetComparator.getEncoding(string), string2 = CharsetComparator.getEncoding(string2), OTHER_CHARSET_INDEX);
            if (n == 0) {
                return string2.compareTo(string);
            }
            return n;
        }

        protected static String getEncoding(String string) {
            if (string == null) {
                return null;
            }
            if (!DataTransferer.isEncodingSupported(string)) {
                return UNSUPPORTED_CHARSET;
            }
            String string2 = DataTransferer.canonicalName(string);
            return charsets.containsKey(string2) ? string2 : string;
        }

        static {
            DEFAULT_CHARSET_INDEX = new Integer(2);
            OTHER_CHARSET_INDEX = new Integer(1);
            WORST_CHARSET_INDEX = new Integer(0);
            UNSUPPORTED_CHARSET_INDEX = new Integer(Integer.MIN_VALUE);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(8, 1.0f);
            hashMap.put("Unicode", new Integer(3));
            hashMap.put("UnicodeLittleUnmarked", new Integer(4));
            hashMap.put("UnicodeBigUnmarked", new Integer(5));
            hashMap.put("UTF8", new Integer(6));
            hashMap.put("UTF16", new Integer(7));
            hashMap.put("ASCII", WORST_CHARSET_INDEX);
            String string = DataTransferer.canonicalName(DataTransferer.getDefaultTextCharset());
            if (hashMap.get(defaultEncoding) == null) {
                hashMap.put(defaultEncoding, DEFAULT_CHARSET_INDEX);
            }
            hashMap.put(UNSUPPORTED_CHARSET, UNSUPPORTED_CHARSET_INDEX);
            charsets = Collections.unmodifiableMap(hashMap);
        }
    }

    public static abstract class IndexedComparator
    implements Comparator {
        public static final boolean SELECT_BEST = true;
        public static final boolean SELECT_WORST = false;
        protected final boolean order;

        public IndexedComparator() {
            this(true);
        }

        public IndexedComparator(boolean bl) {
            this.order = bl;
        }

        protected static int compareIndices(Map map, Object object, Object object2, Integer n) {
            Integer n2 = (Integer)map.get(object);
            Integer n3 = (Integer)map.get(object2);
            if (n2 == null) {
                n2 = n;
            }
            if (n3 == null) {
                n3 = n;
            }
            return n2.compareTo(n3);
        }

        protected static int compareLongs(Map map, Object object, Object object2, Long l) {
            Long l2 = (Long)map.get(object);
            Long l3 = (Long)map.get(object2);
            if (l2 == null) {
                l2 = l;
            }
            if (l3 == null) {
                l3 = l;
            }
            return l2.compareTo(l3);
        }
    }

    public class ReencodingInputStream
    extends InputStream {
        protected BufferedReader wrapped;
        protected CharToByteConverter converter;
        protected final char[] in = new char[1];
        protected byte[] out;
        protected CharsetEncoder encoder;
        protected CharBuffer inBuf;
        protected ByteBuffer outBuf;
        protected char[] eoln;
        protected int numTerminators;
        protected boolean eos;
        protected int index;
        protected int limit;

        public ReencodingInputStream(InputStream inputStream, long l, String string, Transferable transferable) throws IOException {
            Integer n;
            Long l2 = new Long(l);
            String string2 = null;
            if (DataTransferer.this.isLocaleDependentTextFormat(l) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string2 = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string2 = (String)nativeCharsets.get(l2);
            }
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            this.wrapped = new BufferedReader(new InputStreamReader(inputStream, string2));
            try {
                this.converter = CharToByteConverter.getConverter((String)string);
                this.out = new byte[this.converter.getMaxBytesPerChar()];
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.encoder = Charset.forName(string).newEncoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                    this.out = new byte[(int)((double)this.encoder.maxBytesPerChar() + 0.5)];
                    this.inBuf = CharBuffer.wrap(this.in);
                    this.outBuf = ByteBuffer.wrap(this.out);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw unsupportedEncodingException;
                }
            }
            String string3 = (String)nativeEOLNs.get(l2);
            if (string3 != null) {
                this.eoln = string3.toCharArray();
            }
            if ((n = (Integer)nativeTerminators.get(l2)) != null) {
                this.numTerminators = n;
            }
        }

        public int read() throws IOException {
            if (this.eos) {
                return -1;
            }
            if (this.index >= this.limit) {
                int n = this.wrapped.read();
                if (n == -1) {
                    this.eos = true;
                    return -1;
                }
                if (this.numTerminators > 0 && n == 0) {
                    this.eos = true;
                    return -1;
                }
                if (this.eoln != null && this.matchCharArray(this.eoln, n)) {
                    n = 10;
                }
                this.in[0] = (char)n;
                if (this.converter != null) {
                    this.limit = this.converter.convert(this.in, 0, 1, this.out, 0, this.out.length);
                } else {
                    this.inBuf.rewind();
                    this.outBuf.rewind();
                    this.encoder.encode(this.inBuf, this.outBuf, false);
                    this.limit = this.outBuf.limit();
                }
                this.index = 0;
                return this.read();
            }
            return this.out[this.index++] & 0xFF;
        }

        public int available() throws IOException {
            return this.eos ? 0 : this.limit - this.index;
        }

        public void close() throws IOException {
            this.wrapped.close();
        }

        private boolean matchCharArray(char[] cArray, int n) throws IOException {
            this.wrapped.mark(cArray.length);
            int n2 = 0;
            if ((char)n == cArray[0]) {
                for (n2 = 1; n2 < cArray.length && (n = this.wrapped.read()) != -1 && (char)n == cArray[n2]; ++n2) {
                }
            }
            if (n2 == cArray.length) {
                return true;
            }
            this.wrapped.reset();
            return false;
        }
    }
}

