/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsBorders {
    public static Border getProgressBarBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new ProgressBarBorder(uIDefaults.getColor("ProgressBar.shadow"), uIDefaults.getColor("ProgressBar.highlight")), new EmptyBorder(1, 1, 1, 1));
        return compoundBorderUIResource;
    }

    public static Border getToolBarBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ToolBarBorder toolBarBorder = new ToolBarBorder(uIDefaults.getColor("ToolBar.shadow"), uIDefaults.getColor("ToolBar.highlight"));
        return toolBarBorder;
    }

    public static Border getFocusCellHighlightBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        DashedBorder dashedBorder = new DashedBorder(uIDefaults.getColor("List.focusCellBorderColor"));
        return dashedBorder;
    }

    public static Border getTableHeaderBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new BasicBorders.ButtonBorder(uIDefaults.getColor("Table.shadow"), uIDefaults.getColor("Table.darkShadow"), uIDefaults.getColor("Table.light"), uIDefaults.getColor("Table.highlight")), new BasicBorders.MarginBorder());
        return compoundBorderUIResource;
    }

    public static Border getInternalFrameBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(BorderFactory.createBevelBorder(0, uIDefaults.getColor("InternalFrame.borderColor"), uIDefaults.getColor("InternalFrame.borderHighlight"), uIDefaults.getColor("InternalFrame.borderDarkShadow"), uIDefaults.getColor("InternalFrame.borderShadow")), new InternalFrameLineBorder(uIDefaults.getColor("InternalFrame.activeBorderColor"), uIDefaults.getColor("InternalFrame.inactiveBorderColor"), uIDefaults.getInt("InternalFrame.borderWidth")));
        return compoundBorderUIResource;
    }

    public static class InternalFrameLineBorder
    extends LineBorder
    implements UIResource {
        protected Color activeColor;
        protected Color inactiveColor;

        public InternalFrameLineBorder(Color color, Color color2, int n) {
            super(color, n);
            this.activeColor = color;
            this.inactiveColor = color2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JInternalFrame jInternalFrame = null;
            if (component instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)component;
            } else if (component instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
            } else {
                return;
            }
            if (jInternalFrame.isSelected()) {
                this.lineColor = this.activeColor;
                super.paintBorder(component, graphics, n, n2, n3, n4);
            } else {
                this.lineColor = this.inactiveColor;
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    public static class DashedBorder
    extends LineBorder
    implements UIResource {
        public DashedBorder(Color color) {
            super(color);
        }

        public DashedBorder(Color color, int n) {
            super(color, n);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.lineColor);
            for (int i = 0; i < this.thickness; ++i) {
                BasicGraphicsUtils.drawDashedRect(graphics, n + i, n2 + i, n3 - i - i, n4 - i - i);
            }
            graphics.setColor(color);
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        protected Color shadow;
        protected Color highlight;
        private XPStyle xp = XPStyle.getXP();

        public ToolBarBorder(Color color, Color color2) {
            this.highlight = color2;
            this.shadow = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (((JToolBar)component).isFloatable()) {
                boolean bl;
                boolean bl2 = bl = ((JToolBar)component).getOrientation() == 1;
                if (this.xp != null) {
                    Border border = this.xp.getBorder("toolbar");
                    if (border != null) {
                        border.paintBorder(component, graphics, 0, 0, n3, n4);
                    }
                    String string = bl ? "rebar.grippervert" : "rebar.gripper";
                    XPStyle.Skin skin = this.xp.getSkin(string);
                    int n5 = bl ? n3 - 1 : skin.getWidth();
                    int n6 = bl ? skin.getHeight() : n4 - 1;
                    int n7 = bl || component.getComponentOrientation().isLeftToRight() ? 1 : n3 - n5 - 1;
                    skin.paintSkin(graphics, n7, 1, n5, n6, 0);
                } else if (!bl) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        graphics.setColor(this.shadow);
                        graphics.drawLine(4, 3, 4, n4 - 4);
                        graphics.drawLine(4, n4 - 4, 2, n4 - 4);
                        graphics.setColor(this.highlight);
                        graphics.drawLine(2, 3, 3, 3);
                        graphics.drawLine(2, 3, 2, n4 - 5);
                    } else {
                        graphics.setColor(this.shadow);
                        graphics.drawLine(n3 - 3, 3, n3 - 3, n4 - 4);
                        graphics.drawLine(n3 - 4, n4 - 4, n3 - 4, n4 - 4);
                        graphics.setColor(this.highlight);
                        graphics.drawLine(n3 - 5, 3, n3 - 4, 3);
                        graphics.drawLine(n3 - 5, 3, n3 - 5, n4 - 5);
                    }
                } else {
                    graphics.setColor(this.shadow);
                    graphics.drawLine(3, 4, n3 - 4, 4);
                    graphics.drawLine(n3 - 4, 2, n3 - 4, 4);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(3, 2, n3 - 4, 2);
                    graphics.drawLine(3, 2, 3, 3);
                }
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(1, 1, 1, 1));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        insets.left = 9;
                    } else {
                        insets.right = 9;
                    }
                } else {
                    insets.top = 9;
                }
            }
            return insets;
        }
    }

    public static class ProgressBarBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color highlight;

        public ProgressBarBorder(Color color, Color color2) {
            this.highlight = color2;
            this.shadow = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n, n2, n3 - 1, n2);
            graphics.drawLine(n, n2, n, n4 - 1);
            graphics.setColor(this.highlight);
            graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }
    }
}

