/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.PolicyNodeImpl;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.security.cert.PolicyNode;
import java.util.ArrayList;
import java.util.HashSet;

public class PolicyTree {
    private ArrayList nodes;
    private boolean valid;
    private int depth;

    public PolicyTree() {
        this.init();
    }

    private void init() {
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(objectIdentifier.toString());
        PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(objectIdentifier, new HashSet(), false, hashSet, null);
        this.nodes = new ArrayList();
        ArrayList<PolicyNodeImpl> arrayList = new ArrayList<PolicyNodeImpl>();
        arrayList.add(policyNodeImpl);
        this.nodes.add(policyNodeImpl.getDepth(), arrayList);
        this.valid = true;
        this.depth = 0;
    }

    public ArrayList getNodes(int n) {
        if (this.depth >= n) {
            return (ArrayList)this.nodes.get(n);
        }
        return null;
    }

    public PolicyNode getRoot() {
        return (PolicyNode)this.getNodes(0).get(0);
    }

    public void addNode(PolicyNodeImpl policyNodeImpl) {
        int n = policyNodeImpl.getDepth();
        if (this.depth >= n) {
            this.getNodes(n).add(policyNodeImpl);
        } else {
            ArrayList<PolicyNodeImpl> arrayList = new ArrayList<PolicyNodeImpl>();
            arrayList.add(policyNodeImpl);
            this.nodes.add(n, arrayList);
            this.depth = n;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
        if (!this.valid) {
            this.nodes = null;
        }
    }

    public void remove(PolicyNode policyNode) {
        int n = policyNode.getDepth();
        this.getNodes(n).remove(policyNode);
        if (this.getNodes(n).isEmpty()) {
            this.depth = n - 1;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void print() {
        for (int i = 0; i < this.getDepth() + 1; ++i) {
            ArrayList arrayList = this.getNodes(i);
            System.out.println("tree level: " + i);
            for (int j = 0; j < arrayList.size(); ++j) {
                ((PolicyNodeImpl)arrayList.get(j)).print();
            }
        }
    }
}

