/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.APOptions;
import com.ibm.security.krb5.internal.APReq;
import com.ibm.security.krb5.internal.Authenticator;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.EncTicketPart;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.KRBError;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.LocalSeqNumber;
import com.ibm.security.krb5.internal.SeqNumber;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.rcache.a;
import com.ibm.security.krb5.internal.rcache.b;
import com.ibm.security.util.DerValue;
import java.io.File;
import java.io.IOException;

public class KrbApReq {
    private static b a = new b();
    private byte[] b;
    private KerberosTime c;
    private int d;
    private Authenticator e;
    private Credentials f;
    private APReq g;
    private EncTicketPart h;

    public KrbApReq(Credentials credentials, boolean bl2, boolean bl3, boolean bl4) throws Asn1Exception, KrbCryptoException, KrbException, IOException {
        this(credentials, bl2, bl3, bl4, null);
    }

    public KrbApReq(Credentials credentials, boolean bl2, boolean bl3, boolean bl4, Checksum checksum) throws Asn1Exception, KrbCryptoException, KrbException, IOException {
        APOptions aPOptions = bl2 ? new APOptions(2) : new APOptions();
        EncryptionKey encryptionKey = bl3 ? new EncryptionKey(credentials.getSessionKey()) : null;
        LocalSeqNumber localSeqNumber = null;
        if (bl4) {
            localSeqNumber = new LocalSeqNumber();
        }
        this.a(aPOptions, credentials, checksum, encryptionKey, localSeqNumber, null);
    }

    public KrbApReq(byte[] byArray, EncryptionKey encryptionKey) throws KrbException, IOException {
        this.b = byArray;
        if (this.g == null) {
            this.a();
        }
        this.a(encryptionKey, null);
    }

    public KrbApReq(DerValue derValue, EncryptionKey encryptionKey) throws KrbException, IOException {
        this.b = derValue.toByteArray();
        if (this.g == null) {
            this.a(derValue);
        }
        this.a(encryptionKey, null);
    }

    public KrbApReq(APOptions aPOptions, Credentials credentials, Checksum checksum, EncryptionKey encryptionKey, SeqNumber seqNumber, AuthorizationData authorizationData) throws KrbException, IOException {
        this.a(aPOptions, credentials, checksum, encryptionKey, seqNumber, authorizationData);
    }

    public KrbApReq(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.a(aPOptions, ticket, encryptionKey, realm, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData);
    }

    KrbApReq(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData, int n2) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.a(aPOptions, ticket, encryptionKey, realm, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData, n2);
        this.b = this.g.asn1Encode();
    }

    public KrbApReq(byte[] byArray, Credentials credentials, HostAddress hostAddress) throws KrbException, IOException {
        if (byArray == null) {
            I18NException.throwIllegalArgumentException(KrbApReq.a("\u001e$\u0017L(5 \u000eE\t$"));
        }
        if (credentials == null && (credentials = Credentials.getServiceCreds((String)null, (File)null)) == null) {
            throw new KrbException(45, KrbApReq.a("\u001e>?E\u001c1$\u0017T9\"4\u001f"), null);
        }
        this.b = byArray;
        this.a(new DerValue(byArray));
        this.a(credentials, hostAddress);
    }

    private void a(APOptions aPOptions, Credentials credentials, Checksum checksum, EncryptionKey encryptionKey, SeqNumber seqNumber, AuthorizationData authorizationData) throws KrbException, IOException {
        this.c = new KerberosTime(true);
        this.a(aPOptions, credentials.a, credentials.d, credentials.b.getRealm(), credentials.b, checksum, this.c, encryptionKey, seqNumber, authorizationData);
    }

    private void a(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.b(aPOptions, ticket, encryptionKey, realm, principalName, checksum, kerberosTime, encryptionKey2, seqNumber, authorizationData);
        this.b = this.g.asn1Encode();
    }

    void a() throws KrbException, IOException {
        DerValue derValue = new DerValue(this.b);
        this.a(derValue);
    }

    void a(DerValue derValue) throws KrbException, IOException {
        this.g = null;
        try {
            this.g = new APReq(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            this.g = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.eText.charAt(kRBError.eText.length() - 1) == '\u0000' ? kRBError.eText.substring(0, kRBError.eText.length() - 1) : kRBError.eText;
            throw new KrbException(kRBError.errorCode, string, true);
        }
    }

    void a(EncryptionKey encryptionKey, HostAddress hostAddress) throws KrbException, IOException {
        String string;
        Ticket ticket = this.g.getTicket();
        byte[] byArray = null;
        byte[] byArray2 = null;
        boolean bl2 = EncryptedData.isDesEncType(encryptionKey.getEType());
        if (bl2) {
            byArray = ticket.getEncryptedPart().decrypt(encryptionKey, 2);
            byArray2 = ticket.getEncryptedPart().reset(byArray, true);
        } else {
            byArray2 = ticket.getEncryptedPart().decrypt(encryptionKey, 2);
        }
        this.h = new EncTicketPart(byArray2);
        EncryptionKey encryptionKey2 = this.h.getEncryptionKey();
        EncryptedData encryptedData = this.g.getEncryptedAuthenticator();
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (bl2) {
            byArray3 = encryptedData.decrypt(encryptionKey2, 11);
            byArray4 = encryptedData.reset(byArray3, true);
        } else {
            byArray4 = encryptedData.decrypt(encryptionKey2, 11);
        }
        this.e = new Authenticator(byArray4);
        this.c = this.e.getTime();
        this.d = this.e.getMicroSeconds();
        this.c.setMicroSeconds(this.d);
        this.e.getClient().setRealm(this.e.getRealm());
        ticket.getServer().setRealm(ticket.getRealm());
        this.h.getClient().setRealm(this.h.getClientRealm());
        Config.getInstance().resetDefaultRealm(ticket.getRealm().toString());
        if (!this.e.getClient().equals(this.h.getClient())) {
            throw new KrbApErrException(36);
        }
        if (!this.e.getTime().inClockSkew()) {
            throw new KrbApErrException(37);
        }
        a a2 = new a(this.c.getTime(), this.d);
        if (a.a(a2, string = this.e.getClient().toString()) != null) {
            throw new KrbApErrException(34);
        }
        a.a(string, a2);
        HostAddresses hostAddresses = this.h.getClientAddresses();
        if (hostAddress != null && hostAddresses != null) {
            if (hostAddress == null) {
                throw new KrbApErrException(38);
            }
            if (!hostAddresses.inList(hostAddress)) {
                throw new KrbApErrException(38);
            }
        }
        KerberosTime kerberosTime = new KerberosTime(true);
        KerberosTime kerberosTime2 = this.h.getStartTime();
        KerberosTime kerberosTime3 = this.h.getEndTime();
        if (kerberosTime2 != null && kerberosTime2.greaterThanWRTClockSkew(kerberosTime) || this.h.getTicketFlags().get(7)) {
            throw new KrbApErrException(33);
        }
        if (kerberosTime3 != null && kerberosTime.greaterThanWRTClockSkew(kerberosTime3)) {
            throw new KrbApErrException(32);
        }
        this.f = new Credentials(ticket, this.e.getClient(), ticket.getServer(), encryptionKey2, null, this.h.getAuthTime(), kerberosTime2, kerberosTime3, this.h.getRenewableTillTime(), hostAddresses);
        if (Krb5Debug.on(9)) {
            Krb5Debug krb5Debug = new Krb5Debug(KrbApReq.a("\u001b#\u0019a\n\u00024\n\u001a") + Thread.currentThread().getName() + KrbApReq.a("jq"));
            krb5Debug.out(9, KrbApReq.a("noE\u00001\"3:P(5 A\u0000\u001b%%\u0013E\u0014$8\u0018A\u000e5q\bU\u001934\u001eD\u001f4\u007f"));
        }
    }

    public Credentials getCreds() {
        return this.f;
    }

    KerberosTime b() {
        if (this.c != null) {
            return this.c;
        }
        return this.e.getTime();
    }

    int c() {
        return this.d;
    }

    APOptions d() throws KrbException, IOException {
        if (this.g == null) {
            this.a();
        }
        if (this.g != null) {
            return this.g.getOptions();
        }
        return null;
    }

    public boolean getMutualAuthRequired() throws KrbException, IOException {
        if (this.g == null) {
            this.a();
        }
        if (this.g != null) {
            return this.g.getOptions().get(2);
        }
        return false;
    }

    boolean e() throws KrbException, IOException {
        if (this.g == null) {
            this.a();
        }
        if (this.g != null) {
            return this.g.getOptions().get(1);
        }
        return false;
    }

    public EncryptionKey getSubKey() {
        return this.e.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.e.getSeqNumber();
    }

    public Checksum getChecksum() {
        return this.e.getChecksum();
    }

    public byte[] getMessage() {
        return this.b;
    }

    public PrincipalName getClient() {
        return this.f.getClient();
    }

    private void b(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n2 = null;
        if (seqNumber != null) {
            n2 = new Integer(seqNumber.current());
        }
        this.e = new Authenticator(realm, principalName, checksum, kerberosTime.getMicroSeconds(), kerberosTime, encryptionKey2, n2, authorizationData);
        byte[] byArray = this.e.asn1Encode();
        EncryptedData encryptedData = null;
        encryptedData = EncryptedData.isDesEncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 11) : new EncryptedData(encryptionKey, byArray, 11);
        this.g = new APReq(aPOptions, ticket, encryptedData);
    }

    private void a(APOptions aPOptions, Ticket ticket, EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, Checksum checksum, KerberosTime kerberosTime, EncryptionKey encryptionKey2, SeqNumber seqNumber, AuthorizationData authorizationData, int n2) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n3 = null;
        if (seqNumber != null) {
            n3 = new Integer(seqNumber.current());
        }
        this.e = new Authenticator(realm, principalName, checksum, kerberosTime.getMicroSeconds(), kerberosTime, encryptionKey2, n3, authorizationData);
        byte[] byArray = this.e.asn1Encode();
        EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, n2);
        this.g = new APReq(aPOptions, ticket, encryptedData);
    }

    private void a(Credentials credentials, HostAddress hostAddress) throws KrbException, IOException {
        Ticket ticket = this.g.getTicket();
        int n2 = ticket.getEncryptedPart().getEType();
        EncryptionKey encryptionKey = credentials.getServiceKey(n2);
        if (encryptionKey == null) {
            throw new KrbException(45, KrbApReq.a("\u001e>0E\u0003\u0004(\u000bE"), (Object[])new Integer[]{new Integer(n2)});
        }
        this.a(encryptionKey, hostAddress);
    }

    public EncTicketPart getEncTicketPart() {
        return this.h;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 80;
                        break;
                    }
                    case 1: {
                        n5 = 81;
                        break;
                    }
                    case 2: {
                        n5 = 123;
                        break;
                    }
                    case 3: {
                        n5 = 32;
                        break;
                    }
                    default: {
                        n5 = 122;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

