/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class KMFilenameFilter
extends FileFilter {
    private Hashtable filters = null;
    private String description = null;
    private String fullDescription = null;

    public KMFilenameFilter(String string, String string2) {
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.description = string2;
            this.fullDescription = null;
        }
    }

    public KMFilenameFilter(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("")) {
                this.addExtension(stringArray[n]);
            }
            ++n;
        }
        if (string != null) {
            this.description = string;
            this.fullDescription = null;
        }
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            this.fullDescription = this.description == null ? "(" : this.description + " (";
            Enumeration enumeration = this.filters.keys();
            if (enumeration != null) {
                this.fullDescription = this.fullDescription + "*." + (String)enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    this.fullDescription = this.fullDescription + ", " + (String)enumeration.nextElement();
                }
            }
            this.fullDescription = this.fullDescription + ")";
        }
        return this.fullDescription;
    }
}

