/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.NetscapeCertTypeExtension;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.KeyStoreManager;
import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class SunSecurityUtil {
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    public static String getBeginCert() {
        return "";
    }

    public static String getEndCert() {
        return "";
    }

    public static void checkTrustedChain(Certificate[] certificateArray) throws CertificateException {
        for (int i = 0; i < certificateArray.length && !KeyStoreManager.isCertificateTrusted(certificateArray[i]); ++i) {
            try {
                SunSecurityUtil.checkExtensions((X509Certificate)certificateArray[i], i);
            }
            catch (Exception exception) {
                if (Globals.TraceSecurity) {
                    Debug.println("failed extension check: " + certificateArray[i]);
                    Debug.println("exception was: " + exception);
                }
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                throw new CertificateException("failed extensions check");
            }
            int n = i < certificateArray.length - 1 ? i + 1 : i;
            Principal principal = ((X509Certificate)certificateArray[i]).getIssuerDN();
            Principal principal2 = ((X509Certificate)certificateArray[n]).getSubjectDN();
            if (!((Object)principal2).equals(principal)) {
                throw new CertificateException("Incomplete certificate chain");
            }
            PublicKey publicKey = certificateArray[n].getPublicKey();
            try {
                certificateArray[i].verify(publicKey);
                continue;
            }
            catch (Exception exception) {
                if (Globals.TraceSecurity) {
                    Debug.println("exception checking extensions: " + exception);
                }
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                throw new CertificateException("Invalid certificate chain");
            }
        }
        if (Globals.TraceSecurity) {
            Debug.println("certificate chain validated");
        }
    }

    private static void checkExtensions(X509Certificate x509Certificate, int n) throws CertificateException, IOException {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        SunSecurityUtil.checkBasicConstraints(x509Certificate, set, n);
        if (n == 0) {
            SunSecurityUtil.checkLeafKeyUsage(x509Certificate, set);
        } else {
            SunSecurityUtil.checkSignerKeyUsage(x509Certificate, set);
        }
        if (!set.isEmpty()) {
            throw new CertificateException("Certificate contains unknown critical extensions: " + set);
        }
    }

    private static void checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException, IOException {
        set.remove(OID_BASIC_CONSTRAINTS);
        set.remove(OID_NETSCAPE_CERT_TYPE);
        if (n == 0) {
            return;
        }
        if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null) {
                throw new CertificateException("CA certificate does not include basic constraints extension or netscape cert type extension");
            }
            if (!SunSecurityUtil.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
                throw new CertificateException("Invalid Netscape CertType extension");
            }
        } else {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (SunSecurityUtil.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA) || SunSecurityUtil.getNetscapeCertTypeBit(x509Certificate, NSCT_S_MIME_CA)) && !SunSecurityUtil.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
                throw new CertificateException("Invalid Netscape CertType extension");
            }
            int n2 = x509Certificate.getBasicConstraints();
            if (n2 < 0) {
                throw new CertificateException("End user tried to act as a CA");
            }
            if (n - 1 > n2) {
                throw new CertificateException("Violated path length constraints");
            }
        }
    }

    private static void checkLeafKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        List list;
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                throw new CertificateException("Invalid key usage extension.");
            }
            boolean bl = blArray[0];
            if (!bl) {
                throw new CertificateException("Wrong key usage. Expected digitalSignature.");
            }
        }
        if ((list = SunSecurityUtil.getExtendedKeyUsage(x509Certificate)) != null && set.contains(OID_EXTENDED_KEY_USAGE) && !list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
            throw new CertificateException("Extended key usage does not permit use");
        }
        set.remove(OID_EXTENDED_KEY_USAGE);
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && !SunSecurityUtil.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING)) {
            throw new CertificateException("Invalid Netscape CertType extension");
        }
    }

    private static void checkSignerKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            throw new CertificateException("Wrong key usage: expect keyCertSign");
        }
        List list = SunSecurityUtil.getExtendedKeyUsage(x509Certificate);
        if (list != null && set.contains(OID_EXTENDED_KEY_USAGE) && !list.contains(OID_EKU_ANY_USAGE)) {
            throw new CertificateException("Extended key usage in CA certificates must include anyExtendedKeyUsage");
        }
        set.remove(OID_EXTENDED_KEY_USAGE);
    }

    private static List getExtendedKeyUsage(X509Certificate x509Certificate) throws CertificateException, IOException {
        Object object;
        byte[] byArray = x509Certificate.getExtensionValue(OID_EXTENDED_KEY_USAGE);
        if (byArray == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        DerValue derValue = new DerValue(byArray2);
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>(1, 1);
        while (derValue.getData().available() != 0) {
            object = derValue.getData().getDerValue();
            ObjectIdentifier objectIdentifier = object.getOID();
            vector.addElement(objectIdentifier);
        }
        object = new ArrayList(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            ((ArrayList)object).add(vector.elementAt(i).toString());
        }
        return object;
    }

    private static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }
}

