/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.Permission;

public abstract class ExAuthenticator {
    private static ExAuthenticator theAuthenticator;
    private String requestingHost;
    private InetAddress requestingSite;
    private int requestingPort;
    private String requestingProtocol;
    private String requestingPrompt;
    private String requestingScheme;
    private URL requestingURL;
    private int requestingAuthType;
    public static final int PROXY = 0;
    public static final int SERVER = 1;

    private void reset() {
        this.requestingHost = null;
        this.requestingSite = null;
        this.requestingPort = -1;
        this.requestingProtocol = null;
        this.requestingPrompt = null;
        this.requestingScheme = null;
        this.requestingURL = null;
        this.requestingAuthType = 1;
    }

    public static synchronized void setDefault(ExAuthenticator exAuthenticator) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            NetPermission netPermission = new NetPermission("setDefaultAuthenticator");
            securityManager.checkPermission(netPermission);
        }
        theAuthenticator = exAuthenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((ExAuthenticator)object).requestingSite = inetAddress;
            ((ExAuthenticator)object).requestingPort = n;
            ((ExAuthenticator)object).requestingProtocol = string;
            ((ExAuthenticator)object).requestingPrompt = string2;
            ((ExAuthenticator)object).requestingScheme = string3;
            return ((ExAuthenticator)object).getPasswordAuthentication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n, String string2, String string3, String string4) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((ExAuthenticator)object).requestingHost = string;
            ((ExAuthenticator)object).requestingSite = inetAddress;
            ((ExAuthenticator)object).requestingPort = n;
            ((ExAuthenticator)object).requestingProtocol = string2;
            ((ExAuthenticator)object).requestingPrompt = string3;
            ((ExAuthenticator)object).requestingScheme = string4;
            return ((ExAuthenticator)object).getPasswordAuthentication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n, String string2, String string3, String string4, URL uRL, int n2) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((ExAuthenticator)object).requestingHost = string;
            ((ExAuthenticator)object).requestingSite = inetAddress;
            ((ExAuthenticator)object).requestingPort = n;
            ((ExAuthenticator)object).requestingProtocol = string2;
            ((ExAuthenticator)object).requestingPrompt = string3;
            ((ExAuthenticator)object).requestingScheme = string4;
            ((ExAuthenticator)object).requestingURL = uRL;
            ((ExAuthenticator)object).requestingAuthType = n2;
            return ((ExAuthenticator)object).getPasswordAuthentication();
        }
    }

    protected final String getRequestingHost() {
        return this.requestingHost;
    }

    protected final InetAddress getRequestingSite() {
        return this.requestingSite;
    }

    protected final int getRequestingPort() {
        return this.requestingPort;
    }

    protected final String getRequestingProtocol() {
        return this.requestingProtocol;
    }

    protected final String getRequestingPrompt() {
        return this.requestingPrompt;
    }

    protected final String getRequestingScheme() {
        return this.requestingScheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }

    protected URL getRequestingURL() {
        return this.requestingURL;
    }

    protected int getRequestorType() {
        return this.requestingAuthType;
    }

    public static synchronized ExAuthenticator getDefault() {
        return theAuthenticator;
    }
}

