/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.security.action.LoadLibraryAction;

public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static Vector inflaters;
    private static final Class ZipFileInputStreamClass;

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        this.jzfile = ZipFile.open(string, n, file.lastModified());
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    private static native long open(String var0, int var1, long var2);

    private static native int getTotal(long var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        long l = ZipFile.getEntry(this.jzfile, string);
        if (l != 0L) {
            ZipEntry zipEntry = new ZipEntry(string, l);
            ZipFile.freeEntry(this.jzfile, l);
            return zipEntry;
        }
        return null;
    }

    private static native long getEntry(long var0, String var2);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.ensureOpen(this.jzfile);
        long l = ZipFile.getEntry(this.jzfile, string);
        if (l == 0L) {
            return null;
        }
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(this.jzfile, l, this);
        switch (ZipFile.getMethod(l)) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new InflaterInputStream(zipFileInputStream, this.getInflater()){
                    private boolean isClosed;
                    private boolean eof;
                    {
                        this.isClosed = false;
                    }

                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }

                    public int available() throws IOException {
                        if (super.available() != 0) {
                            return this.in.available();
                        }
                        return 0;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    private static native int getMethod(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = inflaters;
        synchronized (vector) {
            int n = inflaters.size();
            if (n > 0) {
                Inflater inflater = (Inflater)inflaters.remove(n - 1);
                inflater.reset();
                return inflater;
            }
        }
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = inflaters;
        synchronized (vector) {
            if (inflaters.size() < 5) {
                inflaters.add(inflater);
            } else {
                inflater.end();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration entries() {
        this.ensureOpen(this.jzfile);
        return new Enumeration(){
            private int i = 0;

            public boolean hasMoreElements() {
                ZipFile.this.ensureOpen(ZipFile.this.jzfile);
                return this.i < ZipFile.this.total;
            }

            public Object nextElement() throws NoSuchElementException {
                ZipFile.this.ensureOpen(ZipFile.this.jzfile);
                if (this.i >= ZipFile.this.total) {
                    throw new NoSuchElementException();
                }
                long l = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                if (l == 0L) {
                    String string = ZipFile.this.jzfile == 0L ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                    throw new InternalError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                }
                ZipEntry zipEntry = new ZipEntry(l);
                ZipFile.freeEntry(ZipFile.this.jzfile, l);
                return zipEntry;
            }
        };
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        return this.total;
    }

    public void close() throws IOException {
        long l = this.jzfile;
        if (l != 0L) {
            this.jzfile = 0L;
            ZipFile.close(l);
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen(long l) {
        if (l == 0L) {
            throw new IllegalStateException("zip file closed");
        }
    }

    private static native int read(long var0, long var2, int var4, byte[] var5, int var6, int var7);

    private static native int getCSize(long var0);

    private static native int getSize(long var0);

    private static native String getZipMessage(long var0);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
        ZipFile.initIDs();
        inflaters = new Vector();
        ZipFileInputStreamClass = ZipFileInputStream.class;
    }

    private class ZipFileInputStream
    extends InputStream {
        private long jzfile;
        private long jzentry;
        private int pos;
        private int rem;
        private int size;
        private ZipFile handle;

        ZipFileInputStream(long l, long l2, ZipFile zipFile2) {
            this.jzentry = l2;
            this.pos = 0;
            this.rem = ZipFile.getCSize(l2);
            this.size = ZipFile.getSize(l2);
            this.handle = zipFile2;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.rem == 0) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if (n2 > this.rem) {
                n2 = this.rem;
            }
            if (ZipFile.this.jzfile == 0L) {
                throw new ZipException("ZipFile closed.");
            }
            n2 = ZipFile.read(ZipFile.this.jzfile, this.jzentry, this.pos, byArray, n, n2);
            if (n2 > 0) {
                this.pos += n2;
                this.rem -= n2;
            }
            if (this.rem == 0) {
                this.cleanup();
            }
            return n2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public long skip(long l) {
            int n = l > (long)this.rem ? this.rem : (int)l;
            this.pos += n;
            this.rem -= n;
            if (this.rem == 0) {
                this.cleanup();
            }
            return n;
        }

        public int available() {
            return this.size;
        }

        private void cleanup() {
            this.rem = 0;
            if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                this.jzentry = 0L;
            }
        }

        public void close() {
            this.cleanup();
        }
    }
}

