/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.zseries;

import com.ibm.jvm.zseries.Engine;
import com.ibm.jvm.zseries.Instruction;

public abstract class RXInstruction
extends Instruction {
    int word;

    RXInstruction(Engine engine, int n) {
        this.engine = engine;
        this.word = n;
    }

    public int length() {
        return 4;
    }

    int r1() {
        return this.word >> 20 & 0xF;
    }

    int x2() {
        return this.word >> 16 & 0xF;
    }

    int b2() {
        return this.word >> 12 & 0xF;
    }

    int d2() {
        return this.word & 0xFFF;
    }

    int address() throws Exception {
        int n = 0;
        if (this.x2() != 0) {
            if (this.engine.validRegister(this.x2())) {
                n = this.engine.getRegister(this.x2());
            } else {
                throw new Exception("bad address");
            }
        }
        if (this.engine.validRegister(this.b2())) {
            return n + this.engine.getRegister(this.b2()) + this.d2();
        }
        throw new Exception("bad address");
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public String toString() {
        String string = this.x2() == 0 ? "" : "$r" + this.x2() + ",";
        String string2 = this.isFloatingPoint() ? "$fpr" : "$r";
        return this.mnemonic() + "   " + string2 + this.r1() + ", x'" + RXInstruction.hx(this.d2()) + "'(" + string + "$r" + this.b2() + ")";
    }
}

