/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.StrongComponentsGraph;
import com.ibm.jvm.util.IntegerArray;

public class PrintComponents
extends PrintBase {
    StrongComponentsGraph sc;
    IntegerArray dagIndexes = new IntegerArray();
    IntegerArray vertexIds = new IntegerArray();

    public static void main(String[] stringArray) {
        PrintComponents printComponents = new PrintComponents();
        printComponents.start(stringArray, "PrintComponents");
    }

    String[] options() {
        return new String[]{"-excludeobject <addr>", "-excludeclass <name>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tExclude object with this address (hex)", "\tExclude all objects of this class (eg java/lang/Object)"};
    }

    protected void parseEnd() {
        int n;
        super.parseEnd();
        this.sc = this.graph.findStrongComponents();
        this.sc.deleted.set(0);
        for (n = 0; n < this.graph.size; ++n) {
            this.dagIndexes.add(this.graph.dagIndex[n]);
            this.vertexIds.add(this.graph.vertexIds.get(n));
        }
        this.dagIndexes.sort(this.vertexIds);
        this.print(this);
        System.out.println("");
        System.out.println("Now print the contents of the strong components referred to by the #n above");
        for (n = 1; n < this.sc.size; ++n) {
            int n2;
            int n3 = this.sc.vertexIds.get(n);
            int n4 = this.sc.dagSizes.get(n);
            if (n4 == 1) continue;
            for (n2 = this.dagIndexes.indexOf(n); n2 > 0 && this.dagIndexes.get(n2 - 1) == n; --n2) {
            }
            System.out.println("");
            System.out.println("*** #" + n3 + " ***");
            System.out.println("");
            for (int i = 0; i < n4; ++i) {
                int n5 = this.vertexIds.get(n2 + i);
                System.out.println("0x" + PrintComponents.hex(n5) + " " + super.getName(n5));
            }
        }
    }

    int reachability(int n) {
        return this.sc.reach[n];
    }

    public void print(PrintClient printClient) {
        for (int i = 0; i < this.maxroots(); ++i) {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (i > 0) {
                System.out.println("");
            }
            System.out.println("*** doing root " + i + " ***");
            System.out.println("");
            this.sc.transitiveClosure();
            this.log("after trans closure");
            for (n = 0; n < this.sc.vertexIds.size(); ++n) {
                int n4 = this.sc.reach[n];
                if (n4 <= n3) continue;
                n3 = n4;
                n2 = n;
            }
            if (n3 == 0) {
                this.log("no more roots!");
                break;
            }
            n = this.sc.vertexIds.get(n2);
            this.log("max reach = " + n3 + " for vertex " + PrintComponents.hex(n) + " " + printClient.getName(n));
            this.printTree(this.sc, n2);
            this.sc.deleteTree(n2);
        }
    }

    public String getName(int n) {
        if (this.sc == null) {
            return super.getName(n);
        }
        int n2 = this.sc.idToIndex(n);
        int n3 = this.sc.dagSizes.get(n2);
        if (n3 == 1) {
            n = this.vertexIds.get(this.dagIndexes.indexOf(n2));
            return "0x" + PrintComponents.hex(n) + " " + super.getName(n);
        }
        return "#" + n + " " + n3;
    }
}

