/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvFormatAs;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.plugins.DvBaseCommandsGui;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmdsGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DvMemoryScroller
implements ActionListener,
MouseListener,
MouseMotionListener {
    long current;
    Dvifm theIFM = DvUtils.getTheIFM();
    JInternalFrame jif;
    DvConsole dvConsole;
    DvAddress currentAddr;
    long startMemoryAddr;
    long memorySize;
    JTextArea jtext;
    int jtext_widthInPixels;
    int jtext_heightInPixels;
    JTextField jtext1;
    String memoryAsString;
    boolean bForcedAscii = false;
    boolean bForcedEbcdic = false;
    Font thisFont;
    JPanel panel;
    JPanel asciiEbcdicPanel;
    JButton asciiButton;
    JButton ebcdicButton;
    JPanel upButtonPanel;
    JPanel downButtonPanel;
    JButton oneLineUpBtn;
    JButton halfPageUpBtn;
    JButton onePageUpBtn;
    JButton oneLineDownBtn;
    JButton halfPageDownBtn;
    JButton onePageDownBtn;
    JButton goButton;
    JButton backButton;
    JButton forwardButton;
    JPopupMenu popup;
    JMenuItem formatAsData;
    JMenuItem formatAs;
    JMenuItem whatIs;
    JMenuItem launchNMW;
    String selectedMemory;
    Vector vBackAndForth;
    int backAndForthPos = 0;
    public static final int ONE_LINE = 16;
    public static final int HALF_PAGE = 128;
    public static final int ONE_PAGE = 256;

    public DvMemoryScroller(JInternalFrame jInternalFrame, DvConsole dvConsole) {
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.startMemoryAddr = 0L;
        this.currentAddr = new DvAddress(0L);
        this.memorySize = 512L;
        this.constructWindow(this.startMemoryAddr);
        if (DvConsole.theDump.getSystemType() == 4) {
            this.bForcedEbcdic = true;
            this.bForcedAscii = false;
        } else {
            this.bForcedEbcdic = false;
            this.bForcedAscii = true;
        }
        if (this.getMemoryDetails(this.currentAddr)) {
            this.displayMemory();
        } else {
            DvUtils.writetoTrace(" (A)Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
            this.jtext1.setText("Enter address");
        }
    }

    public DvMemoryScroller(JInternalFrame jInternalFrame, DvConsole dvConsole, DvAddress dvAddress, long l) {
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.currentAddr = dvAddress;
        this.startMemoryAddr = dvAddress.getAddressAsLong();
        this.memorySize = l;
        this.constructWindow(this.startMemoryAddr);
        if (DvConsole.theDump.getSystemType() == 4) {
            this.bForcedEbcdic = true;
            this.bForcedAscii = false;
        } else {
            this.bForcedEbcdic = false;
            this.bForcedAscii = true;
        }
        if (this.getMemoryDetails(this.currentAddr)) {
            this.displayMemory();
        } else {
            DvUtils.writetoTrace(" (B)Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
        }
    }

    private void constructWindow(long l) {
        Serializable serializable;
        this.thisFont = new Font("Monospaced", 0, 12);
        this.vBackAndForth = new Vector();
        this.vBackAndForth.add(Long.toHexString(l));
        this.backAndForthPos = 1;
        this.jtext = new JTextArea("", 8, 25);
        this.jtext.setEditable(false);
        this.jtext.setFont(this.thisFont);
        this.jtext.addMouseListener(this);
        this.jtext.addMouseMotionListener(this);
        try {
            serializable = this.jtext.getFontMetrics(this.thisFont);
            this.jtext_heightInPixels = ((FontMetrics)serializable).getHeight();
            this.jtext_widthInPixels = ((FontMetrics)serializable).stringWidth("AA") - ((FontMetrics)serializable).charWidth('A');
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.theIFM.addContentToFrame(this.jif, this.jtext, this.panel);
        this.upButtonPanel = new JPanel();
        this.downButtonPanel = new JPanel();
        serializable = new JPanel();
        this.asciiEbcdicPanel = new JPanel();
        this.jtext1 = new JTextField(Long.toHexString(l), 18);
        this.jtext1.setFont(this.thisFont);
        this.goButton = new JButton("GO!");
        this.backButton = new JButton("BACK");
        this.backButton.setToolTipText("Press this to go to previous screen in chain.");
        this.forwardButton = new JButton("FWD");
        this.forwardButton.setToolTipText("Press this to go to next screen in chain.");
        this.asciiButton = new JButton("A");
        this.ebcdicButton = new JButton("E");
        this.goButton.setToolTipText("Press this to go to address specified.");
        this.oneLineUpBtn = new JButton("<");
        this.halfPageUpBtn = new JButton("<<");
        this.onePageUpBtn = new JButton("<<<");
        this.oneLineDownBtn = new JButton(">");
        this.halfPageDownBtn = new JButton(">>");
        this.onePageDownBtn = new JButton(">>>");
        this.oneLineUpBtn.setToolTipText("Click to move one line back in memory.");
        this.halfPageUpBtn.setToolTipText("Click to move half a page back in memory.");
        this.onePageUpBtn.setToolTipText("Click to move one page back in memory.");
        this.oneLineDownBtn.setToolTipText("Click to move one line forward in memory.");
        this.halfPageDownBtn.setToolTipText("Click to move half a page forward in memory.");
        this.onePageDownBtn.setToolTipText("Click to move one a page forward in memory.");
        this.oneLineUpBtn.addActionListener(this);
        this.halfPageUpBtn.addActionListener(this);
        this.onePageUpBtn.addActionListener(this);
        this.oneLineDownBtn.addActionListener(this);
        this.halfPageDownBtn.addActionListener(this);
        this.onePageDownBtn.addActionListener(this);
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.upButtonPanel.add(this.oneLineUpBtn);
        this.upButtonPanel.add(this.halfPageUpBtn);
        this.upButtonPanel.add(this.onePageUpBtn);
        this.downButtonPanel.add(this.onePageDownBtn);
        this.downButtonPanel.add(this.halfPageDownBtn);
        this.downButtonPanel.add(this.oneLineDownBtn);
        ((Container)serializable).add(this.backButton);
        ((Container)serializable).add(this.forwardButton);
        ((Container)serializable).add(this.jtext1);
        ((Container)serializable).add(this.goButton);
        this.goButton.addActionListener(this);
        this.asciiEbcdicPanel.add(this.asciiButton);
        this.asciiEbcdicPanel.add(this.ebcdicButton);
        this.asciiButton.addActionListener(this);
        this.ebcdicButton.addActionListener(this);
        if (this.bForcedEbcdic) {
            this.asciiButton.setEnabled(true);
            this.ebcdicButton.setEnabled(false);
        } else {
            this.asciiButton.setEnabled(false);
            this.ebcdicButton.setEnabled(true);
        }
        this.panel.add((Component)this.asciiEbcdicPanel, "Center");
        this.panel.add((Component)this.upButtonPanel, "West");
        this.panel.add((Component)this.downButtonPanel, "East");
        this.panel.add((Component)serializable, "South");
    }

    private boolean getMemoryDetails(DvAddress dvAddress) {
        DvUtils.writetoTrace(" getMemoryDetails(DvAddress addr ) entry");
        boolean bl = true;
        this.memoryAsString = "";
        Vector vector = new Vector();
        Dumpviewer.savedDvbc.paramString = dvAddress.convertToHex() + "," + 256;
        Dumpviewer.savedDvbc.paramString = true == this.bForcedAscii ? Dumpviewer.savedDvbc.paramString + ",A" : Dumpviewer.savedDvbc.paramString + ",E";
        Dumpviewer.savedDvbc.displayMemory(vector);
        if (vector.size() != 0) {
            Object e = vector.get(0);
            if (e instanceof Vector) {
                vector = (Vector)e;
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object e2 = vector.get(i);
                if (i == 0 && ((String)e2).startsWith("Not")) {
                    return false;
                }
                this.memoryAsString = this.memoryAsString + (String)e2 + "\n";
            }
            StringBuffer stringBuffer = new StringBuffer(this.memoryAsString);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.deleteCharAt(0);
            this.memoryAsString = stringBuffer.toString();
        } else {
            Dumpviewer.savedConsoleOutput.clear();
            bl = false;
        }
        Dumpviewer.savedConsoleOutput.clear();
        DvUtils.writetoTrace(" getMemoryDetails(DvAddress addr ) exit -" + (bl ? "true" : "false"));
        return bl;
    }

    private void displayMemory() {
        String string = this.currentAddr.convertToHex();
        String string2 = "Memory Scroller " + string;
        DvUtils.writetoTrace(" Into displayMemory (" + string2 + ")");
        this.jif.setTitle(string2);
        this.jtext.setText(this.memoryAsString);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        if (actionEvent.getSource() == this.oneLineUpBtn) {
            DvUtils.writetoTrace("OneLineUpBtn pressed in Memory Scroller");
            l -= 16L;
        } else if (actionEvent.getSource() == this.halfPageUpBtn) {
            DvUtils.writetoTrace("halfPageUpBtn pressed in Memory Scroller");
            l -= 128L;
        } else if (actionEvent.getSource() == this.onePageUpBtn) {
            DvUtils.writetoTrace("onePageUpBtn pressed in Memory Scroller");
            l -= 256L;
        } else if (actionEvent.getSource() == this.oneLineDownBtn) {
            DvUtils.writetoTrace("oneLineDownBtn pressed in Memory Scroller");
            l += 16L;
        } else if (actionEvent.getSource() == this.halfPageDownBtn) {
            DvUtils.writetoTrace("halfPageDownBtn pressed in Memory Scroller");
            l += 128L;
        } else if (actionEvent.getSource() == this.onePageDownBtn) {
            DvUtils.writetoTrace("onePageDownBtn pressed in Memory Scroller");
            l += 256L;
        } else if (actionEvent.getSource() == this.goButton) {
            DvUtils.writetoTrace("goButton pressed in Memory Scroller (" + this.jtext1.getText());
            String string = this.jtext1.getText();
            DvUtils.writetoTrace("goButton pressed in Memory Scroller (" + string + ")");
            bl = true;
            bl2 = true;
            l = 256L;
        } else if (actionEvent.getSource() == this.asciiButton) {
            DvUtils.writetoTrace("asciiButton pressed in Memory Scroller (" + this.jtext1.getText());
            String string = this.jtext1.getText();
            DvUtils.writetoTrace("asciiButton pressed in Memory Scroller (" + string + ")");
            this.bForcedAscii = true;
            this.bForcedEbcdic = false;
            this.asciiButton.setEnabled(false);
            this.ebcdicButton.setEnabled(true);
        } else if (actionEvent.getSource() == this.ebcdicButton) {
            DvUtils.writetoTrace("ebcdicButton pressed in Memory Scroller (" + this.jtext1.getText());
            String string = this.jtext1.getText();
            DvUtils.writetoTrace("ebcdicButton pressed in Memory Scroller (" + string + ")");
            this.bForcedAscii = false;
            this.bForcedEbcdic = true;
            this.asciiButton.setEnabled(true);
            this.ebcdicButton.setEnabled(false);
        } else if (actionEvent.getSource() == this.formatAsData) {
            DvUtils.writetoTrace("Format as Data  selected from popup ");
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            String string = DvFormatAs.formatAsData(this.selectedMemory, dvAddressSpace);
            JInternalFrame jInternalFrame = DvBaseFmtCmdsGui.setupFormatFrame(string, "Data for address:" + this.selectedMemory, "Formatted as DATA");
        } else if (actionEvent.getSource() == this.formatAs) {
            DvUtils.writetoTrace("Format As ...  selected from popup ");
            long l2 = Long.parseLong(this.selectedMemory, 16);
            JInternalFrame jInternalFrame = this.theIFM.createNewFrame("Format As input", this.theIFM.getDefaultProperties(), 6);
            Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
            DvFormatAs dvFormatAs = new DvFormatAs(jInternalFrame, Dumpviewer.dvConsole, this.selectedMemory);
        } else if (actionEvent.getSource() == this.whatIs) {
            DvUtils.writetoTrace("whatis  selected from popup ");
            Vector vector = new Vector();
            Dumpviewer.savedDvbc.verbModifier = this.selectedMemory;
            Dumpviewer.savedDvbc.whatIs(vector);
            JTextArea jTextArea = new JTextArea(DvUtils.convertResponse(vector, false), 8, 25);
            JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame("Whatis " + this.selectedMemory, Dumpviewer.theIFM.getDefaultProperties(), 0);
            Dumpviewer.addIFrameToDesktop(jInternalFrame, 250, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
            jTextArea.setEditable(false);
            Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
        } else if (actionEvent.getSource() == this.launchNMW) {
            DvUtils.writetoTrace("Launch selected from popup ");
            long l3 = Long.parseLong(this.selectedMemory, 16);
            DvAddress dvAddress = new DvAddress(l3);
            DvBaseCommandsGui.displayMemory(dvAddress, 512L);
        } else if (actionEvent.getSource() == this.backButton) {
            DvUtils.writetoTrace(" ... backButton pressed ");
            if (1 != this.backAndForthPos) {
                --this.backAndForthPos;
                Object e = this.vBackAndForth.get(this.backAndForthPos - 1);
                this.jtext1.setText((String)e);
                bl = true;
            }
        } else if (actionEvent.getSource() == this.forwardButton) {
            DvUtils.writetoTrace(" ... forwardButton pressed ");
            if (this.backAndForthPos < this.vBackAndForth.size()) {
                Object e = this.vBackAndForth.get(this.backAndForthPos);
                ++this.backAndForthPos;
                this.jtext1.setText((String)e);
                bl = true;
            }
        } else {
            DvUtils.writetoTrace("Non recognised action in Memory Scroller");
            return;
        }
        if (!bl) {
            long l4 = this.currentAddr.getAddressAsLong();
            long l5 = l4 + l;
            try {
                this.currentAddr.offsetBy(l);
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace("Address out of Range");
            }
            DvUtils.writetoTrace("Memory Start = " + this.currentAddr.convertToHex());
            if (this.getMemoryDetails(this.currentAddr)) {
                this.vBackAndForth.set(this.backAndForthPos - 1, this.currentAddr.convertToHex());
                this.displayMemory();
            } else {
                DvUtils.writetoTrace(" (C)Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
                try {
                    this.currentAddr.offsetBy(-l);
                }
                catch (DvAddressException dvAddressException) {}
            }
        } else {
            this.doGoButton(bl2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n = mouseEvent.getClickCount();
        if (n > 2) {
            n = 2;
        }
        if (2 == n && !((mouseEvent.getModifiers() & 4) == 4) && (object = mouseEvent.getSource()) instanceof JTextArea) {
            DvUtils.writetoTrace("Double click detected in jtext ...");
            this.selectedMemory = this.getText(mouseEvent.getX(), mouseEvent.getY());
            if (null != this.selectedMemory) {
                boolean bl = false;
                try {
                    long l = Long.parseLong(this.selectedMemory, 16);
                    DvAddress dvAddress = new DvAddress(l);
                    DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
                    if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!bl) {
                    DvUtils.writetoTrace(" (D)Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
                    Dumpviewer.genericInfoMessage(this.selectedMemory + " is not an address in memory");
                } else {
                    this.jtext1.setText(this.selectedMemory);
                    this.doGoButton(true);
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 4) {
            DvUtils.writetoTrace("Right mouse button pressed");
            this.selectedMemory = this.getText(mouseEvent.getX(), mouseEvent.getY());
            if (null != this.selectedMemory) {
                DvUtils.writetoTrace("   ... popup menu displayed");
                this.formatAsData = new JMenuItem("\"Format " + this.selectedMemory + " as DATA\"");
                this.formatAsData.addActionListener(this);
                this.formatAs = new JMenuItem("\"Format as\" on " + this.selectedMemory);
                this.formatAs.addActionListener(this);
                this.whatIs = new JMenuItem("Whatis " + this.selectedMemory);
                this.whatIs.addActionListener(this);
                this.launchNMW = new JMenuItem("Launch new Memory Scroller ");
                this.launchNMW.addActionListener(this);
                this.popup = new JPopupMenu(this.selectedMemory);
                this.popup.add(this.formatAsData);
                this.popup.add(this.formatAs);
                this.popup.add(this.whatIs);
                this.popup.add(this.launchNMW);
                this.popup.setVisible(true);
                this.popup.show(this.jtext, mouseEvent.getX(), mouseEvent.getY() + this.jtext_heightInPixels);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private String getText(int n, int n2) {
        String string = null;
        int n3 = this.jtext_widthInPixels * 10;
        int n4 = this.jtext_widthInPixels * 46;
        if (Dumpviewer.is64BitDump) {
            n3 += 8 * this.jtext_widthInPixels;
            n4 += 8 * this.jtext_widthInPixels;
        }
        int n5 = 2;
        int n6 = 2 + this.jtext_heightInPixels * 16;
        if (n >= n3 && n <= n4 && n2 >= n5 && n2 <= n6) {
            int n7;
            n = (n - n3) / this.jtext_widthInPixels;
            n2 = (n2 - n5) / this.jtext_heightInPixels;
            String string2 = this.jtext.getText();
            n -= n % 9;
            if (Dumpviewer.is64BitDump) {
                n7 = 18 * (n2 + 1) + 55 * n2 + n;
                string = n7 < 1137 ? (n != 27 ? string2.substring(n7, n7 + 8) + string2.substring(n7 + 9, n7 + 17) : string2.substring(n7, n7 + 8) + string2.substring(n7 + 46, n7 + 54)) : string2.substring(n7 - 9, n7 - 1) + string2.substring(n7, n7 + 8);
            } else {
                n7 = 10 * (n2 + 1) + 55 * n2 + n;
                string = string2.substring(n7, n7 + 8);
            }
            if (!DvUtils.isBigEndian(DvConsole.theDump.getArchitecture())) {
                String string3 = new String(string);
                string = this.swapPointer(string3);
            }
        }
        return string;
    }

    private void doGoButton(boolean bl) {
        String string = this.jtext1.getText();
        long l = 0L;
        try {
            string = DvUtils.remove0x(string);
            l = Long.parseLong(string, 16);
            DvAddress dvAddress = new DvAddress(l);
            if (this.getMemoryDetails(dvAddress)) {
                this.currentAddr = dvAddress;
                this.startMemoryAddr = l;
                this.displayMemory();
                if (bl) {
                    if (this.backAndForthPos == this.vBackAndForth.size()) {
                        this.vBackAndForth.add(string);
                        if (100 == this.vBackAndForth.size()) {
                            Object[] objectArray = this.vBackAndForth.toArray();
                            this.vBackAndForth.clear();
                            for (int i = 0; i < 50; ++i) {
                                this.vBackAndForth.add(objectArray[i + 50]);
                                this.backAndForthPos = 50;
                            }
                        }
                        ++this.backAndForthPos;
                    } else {
                        for (int i = this.vBackAndForth.size() - 1; i >= this.backAndForthPos; --i) {
                            this.vBackAndForth.remove(i);
                        }
                        this.vBackAndForth.add(string);
                        this.backAndForthPos = this.vBackAndForth.size();
                    }
                }
            } else {
                DvUtils.writetoTrace(" (E)Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
                Dumpviewer.genericInfoMessage(string + " is not a valid address");
            }
        }
        catch (NumberFormatException numberFormatException) {
            Dumpviewer.genericInfoMessage(string + " is not a valid address");
            l = this.currentAddr.getAddressAsLong();
        }
    }

    private String swapPointer(String string) {
        String string2 = null;
        string2 = Dumpviewer.is64BitDump ? string.substring(14) + string.substring(12, 14) + string.substring(10, 12) + string.substring(8, 10) + string.substring(6, 8) + string.substring(4, 6) + string.substring(2, 4) + string.substring(0, 2) : string.substring(6) + string.substring(4, 6) + string.substring(2, 4) + string.substring(0, 2);
        return string2;
    }
}

