/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.AccessibilityListenerList;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class AccessibilityEventMonitor {
    protected static AccessibilityListenerList listenerList = new AccessibilityListenerList();
    protected static AccessibilityEventListener accessibilityListener = new AccessibilityEventListener();
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        if (listenerList.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = AccessibilityEventMonitor.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) == 0) {
            accessibilityListener.installListeners();
        }
        listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = AccessibilityEventMonitor.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = AccessibilityEventMonitor.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
        if (listenerList.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = AccessibilityEventMonitor.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) == 0) {
            accessibilityListener.removeListeners();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AccessibilityEventListener
    implements TopLevelWindowListener,
    PropertyChangeListener {
        public AccessibilityEventListener() {
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        protected void installListeners() {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                int i = 0;
                while (i < topLevelWindows.length) {
                    if (topLevelWindows[i] instanceof Accessible) {
                        this.installListeners(topLevelWindows[i]);
                    }
                    ++i;
                }
            }
        }

        protected void installListeners(Accessible a) {
            this.installListeners(a.getAccessibleContext());
        }

        private void installListeners(AccessibleContext ac) {
            AccessibleStateSet states;
            if (ac != null && !(states = ac.getAccessibleStateSet()).contains(AccessibleState.TRANSIENT)) {
                ac.addPropertyChangeListener(this);
                AccessibleRole ar = ac.getAccessibleRole();
                if (ar == AccessibleRole.TABLE || ar == AccessibleRole.LIST) {
                    return;
                }
                int count = ac.getAccessibleChildrenCount();
                int i = 0;
                while (i < count) {
                    Accessible child = ac.getAccessibleChild(i);
                    if (child != null) {
                        this.installListeners(child);
                    }
                    ++i;
                }
            }
        }

        protected void removeListeners() {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                int i = 0;
                while (i < topLevelWindows.length) {
                    if (topLevelWindows[i] instanceof Accessible) {
                        this.removeListeners(topLevelWindows[i]);
                    }
                    ++i;
                }
            }
        }

        protected void removeListeners(Accessible a) {
            this.removeListeners(a.getAccessibleContext());
        }

        private void removeListeners(AccessibleContext ac) {
            AccessibleStateSet states;
            if (ac != null && !(states = ac.getAccessibleStateSet()).contains(AccessibleState.TRANSIENT)) {
                ac.removePropertyChangeListener(this);
                int count = ac.getAccessibleChildrenCount();
                int i = 0;
                while (i < count) {
                    Accessible child = ac.getAccessibleChild(i);
                    if (child != null) {
                        this.removeListeners(child);
                    }
                    ++i;
                }
            }
        }

        public void topLevelWindowCreated(Window w) {
            if (w instanceof Accessible) {
                this.installListeners(w);
            }
        }

        public void topLevelWindowDestroyed(Window w) {
            if (w instanceof Accessible) {
                this.removeListeners(w);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object[] listeners = listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$java$beans$PropertyChangeListener == null ? AccessibilityEventMonitor.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                    ((PropertyChangeListener)listeners[i + 1]).propertyChange(e);
                }
                i -= 2;
            }
            String name = e.getPropertyName();
            if (name.compareTo("AccessibleChild") == 0) {
                Object newValue;
                Object oldValue = e.getOldValue();
                if (oldValue == null ^ (newValue = e.getNewValue()) == null) {
                    if (oldValue != null) {
                        if (oldValue instanceof Accessible) {
                            Accessible a = (Accessible)oldValue;
                            this.removeListeners(a.getAccessibleContext());
                        } else if (oldValue instanceof AccessibleContext) {
                            this.removeListeners((AccessibleContext)oldValue);
                        }
                    } else if (newValue != null) {
                        if (newValue instanceof Accessible) {
                            Accessible a = (Accessible)newValue;
                            this.installListeners(a.getAccessibleContext());
                        } else if (newValue instanceof AccessibleContext) {
                            this.installListeners((AccessibleContext)newValue);
                        }
                    }
                } else {
                    System.out.println("ERROR in usage of PropertyChangeEvents for: " + e.toString());
                }
            }
        }
    }
}

