/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyUtils;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.panel.TableKeyActions;
import sun.plugin.util.Trace;

public class ProxyPanel
extends ActivatorSubPanel
implements ActionListener,
KeyListener,
PropertyChangeListener,
TableModelListener {
    private JTable table;
    private JTextField proxyByPass = new JTextField();
    private JTextField autoProxyURL = new JTextField();
    private JCheckBox useDefault;
    private JLabel bypassLabel;
    private JLabel autoConfigLabel;
    private MessageHandler mh = new MessageHandler("proxy");

    public ProxyPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        Serializable serializable;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.useDefault = new JCheckBox(this.mh.getMessage("use_browser"));
        this.useDefault.addActionListener(this);
        jPanel.add(this.useDefault);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new EmptyBorder(4, 4, 4, 4));
        Object[] objectArray = new Object[]{this.mh.getMessage("proxy_protocol"), this.mh.getMessage("proxy_address"), this.mh.getMessage("proxy_port")};
        Object[][] objectArray2 = new Object[][]{{this.mh.getMessage("http"), null, null}, {this.mh.getMessage("https"), null, null}, {this.mh.getMessage("ftp"), null, null}, {this.mh.getMessage("gopher"), null, null}, {this.mh.getMessage("socks"), null, null}};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray){

            public boolean isCellEditable(int n, int n2) {
                if (n2 < 1) {
                    return false;
                }
                return super.isCellEditable(n, n2);
            }
        };
        this.table = new JTable(defaultTableModel);
        int n = this.table.getColumnModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            serializable = this.table.getColumnModel().getColumn(i);
            ((TableColumn)serializable).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof Component) {
                        component.getAccessibleContext().setAccessibleName(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                        component.getAccessibleContext().setAccessibleDescription(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                    }
                    return component;
                }
            });
        }
        this.table.getModel().addTableModelListener(this);
        this.table.setRowHeight(this.getFontMetrics(this.table.getFont()).getHeight());
        this.table.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.registerKeyboardAction(TableKeyActions.decColumnAction, KeyStroke.getKeyStroke(114, 0), 0);
        this.table.registerKeyboardAction(TableKeyActions.incColumnAction, KeyStroke.getKeyStroke(115, 0), 0);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jPanel2.add(jScrollPane);
        this.add(jPanel2);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        this.bypassLabel = new JLabel(this.mh.getMessage("bypass"));
        ((Container)serializable).add(this.bypassLabel);
        ((Container)serializable).add(this.proxyByPass);
        this.bypassLabel.setLabelFor(this.proxyByPass);
        ((JComponent)serializable).setBorder(new EmptyBorder(0, 5, 0, 5));
        this.proxyByPass.addKeyListener(this);
        this.add((Component)serializable);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.autoConfigLabel = new JLabel(this.mh.getMessage("autourl"));
        jPanel3.add(this.autoConfigLabel);
        jPanel3.add(this.autoProxyURL);
        this.autoConfigLabel.setLabelFor(this.autoProxyURL);
        jPanel3.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.autoProxyURL.addKeyListener(this);
        this.add(jPanel3);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.messagebox.font", this);
        this.reset();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FontMetrics fontMetrics = ProxyPanel.this.getFontMetrics(ProxyPanel.this.table.getFont());
                ProxyPanel.this.table.setRowHeight(fontMetrics.getHeight());
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.useDefault) {
            boolean bl = this.useDefault.isSelected();
            this.model.setDefaultProxySettings(bl);
            this.reset();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void reset() {
        boolean bl = this.model.useDefaultProxy();
        this.useDefault.setSelected(bl);
        boolean bl2 = !bl;
        this.setEnabled(this.table, bl2);
        this.setEnabled(this.proxyByPass, bl2);
        this.setEnabled(this.autoProxyURL, bl2);
        this.setEnabled(this.bypassLabel, bl2);
        this.setEnabled(this.autoConfigLabel, bl2);
        this.initProxySettings();
    }

    private void setProxySettings() {
        int n;
        Object object;
        this.model.setProxyByPass(this.proxyByPass.getText());
        this.model.setAutoProxyURL(this.autoProxyURL.getText());
        StringBuffer stringBuffer = new StringBuffer();
        TableModel tableModel = this.table.getModel();
        String string = (String)tableModel.getValueAt(0, 1);
        if (string != null && !string.equals("")) {
            stringBuffer.append("http=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(0, 2);
            try {
                if (object != null && (n = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(1, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("https=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(1, 2);
            try {
                if (object != null && (n = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(2, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("ftp=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(2, 2);
            try {
                int n2;
                if (object != null && (n2 = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(3, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("gopher=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(3, 2);
            try {
                int n3;
                if (object != null && (n3 = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(4, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("socks=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(4, 2);
            try {
                int n4;
                if (object != null && (n4 = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (((String)(object = stringBuffer.toString())).length() != 0) {
            this.model.setProxySettingsString((String)object);
        } else {
            this.model.setProxySettingsString(null);
        }
    }

    private void initProxySettings() {
        this.proxyByPass.setText(this.model.getProxyByPass());
        this.autoProxyURL.setText(this.model.getAutoProxyURL());
        String string = this.model.getProxySettingsString();
        if (string != null && string.length() != 0) {
            try {
                BrowserProxyInfo browserProxyInfo = new BrowserProxyInfo();
                ProxyUtils.parseProxyServer(string, browserProxyInfo);
                TableModel tableModel = this.table.getModel();
                tableModel.setValueAt(browserProxyInfo.getHttpHost(), 0, 1);
                if (browserProxyInfo.getHttpPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getHttpPort()), 0, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getHttpsHost(), 1, 1);
                if (browserProxyInfo.getHttpsPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getHttpsPort()), 1, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getFtpHost(), 2, 1);
                if (browserProxyInfo.getFtpPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getFtpPort()), 2, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getGopherHost(), 3, 1);
                if (browserProxyInfo.getGopherPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getGopherPort()), 3, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getSocksHost(), 4, 1);
                if (browserProxyInfo.getSocksPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getSocksPort()), 4, 2);
                }
            }
            catch (Exception exception) {
                Trace.printException(this, exception);
            }
        }
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setProxySettings();
    }
}

