#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2013 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:all);
use strict;

my ($time, $arg, $line, @contents,@title);
$arg=" ";

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
print "<font face=\"Courier, Helvetica\" height=\"10\" width=\"10\"";   # Force to mono-space

#! if parameter grep is set, call dlustat and grep on the '='
$arg=param('grep');
if ($arg=~/^dlustatactive/) {
    @title = "<b>CS Display Dependent LU Active status: $time </b><br>";
    @contents =  `../cscbin/dlustat.pl | /bin/grep =`;
} elsif ($arg=~/^dlustatTN3270/) {
    @title =  "<b>CS Display Active Dependent LU sessions: $time </b><br>";
    @contents = `../cscbin/dlustat.pl | /bin/grep = | /bin/grep -v Applic`;
} elsif ($arg=~/^dlustat/) {
    @title =  "<b>CS Display Dependent LU status: $time </b><br>";
    @contents =  `../cscbin/dlustat.pl`;
} elsif ($arg=~/^dlupool/) {
    @title = "<b>CS Display LU Pool status: $time </b><br>";
    @contents =  `../cscbin/dlupool.pl`;
} elsif ($arg=~/^hprlinks/) {
    @title = "<b>CS Link Station HPR Information: $time</b><br>";
    @contents=`../cscbin/cslinks.pl | /bin/grep -v " NONE "`;   # HPR Links only
} elsif ($arg=~/^cslinks/) {
    @title = "<b>CS Link Station Information: $time</b><br>";
    @contents=`../cscbin/cslinks.pl`;     # Command to get Link Station status
} elsif ($arg=~/^dpustat/) {
    @title = "<b>PU Status Information: $time</b><br>";
    @contents=`../cscbin/dpustat.pl`;     # Command to get PU status
} elsif ($arg=~/^rtpconn/) {
    @title = "<b>CS Display RTP Connection Summary: $time </b><br>";
    @contents =  `../cscbin/rtpconn.pl`;
} elsif ($arg=~/^sessconn/) {
    @title = "<b>CS Display Session Summary: $time </b><br>";
    @contents =  `../cscbin/sessconn.pl`;
} elsif ($arg=~/^sysname62/) {
    @title = "<b>Remote API Client mapping to Independent LU6.2: $time </b><br>";
    @contents =  `../cscbin/sysname62.pl`
} elsif ($arg=~/^tpdisplay/) {
    @title = "<b>Active Outbound Transaction Programs: $time </b><br>";
    @contents =  `../cscbin/tpdisplay.pl`
} elsif ($arg=~/^convdisplay/) {
    @title = "<b>Query Active Conversations: $time </b><br>";
    @contents =  `../cscbin/convdisplay.pl`
} elsif ($arg=~/^tnredirector/) {
    @title =  "<b>CS Display TN Redirector Sessions: $time </b><br>";
    @contents = `../cscbin/dtnredirect.pl`;
} else {
  @title =  " UNKNOWN COMMAND <br>";
}
#  Print title
foreach $line (@title) {
   chomp $line;
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
#Print output
foreach $line (@contents) {
   chomp $line;
#  On none active lines, print end of list in html format
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
print "</p></form></font>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

