#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_timeout, $arg_resource_name, $arg_resource_type, $resource_name, $resource_type, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_timeout=param('timeout_unique');

if ($arg_timeout eq "") {
    $arg_resource_name="";
    $arg_resource_type="GLOBAL_TIMEOUT";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #    Resource type
    print "<tr> <td>Resource type : </td> <td><select name=\"resource_type\"  class=\"rightAligned\" value=\"$arg_resource_type\" >  ";
    print "<option value=\"GLOBAL_TIMEOUT\" selected=\"selected\">GLOBAL_TIMEOUT</option> ";
    print "<option value=\"LOCAL_LU_TIMEOUT\">LOCAL_LU_TIMEOUT</option> ";
    print "<option value=\"PARTNER_LU_TIMEOUT\">PARTNER_LU_TIMEOUT</option> ";
    print "<option value=\"MODE_TIMEOUT\">MODE_TIMEOUT</option> </select></td></tr>";
    
    #    Name
    print "<tr> <td>Name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"resource_name\"  maxlength=\"17\" value=\"$arg_resource_name\" /></td></tr>";
    
    #   * Timeout
   print "<tr> <td>* Timeout(0-65535) :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"timeout_unique\"  maxlength=\"5\" value=\"$arg_timeout\" required=\"required\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";

    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
   $arg_resource_name=param('resource_name');
   $arg_timeout=param('timeout_unique');
   $arg_resource_type=param('resource_type');
    
    if ($arg_resource_name eq "") {
        $resource_name="";
    }else
    {
        $resource_name=",resource_name=$arg_resource_name";
    }
    

    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu62_timeout, timeout=$arg_timeout, resource_type=$arg_resource_type $resource_name`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu62_timeout, timeout=$arg_timeout, resource_type=$arg_resource_type $resource_name";
   
   print "<br> Display Output from Define LU 6.2 Session Timeout:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

