#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_sym_dest_name, $arg_lu_alias, $arg_partner_lu_name, $arg_description, $arg_mode_name, $arg_tp_name_type, $arg_tp_name, $arg_conversation_security_type, $arg_security_user_id, $arg_security_password, $description, $security_password, $security_user_id, $tp_name, $lu_alias, $partner_lu_name, $mode_name, $time, $line, @data, @contents, @plulist, @list,@modelist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_sym_dest_name=param('sym_dest_name_unique');

if ($arg_sym_dest_name eq "") {
    $arg_description="";
    $arg_lu_alias="";
    $arg_partner_lu_name="";
    $arg_mode_name="";
    $arg_tp_name_type="APPLICATION_TP";
    $arg_tp_name="";
    $arg_conversation_security_type="NONE";
    $arg_security_password="";
    $arg_security_user_id="";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/lu_alias/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_partner_lu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/fqplu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @plulist, $data[1];
            next;
        }
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_mode_definition`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/mode_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @modelist, $data[1];
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #  * Symbolic destination name
    print "<tr><td>* Symbolic destination name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"sym_dest_name_unique\" maxlength=\"8\" value=\"$arg_sym_dest_name\" required=\"required\" /></td></tr>";
    
    #  Description
    print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Local LU Alias
    print "<tr><td>Local LU Alias :</td> <td><select name=\"lu_alias\" class=\"rightAligned\" value=\"$arg_lu_alias\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@list) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    # Partner LU name
    print "<tr><td>Partner LU name :</td> <td><select name=\"partner_lu_name\" class=\"rightAligned\" value=\"$arg_partner_lu_name\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@plulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  Mode
    print "<tr><td>Mode :</td> <td><select name=\"mode_name\" class=\"rightAligned\" value=\"$arg_mode_name\" >  ";
    foreach $line (@modelist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  TP name type
    print "<tr><td>TP name type : </td> <td> <select name=\"tp_name_type\" class=\"rightAligned\" value=\"$arg_tp_name_type\" >  ";
    print "<option value=\"APPLICATION_TP\" selected=\"selected\">APPLICATION_TP</option> ";
    print "<option value=\"SNA_SERVICE_TP\">SNA_SERVICE_TP</option></select></td></tr>";
    
    #   TP name
    print "<tr><td> TP name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tp_name\" maxlength=\"64\" value=\"$arg_tp_name\" /></td></tr>";
    
    #   Conversation security
    print "<tr><td> Conversation security : </td> <td> <select name=\"conversation_security_type\" class=\"rightAligned\" value=\"$arg_conversation_security_type\" >  ";
    print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
    print "<option value=\"PROGRAM\">PROGRAM</option> ";
    print "<option value=\"PROGRAM_STRONG\">PROGRAM_STRONG</option> ";
    print "<option value=\"SAME\">SAME</option></select></td></tr>";
    
    #   User ID
    print "<tr><td>User ID : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"security_user_id\" maxlength=\"10\" value=\"$arg_security_user_id\" /></td></tr>";
    
    #   Password
    print "<tr><td>Password : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"security_password\" maxlength=\"10\" value=\"$arg_security_password\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_sym_dest_name=param('sym_dest_name_unique');
   $arg_description=param('description');
   $arg_lu_alias=param('lu_alias');
   $arg_partner_lu_name=param('partner_lu_name');
   $arg_mode_name=param('mode_name');
   $arg_tp_name_type=param('tp_name_type');
   $arg_tp_name=param('tp_name');
   $arg_conversation_security_type=param('conversation_security_type');
   $arg_security_user_id=param('security_user_id');
   $arg_security_password=param('security_password');

    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_security_password eq "") {
        $security_password="";
    }else
    {
        $security_password=",security_password=$arg_security_password";
    }

    if ($arg_security_user_id eq "") {
        $security_user_id="";
    }else
    {
        $security_user_id=",security_user_id=$arg_security_user_id";
    }
    
    if ($arg_lu_alias eq "") {
        $lu_alias="";
    }else
    {
        $lu_alias=",lu_alias=$arg_lu_alias";
    }
    
    if ($arg_tp_name eq "") {
        $tp_name="";
    }else
    {
        $tp_name=",tp_name=$arg_tp_name";
    }
    
    if ($arg_mode_name eq "") {
        $mode_name="";
    }else
    {
        $mode_name=",mode_name=$arg_mode_name";
    }
    
    if ($arg_partner_lu_name eq "") {
        $partner_lu_name="";
    }else
    {
        $partner_lu_name=",partner_lu_name=$arg_partner_lu_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_cpic_side_info,sym_dest_name=$arg_sym_dest_name, conversation_security_type=$arg_conversation_security_type, tp_name_type=$arg_tp_name_type $description $mode_name $tp_name $partner_lu_name $lu_alias $security_user_id  $security_password`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_cpic_side_info,sym_dest_name=$arg_sym_dest_name, conversation_security_type=$arg_conversation_security_type, tp_name_type=$arg_tp_name_type $description $mode_name $tp_name $partner_lu_name $lu_alias $security_user_id  $security_password";
   
   print "Display Output from Add Side Information:";
    
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        $line=~s/ /&nbsp;/g;
        print "<br>$line";
     }
}
#

exit 0; 

