#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg_fqplu_name, $arg_description, $arg_plu_alias, $arg_plu_un_name, $arg_parallel_sess_supp, $arg_max_mc_ll_send_size, $arg_conv_security_ver, $max_mc_ll_send_size, $plu_un_name, $description, $time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_fqplu_name=param('fqplu_name_unique');

if ($arg_fqplu_name eq "") {
    $arg_description="";
    $arg_plu_alias="";
    $arg_parallel_sess_supp="YES";
    $arg_plu_un_name="";
    $arg_conv_security_ver="NO";
    $arg_max_mc_ll_send_size="0";
    
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  Alias
    print "<tr><td>* Alias :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"plu_alias\" maxlength=\"8\" value=\"$arg_plu_alias\" required=\"required\" /></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Fully-qualified LU name
    print "<tr><td>* Fully-qualified LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fqplu_name_unique\" maxlength=\"17\" value=\"$arg_fqplu_name\" required=\"required\" /></td></tr>";
    
    #  Uninterpreted LU name
    print "<tr><td>Uninterpreted LU name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"plu_un_name\" maxlength=\"8\" value=\"$arg_plu_un_name\"/></td></tr>";
    
    #  Parallel sessions supported?
    print "<tr><td> Parallel sessions supported ?</td> <td> <select name=\"parallel_sess_supp\" class=\"rightAligned\" value=\"$arg_parallel_sess_supp\" >  ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option></select></td></tr>";
    
    #   Maximum size of logical records
     print "<tr><td>Maximum size of logical records(0-32767) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_mc_ll_send_size\" maxlength=\"5\" value=\"$arg_max_mc_ll_send_size\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   conv. security already verified supported?
    print "<tr><td>conv. security already verified supported ? </td> <td><select name=\"conv_security_ver\" class=\"rightAligned\" value=\"$arg_conv_security_ver\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option></select></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_fqplu_name=param('fqplu_name_unique');
   $arg_description=param('description');
   $arg_plu_alias=param('plu_alias');
   $arg_plu_un_name=param('plu_un_name');
   $arg_parallel_sess_supp=param('parallel_sess_supp');
   $arg_max_mc_ll_send_size=param('max_mc_ll_send_size');
   $arg_conv_security_ver=param('conv_security_ver');

#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }

    if ($arg_max_mc_ll_send_size eq "") {
        $max_mc_ll_send_size="";
    }else
    {
        $max_mc_ll_send_size=",max_mc_ll_send_size=$arg_max_mc_ll_send_size";
    }

    if ($arg_plu_un_name eq "") {
        $plu_un_name="";
    }else
    {
        $plu_un_name=",plu_un_name=$arg_plu_un_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_partner_lu,fqplu_name=$arg_fqplu_name, plu_alias=$arg_plu_alias, parallel_sess_supp=$arg_parallel_sess_supp, conv_security_ver=$arg_conv_security_ver $description $plu_un_name $max_mc_ll_send_size`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_partner_lu,fqplu_name=$arg_fqplu_name, plu_alias=$arg_plu_alias, parallel_sess_supp=$arg_parallel_sess_supp, conv_security_ver=$arg_conv_security_ver $description $plu_un_name $max_mc_ll_send_size";
   
   print "Display Output from LU 6.2 Partner LU :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

