#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_pool_name, $arg_description, $arg_lu_name,  $description, $lu_name,
    $time, $line, @data, @contents, @lulist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_pool_name=param('pool_name_unique');

if ($arg_pool_name eq "") {
   
    $arg_description="";
    $arg_lu_name="";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3 -d`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~/^lu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            $lu_name=$data[1];
            next;
        }elsif ($line=~m/pool_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if($data[1]=~m/""/)
            {
               push @lulist, $lu_name;
            }
            next;
        }
    }
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 5px;\"> ";
    print "<tbody> ";
    
    #   * Pool name
   print "<tr> <td>* Pool name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"pool_name_unique\"  maxlength=\"8\" value=\"$arg_pool_name\" required=\"required\" /></td></tr>";
    
    #   Description
   print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  LU name
    print "<tr><td>LU name :</td> <td><select name=\"lu_name\" class=\"rightAligned\" value=\"$arg_lu_name\" >  ";
    print "<option value=\"\" selected=\"selected\" ></option> ";
    foreach $line (@lulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";

    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
   
} else {
  
   $arg_description=param('description');
   $arg_lu_name=param('lu_name');
  
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_lu_name eq "") {
        $lu_name="";
    }else
    {
        $lu_name=",lu_name=$arg_lu_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_pool, pool_name=$arg_pool_name $description $lu_name`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_pool, pool_name=$arg_pool_name $description $lu_name";
   
   print "<br> Display Output from Add LU Pool:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

