#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_ee_port_name, $arg_description, $arg_ip_version,$arg_dlc_name, $arg_initially_active, $arg_implicit_uplink_to_en, $arg_max_rcv_btu_size, $arg_tot_link_act_lim,$arg_local_ip_interface, $description, $dlc_name, $local_ip_interface,$max_rcv_btu_size, $tot_link_act_lim,$ip_version, $len,$time, $line, @data, @contents, @dlclist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "Failed to access the node. \n";
        exit -1;
    }
}

$arg_ee_port_name=param('eeportname_unique');

if ($arg_ee_port_name eq "") {
    $arg_description="";
    $arg_dlc_name="";
    $arg_initially_active="YES";
    $arg_ip_version="IPV4";
    $arg_max_rcv_btu_size="1461";
    $arg_tot_link_act_lim="1";
    $arg_implicit_uplink_to_en="NO";
    $arg_local_ip_interface="";
    
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlc`;
   foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/dlc_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            $dlc_name= $data[1];
            next;
        }elsif ($line=~m/dlc_type/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($data[1]=~m/HPRIP/) {
                 push @dlclist, $dlc_name;
            }
            next;
        }
   }
    
   $len=@dlclist;
    if($len eq 0){
        print "<br> Enterprise Extender DLC should be defined before define Enterprise Extender Port. ";
        exit 1;
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  Port name
    print "<tr><td>* Port name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"eeportname_unique\" maxlength=\"8\" value=\"$arg_ee_port_name\" required=\"required\" /></td></tr>";
    
    #  Protocol
    print "<tr><td>Protocol : </td> <td><select name=\"ip_version\" class=\"rightAligned\" value=\"$arg_ip_version\" >  ";
    print "<option value=\"IPV4\" selected=\"selected\">IPV4</option> ";
    print "<option value=\"IPV6\">IPV6</option> ";
    print "</select></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   DLC Name
   print "<tr><td>DLC Name :</td> <td><select name=\"dlc_name\" class=\"rightAligned\" value=\"$arg_dlc_name\" >  ";
   foreach $line (@dlclist) {
       print "<option value=\"$line\">$line</option> ";
    }
   print "</select></td></tr>";
    
    #  Initially active?
   print "<tr><td>Initially active ? </td> <td> <select name=\"initially_active\" class=\"rightAligned\" value=\"$arg_initially_active\" >  ";
   print "<option value=\"YES\" selected=\"selected\">YES</option> ";
   print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Maximum BTU size allowed
    print "<tr><td>Maximum BTU size allowed(265-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_rcv_btu_size\" maxlength=\"5\" value=\"$arg_max_rcv_btu_size\" /></td></tr>";
    
    #   Maximum number of active links allowed
    print "<tr><td>Maximum number of active links allowed(0-4096) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tot_link_act_lim\" maxlength=\"4\" value=\"$arg_tot_link_act_lim\" /></td></tr>";
    
    #   Implicit links to end nodes are uplinks?
    print "<tr><td>Implicit links to end nodes are uplinks ? </td> <td><select name=\"implicit_uplink_to_en\" class=\"rightAligned\" value=\"$arg_implicit_uplink_to_en\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

    #  Local IP interface
    print "<tr><td>Local IP interface : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"local_ip_interface\" maxlength=\"45\" value=\"$arg_local_ip_interface\" /></td></tr>";

    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_ee_port_name=param('eeportname_unique');
   $arg_description=param('description');
   $arg_dlc_name=param('dlc_name');
   $arg_initially_active=param('initially_active');
   $arg_local_ip_interface=param('local_ip_interface');
   $arg_implicit_uplink_to_en=param('implicit_uplink_to_en');
   $arg_max_rcv_btu_size=param('max_rcv_btu_size');
   $arg_tot_link_act_lim=param('tot_link_act_lim');
   $arg_ip_version=param('ip_version');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_local_ip_interface eq "") {
        $local_ip_interface="";
    }else
    {
        $local_ip_interface=",local_ip_interface=$arg_local_ip_interface";
    }
    
    if ($arg_max_rcv_btu_size eq "") {
        $max_rcv_btu_size="";
    }else
    {
        $max_rcv_btu_size=",max_rcv_btu_size=$arg_max_rcv_btu_size";
    }
    
    if ($arg_tot_link_act_lim eq "") {
        $tot_link_act_lim="";
    }else
    {
        $tot_link_act_lim=",tot_link_act_lim=$arg_tot_link_act_lim";
    }
    
    if ($arg_ip_version eq "") {
        $ip_version="";
    }else
    {
        $ip_version=",ip_version=$arg_ip_version";
    }
    

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_port,port_name= $arg_ee_port_name, dlc_name=$arg_dlc_name, initially_active=$arg_initially_active, implicit_uplink_to_en=$arg_implicit_uplink_to_en $ip_version $description $local_ip_interface  $max_rcv_btu_size $tot_link_act_lim  `;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_port,port_name= $arg_ee_port_name, dlc_name=$arg_dlc_name  , initially_active=$arg_initially_active  , implicit_uplink_to_en=$arg_implicit_uplink_to_en $ip_version $description $local_ip_interface  $max_rcv_btu_size $tot_link_act_lim ";
   
# Display output of snaadmin query_node
   print "Display Output from Add Enterprise Extender Port:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

