#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_ee_dlc_name, $arg_description,  $arg_initially_active, $arg_udp_port_llc, $arg_udp_port_network, $arg_udp_port_high, $arg_udp_port_medium, $arg_udp_port_low, $description, $udp_port_network,$udp_port_llc,$udp_port_high,$udp_port_medium,$udp_port_low, $time, $line, @data, @contents, @listing);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "Failed to access the node. \n";
        exit -1;
    }
}

$arg_ee_dlc_name=param('eedlcname_unique');

if ($arg_ee_dlc_name eq "") {
    $arg_udp_port_llc="12000";
    $arg_udp_port_network="12001";
    $arg_udp_port_high="12002";
    $arg_udp_port_medium="12003";
    $arg_udp_port_low="12004";
    $arg_description="";
    $arg_initially_active="YES";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";

   # Define DLC name
   print "<tr> <td>* DLC name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"eedlcname_unique\"  maxlength=\"8\" value=\"$arg_ee_dlc_name\" required=\"required\" /></td></tr>";
    #   Define Description field
   print "<tr> <td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\" maxlength=\"31\" value=\"$arg_description\" /></td></tr>";

    #   Define Initially active?
   print "<tr> <td>Initially active ?</td> <td><select name=\"initially_active\" class=\"rightAligned\" value=\"$arg_initially_active\" > ";
   print "<option value=\"YES\" selected=\"selected\">YES</option> ";
   print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   LLC UDP port number
    print "<tr> <td>LLC UDP port number(0-65535) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_llc\"  maxlength=\"5\"  value=\"$arg_udp_port_llc\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Network UDP port number
    print "<tr> <td>Network UDP port number(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_network\"  maxlength=\"5\"  value=\"$arg_udp_port_network\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   High UDP port number
    print "<tr> <td>High UDP port number(0-65535)  : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_high\"  maxlength=\"5\"  value=\"$arg_udp_port_high\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Medium UDP port number
    print "<tr> <td>Medium UDP port number(0-65535) :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"udp_port_medium\"  maxlength=\"5\"  value=\"$arg_udp_port_medium\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Low UDP port number
    print "<tr> <td>Low UDP port number(0-65535) :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"udp_port_low\"  maxlength=\"5\"  value=\"$arg_udp_port_low\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
   $arg_ee_dlc_name=param('eedlcname_unique');
   $arg_description=param('description');
   $arg_initially_active=param('initially_active');
   $arg_udp_port_llc=param('udp_port_llc');
   $arg_udp_port_network=param('udp_port_network');
   $arg_udp_port_high=param('udp_port_high');
   $arg_udp_port_medium=param('udp_port_medium');
   $arg_udp_port_low=param('udp_port_low');
    
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_udp_port_network eq "") {
        $udp_port_network="";
    }else
    {
        $udp_port_network=",udp_port_network=$arg_udp_port_network";
    }
    
    if ($arg_udp_port_llc eq "") {
        $udp_port_llc="";
    }else
    {
        $udp_port_llc=",udp_port_llc=$arg_udp_port_llc";
    }
    if ($arg_udp_port_high eq "") {
        $udp_port_high="";
    }else
    {
        $udp_port_high=",udp_port_high=$arg_udp_port_high";
    }
    
    if ($arg_udp_port_medium eq "") {
        $udp_port_medium="";
    }else
    {
        $udp_port_medium=",udp_port_medium=$arg_udp_port_medium";
    }
    
    if ($arg_udp_port_low eq "") {
        $udp_port_low="";
    }else
    {
        $udp_port_low=",udp_port_low=$arg_udp_port_low";
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_dlc,dlc_name=$arg_ee_dlc_name, initially_active=$arg_initially_active $udp_port_llc $udp_port_network $udp_port_high $udp_port_medium $udp_port_low $description`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_dlc,dlc_name=$arg_ee_dlc_name, initially_active=$arg_initially_active $udp_port_llc $udp_port_network $udp_port_high $udp_port_medium $udp_port_low $description";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add Enterprise Extender DLC:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

