#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_resource_name, $arg_description, $arg_resource_type, $arg_parent_name, $arg_parent_type, $description, $parent_name, $time, $line, @data, @contents, @list);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_resource_name=param('resource_name_unique');

if ($arg_resource_name eq "") {
    $arg_description="";
    $arg_parent_name="";
    $arg_resource_type="LU_RESOURCE";
    $arg_parent_type="ENCP_RESOURCE";

    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  * Resource name
    print "<tr><td>* Resource name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"resource_name_unique\" maxlength=\"17\" value=\"$arg_resource_name\" required=\"required\" /></td></tr>";
    
    #  Resource type
    print "<tr><td>Resource type : </td> <td><select name=\"resource_type\" class=\"rightAligned\" value=\"$arg_resource_type\" >  ";
    print "<option value=\"LU_RESOURCE\" selected=\"selected\">LU_RESOURCE</option> ";
    print "<option value=\"ENCP_RESOURCE\">ENCP_RESOURCE</option>";
    print "<option value=\"NNCP_RESOURCE\">NNCP_RESOURCE</option>";
    print "<option value=\"WILDCARD_LU_RESOURCE\">WILDCARD_LU_RESOURCE</option></select></td></tr>";
    
    #  Description
    print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   Parent name
        print "<tr><td>Parent name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"parent_name\" maxlength=\"17\" value=\"$arg_parent_name\"/></td></tr>";
    
    #   Parent type
    print "<tr><td>Parent type : </td> <td><select name=\"parent_type\" class=\"rightAligned\" value=\"$arg_parent_type\" >  ";
    print "<option value=\"ENCP_RESOURCE\" selected=\"selected\">ENCP_RESOURCE</option> ";
    print "<option value=\"NNCP_RESOURCE\">NNCP_RESOURCE</option></select></td></tr>";
    
    print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_resource_name=param('resource_name_unique');
   $arg_resource_type=param('resource_type');
   $arg_description=param('description');
   $arg_parent_name=param('parent_name');
   $arg_parent_type=param('parent_type');
   
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_parent_name eq "") {
        $parent_name="";
    }else
    {
        $parent_name=",parent_name=$arg_parent_name";
    }
    
   
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_directory_entry, resource_name=$arg_resource_name, resource_type=$arg_resource_type, parent_type=$arg_parent_type $parent_name $description`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_directory_entry, resource_name=$arg_resource_name, resource_type=$arg_resource_type, parent_type=$arg_parent_type $parent_name $description";
   
    print "Display Output from Add Partner LU:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

