#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_node_all to get 
#  list of domain servers, then search servers and display PU status
#  for PU specified in argument
#

use strict;

 my ( $srv_index, $srvcnt, $pusrvcnt, $state, $plu_status, $dlus_defined_name,
      $dlus_active_name, $puname, $dlusname, $pustate, $dlusstatus, $found_index,
      $input_puname, $input_pustate, $total_cnt_pus, $pu_id, 
      @servername, @puservername, @puserverindex, @pucount, @data, @status);

#  Initialize for scalar declaration
$srvcnt = 0;
$pusrvcnt = 0;
$srv_index = 0;
$total_cnt_pus = 0;
$input_pustate = 0;   #  Inactive 

if ($#ARGV < 0)    # Check for input argument on line
{
   print ("\n   No PU to start provided as input parameter. \n");
   $input_puname = "[]";      # set input_puname to something a PU cannot be
}else {
   $input_puname = $ARGV[0];
   printf("\n Searching for PU %s in the following domain servers:\n\n",$input_puname);
}


@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information


foreach(@status) {
   chomp;
   if (/^query_ls/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get name of each domain server   
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
print "\n------------------------------------------------\n";
   
#
#  Process the DLUR PU information
#

while ($srv_index < $srvcnt) 
{
   $pucount[$srv_index]=0;  # Initialize count of PUs on this server

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_dlur_pu` or die "Node $servername[$srv_index] not recognized $!\n";

   foreach(@status) {
      chomp;
      if (/^query_node_limit/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

     #  Skip headers
     next if (/^------/);
     next if (/^list_option/);
     next if (/^filter/);
     next if (/^\n/);

     @data = split(/=/,$_);   #Break parameter = value

     next if (@data == 0);        # on blank line, skip

# debug   print "line: $srv_index:", @data;

     if ($data[0]=~m/^pu_name/) {       # get DLUR PU name  
        $puname = $data[1];    #  save PU name
        $puname=~s/ //g;       # remove any spaces as end
        if ($input_puname=~m/$puname/) {
           $puserverindex[$pusrvcnt] = $srv_index;   # Save the index into server list
           $pusrvcnt++;
        } 
        $pucount[$srv_index]++;    # Array of counts for PUs on each server
        $total_cnt_pus++;
#  printf ("  PU Name: %8s \n", $puname);
        next;   
     } elsif (!($input_puname=~m/$puname/)) {  # only look for the PU name provided
        next;
     } elsif ($data[0]=~m/^defined_dlus_name/) { # Defined DLUS
        $dlus_defined_name = $data[1];    #  save defined DLUS name
        $dlus_defined_name=~s/ //g;       # remove any spaces as end
        next;                              
     } elsif ($data[0]=~m/^active_dlus_name/) { # Determined Active DLUS
        $dlus_active_name = $data[1];    #  save Active DLUS name
        $dlus_active_name=~s/ //g;       # remove any spaces as end
        next;             
     } elsif ($data[0]=~m/^pu_status/) { # PU state ... needs to be ACTIVE
        $pustate = $data[1];    #  save PU State
        $pustate=~s/ //g;       # remove any spaces as end 
        if ($data[1]=~m/ACTIVE/) {      # If active, set active, else use defined
           $dlusname = $dlus_active_name;
           if ($input_puname=~m/$puname/) {  # if this is the PU and it is active
                 $input_pustate = $srv_index+1;   # set the index + 1 to flag it. 
           } 
        } else {  
           $dlusname = $dlus_defined_name;
        }
        next;  
     } elsif ($data[0]=~m/^pu_id/) { # Needs to be ACTIVE
         $pu_id = $data[1];
     } elsif ($data[0]=~m/^dlus_session_status/) { # Needs to be ACTIVE
         if ($data[1]=~m/_ACTIVE/) {  
            $dlusstatus = "Inactive";
         } elsif ($data[1]=~m/ACTIVE/) {
            $dlusstatus = "Active"
         } 
#   Print header line
         printf("\n      Server: %s\n", $servername[$srv_index]);
         print "----------- ----------------- --------  --------- \n";
         print "    DLUR        DLUS \n";
         print "     PU         name             State   PU_id \n";
         print "----------- ----------------- --------  --------- \n";         
         printf("   %8s %17s %8s %8s\n",
               $puname, $dlusname, $dlusstatus,$pu_id);           
    } else {
        next;
    }

  }
  $srv_index++;
#  print "\n-------------------------------------------\n";

}

if ($pusrvcnt == 0) {
  printf("\n  PU %s not found in domain of servers.\n", $input_puname);
}
else
{
  printf("\n   PU %s found on %d server(s)\n", $input_puname, $pusrvcnt);
}
print "\n------------------------------------------------\n";

